/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractLongSet
extends AbstractSet {
    public boolean contains(final long key) {
        return !this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractLongSet copy() {
        return (AbstractLongSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongSet)) {
            return false;
        }
        final AbstractLongSet other = (AbstractLongSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                return other.contains(key);
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(long var1);

    public abstract boolean remove(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

