/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.LongIntProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractLongIntMap
extends AbstractSet {
    public boolean containsKey(final long key) {
        return !this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final int value) {
        return !this.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long iterKey, int iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractLongIntMap copy() {
        return (AbstractLongIntMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractLongIntMap)) {
            return false;
        }
        final AbstractLongIntMap other = (AbstractLongIntMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long key, int value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long key, int value) {
                return AbstractLongIntMap.this.containsKey(key) && AbstractLongIntMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongIntProcedure procedure) {
        return this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                return procedure.apply(key, AbstractLongIntMap.this.get(key));
            }
        });
    }

    public abstract int get(long var1);

    public LongArrayList keys() {
        LongArrayList list = new LongArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final LongArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList keyList) {
        this.pairsSortedByValue(keyList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final LongIntProcedure condition, final LongArrayList keyList, final IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new LongIntProcedure(){

            @Override
            public boolean apply(long key, int value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(LongArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final long[] k = keyList.elements();
        final int[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                int t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                long t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(long var1, int var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        LongArrayList theKeys = new LongArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            long key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public IntArrayList values() {
        IntArrayList list = new IntArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final IntArrayList list) {
        list.clear();
        this.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long key) {
                list.add(AbstractLongIntMap.this.get(key));
                return true;
            }
        });
    }

    public int adjustOrPutValue(long key, int newValue, int incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

