/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.IntObjectProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractIntObjectMap<T>
extends AbstractSet {
    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final T value) {
        return !this.forEachPair(new IntObjectProcedure<T>(){

            @Override
            public boolean apply(int iterKey, Object iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntObjectMap<T> copy() {
        return (AbstractIntObjectMap)this.getClass().cast(this.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntObjectMap)) {
            return false;
        }
        final AbstractIntObjectMap other = (AbstractIntObjectMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int key, Object value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntObjectProcedure(){

            public boolean apply(int key, Object value) {
                return AbstractIntObjectMap.this.containsKey(key) && AbstractIntObjectMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntObjectProcedure<T> procedure) {
        return this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntObjectMap.this.get(key));
            }
        });
    }

    public abstract T get(int var1);

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new ArrayList(this.size()));
    }

    public void pairsMatching(final IntObjectProcedure<T> condition, final IntArrayList keyList, final List<T> valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntObjectProcedure<T>(){

            @Override
            public boolean apply(int key, T value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        keyList.sort();
        Object[] tempValueList = new Object[keyList.size()];
        int i = keyList.size();
        while (--i >= 0) {
            tempValueList[i] = this.get(keyList.getQuick(i));
        }
        valueList.clear();
        for (Object value : tempValueList) {
            valueList.add(value);
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, List<T> valueList) {
        this.keys(keyList);
        this.values(valueList);
        if (!valueList.isEmpty() && !(valueList.get(0) instanceof Comparable)) {
            throw new UnsupportedOperationException("Cannot sort the values; " + valueList.get(0).getClass() + " does not implement Comparable");
        }
        final int[] k = keyList.elements();
        final List<T> valueRef = valueList;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object t1 = valueRef.get(a);
                valueRef.set(a, valueRef.get(b));
                valueRef.set(b, t1);
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                int ab = ((Comparable)valueRef.get(a)).compareTo(valueRef.get(b));
                return ab < 0 ? -1 : (ab > 0 ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, T var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        theKeys.sort();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public List<T> values() {
        ArrayList list = new ArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final List<T> list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(AbstractIntObjectMap.this.get(key));
                return true;
            }
        });
    }
}

