/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.MurmurHash;
import org.apache.mahout.math.Vector;

public class RandomTrinaryMatrix
extends AbstractMatrix {
    private static final AtomicInteger id = new AtomicInteger();
    private static final int PRIME1 = 104047;
    private static final int PRIME2 = 101377;
    private static final int PRIME3 = 64661;
    private static final long SCALE = 0x100000000L;
    private final int seed;
    private boolean highQuality = false;

    public RandomTrinaryMatrix(int seed, int rows, int columns, boolean highQuality) {
        super(rows, columns);
        this.highQuality = highQuality;
        this.seed = seed;
    }

    public RandomTrinaryMatrix(int rows, int columns) {
        this(id.incrementAndGet(), rows, columns, false);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Can't assign to read-only matrix");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Can't assign to read-only matrix");
    }

    @Override
    public double getQuick(int row, int column) {
        if (this.highQuality) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putInt(row);
            buf.putInt(column);
            buf.flip();
            return (double)(MurmurHash.hash64A(buf, this.seed) & 0xFFFFFFFFL) / 4.294967296E9;
        }
        return (double)(row * 104047 + column * 101377 + row * column * 64661 & 8) * 0.25 - 1.0;
    }

    @Override
    public Matrix like() {
        return new DenseMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        throw new UnsupportedOperationException("Can't assign to read-only matrix");
    }

    @Override
    public int[] getNumNondefaultElements() {
        throw new UnsupportedOperationException("Can't assign to read-only matrix");
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        return new MatrixView(this, offset, size);
    }
}

