/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.QueryUtils;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.junit.Assert;

public class CheckHits {
    private static final Pattern COMPUTED_FROM_PATTERN = Pattern.compile(".*, computed as .* from:");

    public static void checkNoMatchExplanations(Query q, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        String d = q.toString(defaultFieldName);
        TreeSet<Integer> ignore = new TreeSet<Integer>();
        for (int i = 0; i < results.length; ++i) {
            ignore.add(results[i]);
        }
        int maxDoc = searcher.getIndexReader().maxDoc();
        for (int doc = 0; doc < maxDoc; ++doc) {
            if (ignore.contains(doc)) continue;
            Explanation exp = searcher.explain(q, doc);
            Assert.assertNotNull((String)("Explanation of [[" + d + "]] for #" + doc + " is null"), (Object)exp);
            Assert.assertFalse((String)("Explanation of [[" + d + "]] for #" + doc + " doesn't indicate non-match: " + exp.toString()), (boolean)exp.isMatch());
        }
    }

    public static void checkHitCollector(Random random, Query query, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        QueryUtils.check(random, query, searcher);
        TreeSet<Integer> correct = new TreeSet<Integer>();
        for (int i = 0; i < results.length; ++i) {
            correct.add(results[i]);
        }
        Set actual = (Set)searcher.search(query, (CollectorManager)new SetCollectorManager());
        Assert.assertEquals((String)("Simple: " + query.toString(defaultFieldName)), correct, (Object)actual);
        for (int i = -1; i < 2; ++i) {
            actual.clear();
            IndexSearcher s = QueryUtils.wrapUnderlyingReader(random, searcher, i);
            actual = (Set)s.search(query, (CollectorManager)new SetCollectorManager());
            Assert.assertEquals((String)("Wrap Reader " + i + ": " + query.toString(defaultFieldName)), correct, (Object)actual);
        }
    }

    public static void checkHits(Random random, Query query, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        ScoreDoc[] hits = searcher.search((Query)query, (int)Math.max((int)10, (int)(results.length * 2))).scoreDocs;
        TreeSet<Integer> correct = new TreeSet<Integer>();
        for (int result : results) {
            correct.add(result);
        }
        TreeSet<Integer> actual = new TreeSet<Integer>();
        for (ScoreDoc hit : hits) {
            actual.add(hit.doc);
        }
        Assert.assertEquals((String)query.toString(defaultFieldName), correct, actual);
        QueryUtils.check(random, query, searcher, LuceneTestCase.rarely(random));
    }

    public static void checkDocIds(String mes, int[] results, ScoreDoc[] hits) {
        Assert.assertEquals((String)(mes + " nr of hits"), (long)hits.length, (long)results.length);
        for (int i = 0; i < results.length; ++i) {
            Assert.assertEquals((String)(mes + " doc nrs for hit " + i), (long)results[i], (long)hits[i].doc);
        }
    }

    public static void checkHitsQuery(Query query, ScoreDoc[] hits1, ScoreDoc[] hits2, int[] results) {
        CheckHits.checkDocIds("hits1", results, hits1);
        CheckHits.checkDocIds("hits2", results, hits2);
        CheckHits.checkEqual(query, hits1, hits2);
    }

    public static void checkEqual(Query query, ScoreDoc[] hits1, ScoreDoc[] hits2) {
        float scoreTolerance = 1.0E-6f;
        if (hits1.length != hits2.length) {
            Assert.fail((String)("Unequal lengths: hits1=" + hits1.length + ",hits2=" + hits2.length));
        }
        for (int i = 0; i < hits1.length; ++i) {
            if (hits1[i].doc != hits2[i].doc) {
                Assert.fail((String)("Hit " + i + " docnumbers don't match\n" + CheckHits.hits2str(hits1, hits2, 0, 0) + "for query:" + query.toString()));
            }
            if (hits1[i].doc == hits2[i].doc && !(Math.abs(hits1[i].score - hits2[i].score) > 1.0E-6f)) continue;
            Assert.fail((String)("Hit " + i + ", doc nrs " + hits1[i].doc + " and " + hits2[i].doc + "\nunequal       : " + hits1[i].score + "\n           and: " + hits2[i].score + "\nfor query:" + query.toString()));
        }
    }

    public static String hits2str(ScoreDoc[] hits1, ScoreDoc[] hits2, int start, int end) {
        int len2;
        StringBuilder sb = new StringBuilder();
        int len1 = hits1 == null ? 0 : hits1.length;
        int n = len2 = hits2 == null ? 0 : hits2.length;
        if (end <= 0) {
            end = Math.max(len1, len2);
        }
        sb.append("Hits length1=").append(len1).append("\tlength2=").append(len2);
        sb.append('\n');
        for (int i = start; i < end; ++i) {
            sb.append("hit=").append(i).append(':');
            if (i < len1) {
                sb.append(" doc").append(hits1[i].doc).append('=').append(hits1[i].score).append(" shardIndex=").append(hits1[i].shardIndex);
            } else {
                sb.append("               ");
            }
            sb.append(",\t");
            if (i < len2) {
                sb.append(" doc").append(hits2[i].doc).append('=').append(hits2[i].score).append(" shardIndex=").append(hits2[i].shardIndex);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String topdocsString(TopDocs docs, int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopDocs totalHits=").append(docs.totalHits).append(" top=").append(docs.scoreDocs.length).append('\n');
        end = end <= 0 ? docs.scoreDocs.length : Math.min(end, docs.scoreDocs.length);
        for (int i = start; i < end; ++i) {
            sb.append('\t');
            sb.append(i);
            sb.append(") doc=");
            sb.append(docs.scoreDocs[i].doc);
            sb.append("\tscore=");
            sb.append(docs.scoreDocs[i].score);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void checkExplanations(Query query, String defaultFieldName, IndexSearcher searcher) throws IOException {
        CheckHits.checkExplanations(query, defaultFieldName, searcher, false);
    }

    public static void checkExplanations(final Query query, final String defaultFieldName, final IndexSearcher searcher, final boolean deep) throws IOException {
        searcher.search(query, (CollectorManager)new CollectorManager<ExplanationAsserter, Void>(){

            public ExplanationAsserter newCollector() {
                return new ExplanationAsserter(query, defaultFieldName, searcher, deep);
            }

            public Void reduce(Collection<ExplanationAsserter> collectors) {
                return null;
            }
        });
    }

    public static void checkMatches(final Query query, final IndexSearcher searcher) throws IOException {
        searcher.search(query, (CollectorManager)new CollectorManager<MatchesAsserter, Void>(){

            public MatchesAsserter newCollector() throws IOException {
                return new MatchesAsserter(query, searcher);
            }

            public Void reduce(Collection<MatchesAsserter> collectors) {
                return null;
            }
        });
    }

    public static void verifyExplanation(String q, int doc, float score, boolean deep, Explanation expl) {
        float value = expl.getValue().floatValue();
        try {
            Assert.assertEquals((double)score, (double)value, (double)0.0);
        }
        catch (Exception e) {
            Assert.fail((String)(q + ": score(doc=" + doc + ")=" + score + " != explanationScore=" + value + " Explanation: " + String.valueOf(expl)));
        }
        if (!deep) {
            return;
        }
        Explanation[] detail = expl.getDetails();
        if (expl.getDescription().endsWith("computed from:")) {
            return;
        }
        String descr = expl.getDescription().toLowerCase(Locale.ROOT);
        if (descr.startsWith("score based on ") && descr.contains("child docs in range")) {
            Assert.assertTrue((String)"Child doc explanations are missing", (detail.length > 0 ? 1 : 0) != 0);
        }
        if (detail.length > 0) {
            if (detail.length == 1 && !COMPUTED_FROM_PATTERN.matcher(descr).matches()) {
                if (!(expl.getDescription().endsWith("with freq of:") || !(score >= 0.0f) && expl.getDescription().endsWith("times others of:"))) {
                    CheckHits.verifyExplanation(q, doc, score, deep, detail[0]);
                }
            } else {
                float combined;
                int k1;
                float x = 0.0f;
                boolean productOf = descr.endsWith("product of:");
                boolean sumOf = descr.endsWith("sum of:");
                boolean maxOf = descr.endsWith("max of:");
                boolean computedOf = descr.indexOf("computed as") > 0 && COMPUTED_FROM_PATTERN.matcher(descr).matches();
                boolean maxTimesOthers = false;
                if (!(productOf || sumOf || maxOf || computedOf || (k1 = descr.indexOf("max plus ")) < 0)) {
                    int k2 = descr.indexOf(" ", k1 += "max plus ".length());
                    try {
                        x = Float.parseFloat(descr.substring(k1, k2).trim());
                        if (descr.substring(k2).trim().equals("times others of:")) {
                            maxTimesOthers = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!(productOf || sumOf || maxOf || computedOf || maxTimesOthers)) {
                    Assert.fail((String)(q + ": multi valued explanation description=\"" + descr + "\" must be 'max of plus x times others', 'computed as x from:' or end with 'product of' or 'sum of:' or 'max of:' - " + String.valueOf(expl)));
                }
                double sum = 0.0;
                float product = 1.0f;
                float max = Float.NEGATIVE_INFINITY;
                double maxError = 0.0;
                for (int i = 0; i < detail.length; ++i) {
                    float dval = detail[i].getValue().floatValue();
                    CheckHits.verifyExplanation(q, doc, dval, deep, detail[i]);
                    product *= dval;
                    sum += (double)dval;
                    max = Math.max(max, dval);
                    if (!sumOf) continue;
                    maxError += (double)(Math.ulp(dval) * 2.0f);
                }
                if (productOf) {
                    combined = product;
                } else if (sumOf) {
                    combined = (float)sum;
                } else if (maxOf) {
                    combined = max;
                } else if (maxTimesOthers) {
                    combined = (float)((double)max + (double)x * (sum - (double)max));
                } else {
                    Assert.assertTrue((String)"should never get here!", (boolean)computedOf);
                    combined = value;
                }
                try {
                    Assert.assertEquals((double)combined, (double)value, (double)maxError);
                }
                catch (Exception e) {
                    Assert.fail((String)(q + ": actual subDetails combined==" + combined + " != value=" + value + " Explanation: " + String.valueOf(expl)));
                }
            }
        }
    }

    public static void checkTopScores(Random random, Query query, IndexSearcher searcher) throws IOException {
        CheckHits.doCheckTopScores(query, searcher, 1);
        CheckHits.doCheckTopScores(query, searcher, 10);
        CheckHits.doCheckMaxScores(random, query, searcher);
    }

    private static void doCheckTopScores(Query query, IndexSearcher searcher, int numHits) throws IOException {
        CollectorManager complete = TopScoreDocCollector.createSharedManager((int)numHits, null, (int)Integer.MAX_VALUE);
        ScoreDoc[] completeScoreDocs = ((TopDocs)searcher.search((Query)query, (CollectorManager)complete)).scoreDocs;
        CollectorManager topScores = TopScoreDocCollector.createSharedManager((int)numHits, null, (int)1);
        ScoreDoc[] topScoresScoreDocs = ((TopDocs)searcher.search((Query)query, (CollectorManager)topScores)).scoreDocs;
        CheckHits.checkEqual(query, completeScoreDocs, topScoresScoreDocs);
    }

    private static void doCheckMaxScores(Random random, Query query, IndexSearcher searcher) throws IOException {
        int doc2;
        int upTo;
        DocIdSetIterator approx2;
        DocIdSetIterator approx1;
        TwoPhaseIterator twoPhase2;
        TwoPhaseIterator twoPhase1;
        Scorer s2;
        ScorerSupplier ss2;
        Scorer s1;
        query = searcher.rewrite(query);
        Weight w1 = searcher.createWeight(query, ScoreMode.COMPLETE, 1.0f);
        Weight w2 = searcher.createWeight(query, ScoreMode.TOP_SCORES, 1.0f);
        block0: for (LeafReaderContext ctx : searcher.getIndexReader().leaves()) {
            s1 = w1.scorer(ctx);
            ss2 = w2.scorerSupplier(ctx);
            if (ss2 == null) {
                s2 = null;
            } else {
                ss2.setTopLevelScoringClause();
                s2 = ss2.get(Long.MAX_VALUE);
            }
            if (s1 == null) {
                Assert.assertTrue((s2 == null || s2.iterator().nextDoc() == Integer.MAX_VALUE ? 1 : 0) != 0);
                continue;
            }
            twoPhase1 = s1.twoPhaseIterator();
            twoPhase2 = s2.twoPhaseIterator();
            approx1 = twoPhase1 == null ? s1.iterator() : twoPhase1.approximation();
            approx2 = twoPhase2 == null ? s2.iterator() : twoPhase2.approximation();
            upTo = -1;
            float maxScore = 0.0f;
            float minScore = 0.0f;
            doc2 = approx2.nextDoc();
            while (true) {
                int doc1 = approx1.nextDoc();
                while (doc1 < doc2) {
                    if (twoPhase1 == null || twoPhase1.matches()) {
                        Assert.assertTrue((s1.score() < minScore ? 1 : 0) != 0);
                    }
                    doc1 = approx1.nextDoc();
                }
                Assert.assertEquals((long)doc1, (long)doc2);
                if (doc2 == Integer.MAX_VALUE) continue block0;
                if (doc2 > upTo) {
                    upTo = s2.advanceShallow(doc2);
                    Assert.assertTrue((upTo >= doc2 ? 1 : 0) != 0);
                    maxScore = s2.getMaxScore(upTo);
                }
                if (twoPhase2 == null || twoPhase2.matches()) {
                    Assert.assertTrue((twoPhase1 == null || twoPhase1.matches() ? 1 : 0) != 0);
                    float score = s2.score();
                    Assert.assertEquals((float)s1.score(), (float)score, (float)0.0f);
                    Assert.assertTrue((String)(score + " > " + maxScore + " up to " + upTo), (score <= maxScore ? 1 : 0) != 0);
                    if (score >= minScore && random.nextInt(10) == 0) {
                        minScore = score;
                        s2.setMinCompetitiveScore(minScore);
                    }
                }
                doc2 = approx2.nextDoc();
            }
        }
        block3: for (LeafReaderContext ctx : searcher.getIndexReader().leaves()) {
            s1 = w1.scorer(ctx);
            ss2 = w2.scorerSupplier(ctx);
            if (ss2 == null) {
                s2 = null;
            } else {
                ss2.setTopLevelScoringClause();
                s2 = ss2.get(Long.MAX_VALUE);
            }
            if (s1 == null) {
                Assert.assertTrue((s2 == null || s2.iterator().nextDoc() == Integer.MAX_VALUE ? 1 : 0) != 0);
                continue;
            }
            twoPhase1 = s1.twoPhaseIterator();
            twoPhase2 = s2.twoPhaseIterator();
            approx1 = twoPhase1 == null ? s1.iterator() : twoPhase1.approximation();
            approx2 = twoPhase2 == null ? s2.iterator() : twoPhase2.approximation();
            upTo = -1;
            float minScore = 0.0f;
            float maxScore = 0.0f;
            while (true) {
                int delta;
                int target;
                boolean advance;
                doc2 = s2.docID();
                if (random.nextBoolean()) {
                    advance = false;
                    target = doc2 + 1;
                } else {
                    advance = true;
                    delta = Math.min(1 + random.nextInt(512), Integer.MAX_VALUE - doc2);
                    target = s2.docID() + delta;
                }
                if (target > upTo && random.nextBoolean()) {
                    delta = Math.min(random.nextInt(512), Integer.MAX_VALUE - target);
                    upTo = target + delta;
                    int m = s2.advanceShallow(target);
                    Assert.assertTrue((m >= target ? 1 : 0) != 0);
                    maxScore = s2.getMaxScore(upTo);
                }
                doc2 = advance ? approx2.advance(target) : approx2.nextDoc();
                int doc1 = approx1.advance(target);
                while (doc1 < doc2) {
                    if (twoPhase1 == null || twoPhase1.matches()) {
                        Assert.assertTrue((s1.score() < minScore ? 1 : 0) != 0);
                    }
                    doc1 = approx1.nextDoc();
                }
                Assert.assertEquals((long)doc1, (long)doc2);
                if (doc2 == Integer.MAX_VALUE) continue block3;
                if (twoPhase2 != null && !twoPhase2.matches()) continue;
                Assert.assertTrue((twoPhase1 == null || twoPhase1.matches() ? 1 : 0) != 0);
                float score = s2.score();
                Assert.assertEquals((float)s1.score(), (float)score, (float)0.0f);
                if (doc2 > upTo) {
                    upTo = s2.advanceShallow(doc2);
                    Assert.assertTrue((upTo >= doc2 ? 1 : 0) != 0);
                    maxScore = s2.getMaxScore(upTo);
                }
                Assert.assertTrue((score <= maxScore ? 1 : 0) != 0);
                if (!(score >= minScore) || random.nextInt(10) != 0) continue;
                minScore = score;
                s2.setMinCompetitiveScore(minScore);
            }
        }
    }

    private static class SetCollectorManager
    implements CollectorManager<SetCollector, Set<Integer>> {
        private SetCollectorManager() {
        }

        public SetCollector newCollector() throws IOException {
            return new SetCollector(new HashSet<Integer>());
        }

        public Set<Integer> reduce(Collection<SetCollector> collectors) throws IOException {
            TreeSet<Integer> ids = new TreeSet<Integer>();
            for (SetCollector collector : collectors) {
                ids.addAll(collector.bag);
            }
            return ids;
        }
    }

    public static class MatchesAsserter
    extends SimpleCollector {
        private final Weight weight;
        private LeafReaderContext context;
        int lastCheckedDoc = -1;

        public MatchesAsserter(Query query, IndexSearcher searcher) throws IOException {
            this.weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.context = context;
            this.lastCheckedDoc = -1;
        }

        public void collect(int doc) throws IOException {
            Matches matches = this.weight.matches(this.context, doc);
            Assert.assertNotNull((String)("Unexpected null Matches object in doc" + doc + " for query " + String.valueOf(this.weight.getQuery())), (Object)matches);
            if (this.lastCheckedDoc != doc - 1) {
                Assert.assertNull((String)("Unexpected non-null Matches object in non-matching doc" + doc + " for query " + String.valueOf(this.weight.getQuery())), (Object)this.weight.matches(this.context, doc - 1));
            }
            this.lastCheckedDoc = doc;
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    public static class ExplanationAsserter
    extends SimpleCollector {
        Query q;
        IndexSearcher s;
        String d;
        boolean deep;
        Scorable scorer;
        private int base = 0;

        public ExplanationAsserter(Query q, String defaultFieldName, IndexSearcher s) {
            this(q, defaultFieldName, s, false);
        }

        public ExplanationAsserter(Query q, String defaultFieldName, IndexSearcher s, boolean deep) {
            this.q = q;
            this.s = s;
            this.d = q.toString(defaultFieldName);
            this.deep = deep;
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            Explanation exp = null;
            doc += this.base;
            try {
                exp = this.s.explain(this.q, doc);
            }
            catch (IOException e) {
                throw new RuntimeException("exception in hitcollector of [[" + this.d + "]] for #" + doc, e);
            }
            Assert.assertNotNull((String)("Explanation of [[" + this.d + "]] for #" + doc + " is null"), (Object)exp);
            CheckHits.verifyExplanation(this.d, doc, this.scorer.score(), this.deep, exp);
            Assert.assertTrue((String)("Explanation of [[" + this.d + "]] for #" + doc + " does not indicate match: " + exp.toString()), (boolean)exp.isMatch());
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.base = context.docBase;
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }
    }

    public static class ExplanationAssertingSearcher
    extends IndexSearcher {
        public ExplanationAssertingSearcher(IndexReader r) {
            super(r);
        }

        protected void checkExplanations(final Query q) throws IOException {
            super.search(q, (CollectorManager)new CollectorManager<ExplanationAsserter, Void>(){

                public ExplanationAsserter newCollector() {
                    return new ExplanationAsserter(q, null, this);
                }

                public Void reduce(Collection<ExplanationAsserter> collectors) {
                    return null;
                }
            });
        }

        public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
            this.checkExplanations(query);
            return super.search(query, n, sort);
        }

        public void search(Query query, Collector results) throws IOException {
            this.checkExplanations(query);
            super.search(query, results);
        }

        public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
            this.checkExplanations(query);
            return (T)super.search(query, collectorManager);
        }

        public TopDocs search(Query query, int n) throws IOException {
            this.checkExplanations(query);
            return super.search(query, n);
        }
    }

    public static class SetCollector
    extends SimpleCollector {
        final Set<Integer> bag;
        private int base = 0;

        public SetCollector(Set<Integer> bag) {
            this.bag = bag;
        }

        public void setScorer(Scorable scorer) throws IOException {
        }

        public void collect(int doc) {
            this.bag.add(doc + this.base);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.base = context.docBase;
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }
}

