/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoDeletionPolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockIndexInputWrapper;
import org.apache.lucene.tests.store.MockIndexOutputWrapper;
import org.apache.lucene.tests.store.SlowClosingMockIndexInputWrapper;
import org.apache.lucene.tests.store.SlowOpeningMockIndexInputWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.tests.util.ThrottledIndexOutput;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;

public class MockDirectoryWrapper
extends BaseDirectoryWrapper {
    long maxSize;
    long maxUsedSize;
    double randomIOExceptionRate;
    double randomIOExceptionRateOnOpen;
    Random randomState;
    boolean assertNoDeleteOpenFile = false;
    boolean trackDiskUsage = false;
    boolean useSlowOpenClosers = LuceneTestCase.TEST_NIGHTLY;
    boolean allowRandomFileNotFoundException = true;
    boolean allowReadingFilesStillOpenForWrite = false;
    private Set<String> unSyncedFiles;
    private Set<String> createdFiles;
    private Set<String> openFilesForWrite = new HashSet<String>();
    ConcurrentMap<String, RuntimeException> openLocks = new ConcurrentHashMap<String, RuntimeException>();
    volatile boolean crashed;
    private ThrottledIndexOutput throttledOutput;
    private Throttling throttling = LuceneTestCase.TEST_NIGHTLY ? Throttling.SOMETIMES : Throttling.NEVER;
    boolean alwaysCorrupt;
    final AtomicInteger inputCloneCount = new AtomicInteger();
    private Map<Closeable, Exception> openFileHandles = Collections.synchronizedMap(new IdentityHashMap());
    private Map<String, Integer> openFiles;
    private Set<String> openFilesDeleted;
    boolean verboseClone;
    private boolean failOnCreateOutput = true;
    private boolean failOnOpenInput = true;
    private volatile boolean assertNoUnreferencedFilesOnClose;
    ArrayList<Failure> failures;

    private synchronized void init() {
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.createdFiles == null) {
            this.createdFiles = new HashSet<String>();
        }
        if (this.unSyncedFiles == null) {
            this.unSyncedFiles = new HashSet<String>();
        }
    }

    public MockDirectoryWrapper(Random random, Directory delegate) {
        super(delegate);
        this.randomState = new Random(random.nextInt());
        this.throttledOutput = new ThrottledIndexOutput(ThrottledIndexOutput.mBitsToBytes(40 + this.randomState.nextInt(10)), 1 + this.randomState.nextInt(5), null);
        this.init();
    }

    public int getInputCloneCount() {
        return this.inputCloneCount.get();
    }

    public void setVerboseClone(boolean v) {
        this.verboseClone = v;
    }

    public void setTrackDiskUsage(boolean v) {
        this.trackDiskUsage = v;
    }

    public void setAllowRandomFileNotFoundException(boolean value) {
        this.allowRandomFileNotFoundException = value;
    }

    public void setAllowReadingFilesStillOpenForWrite(boolean value) {
        this.allowReadingFilesStillOpenForWrite = value;
    }

    public void setThrottling(Throttling throttling) {
        this.throttling = throttling;
    }

    public void setUseSlowOpenClosers(boolean v) {
        this.useSlowOpenClosers = v;
    }

    public synchronized void sync(Collection<String> names) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot sync after crash");
        }
        for (String name : names) {
            this.maybeThrowIOException(name);
            this.in.sync(Collections.singleton(name));
            this.unSyncedFiles.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rename(String source, String dest) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot rename after crash");
        }
        if (this.openFiles.containsKey(source) && this.assertNoDeleteOpenFile) {
            throw this.fillOpenTrace(new AssertionError((Object)("MockDirectoryWrapper: source file \"" + source + "\" is still open: cannot rename")), source, true);
        }
        if (this.openFiles.containsKey(dest) && this.assertNoDeleteOpenFile) {
            throw this.fillOpenTrace(new AssertionError((Object)("MockDirectoryWrapper: dest file \"" + dest + "\" is still open: cannot rename")), dest, true);
        }
        boolean success = false;
        try {
            this.in.rename(source, dest);
            success = true;
        }
        finally {
            if (success) {
                if (this.unSyncedFiles.contains(source)) {
                    this.unSyncedFiles.remove(source);
                    this.unSyncedFiles.add(dest);
                }
                this.openFilesDeleted.remove(source);
                this.createdFiles.remove(source);
                this.createdFiles.add(dest);
            }
        }
    }

    public synchronized void syncMetaData() throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot sync metadata after crash");
        }
        this.in.syncMetaData();
    }

    public final synchronized long sizeInBytes() throws IOException {
        long size = 0L;
        for (String file : this.in.listAll()) {
            if (file.startsWith("extra")) continue;
            size += this.in.fileLength(file);
        }
        return size;
    }

    public synchronized void corruptUnknownFiles() throws IOException {
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MDW: corrupt unknown files");
        }
        HashSet knownFiles = new HashSet();
        for (String fileName : this.listAll()) {
            SegmentInfos infos;
            if (!fileName.startsWith("segments")) continue;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MDW: read " + fileName + " to gather files it references");
            }
            try {
                infos = SegmentInfos.readCommit((Directory)this, (String)fileName);
            }
            catch (IOException ioe) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("MDW: exception reading segment infos " + fileName + "; files: " + Arrays.toString(this.listAll()));
                }
                throw ioe;
            }
            knownFiles.addAll(infos.files(true));
        }
        HashSet<String> toCorrupt = new HashSet<String>();
        Matcher m = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
        for (String fileName : this.listAll()) {
            m.reset(fileName);
            if (knownFiles.contains(fileName) || fileName.endsWith("write.lock") || !m.matches() && !fileName.startsWith("pending_segments")) continue;
            toCorrupt.add(fileName);
        }
        this.corruptFiles(toCorrupt);
    }

    public synchronized void corruptFiles(Collection<String> files) throws IOException {
        boolean disabled = TestUtil.disableVirusChecker(this.in);
        try {
            this._corruptFiles(files);
        }
        finally {
            if (disabled) {
                TestUtil.enableVirusChecker(this.in);
            }
        }
    }

    private synchronized void _corruptFiles(Collection<String> files) throws IOException {
        ArrayList<String> filesToCorrupt = new ArrayList<String>(files);
        CollectionUtil.timSort(filesToCorrupt);
        for (String name : filesToCorrupt) {
            int damage = this.randomState.nextInt(6);
            if (this.alwaysCorrupt && damage == 3) {
                damage = 4;
            }
            Object action = null;
            switch (damage) {
                case 0: {
                    action = "deleted";
                    this.deleteFile(name);
                    break;
                }
                case 1: {
                    IndexOutput out;
                    long length;
                    action = "zeroed";
                    try {
                        length = this.fileLength(name);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                    this.deleteFile(name);
                    byte[] zeroes = new byte[256];
                    try {
                        out = this.in.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            int limit;
                            for (long upto = 0L; upto < length; upto += (long)limit) {
                                limit = (int)Math.min(length - upto, (long)zeroes.length);
                                out.writeBytes(zeroes, 0, limit);
                            }
                            break;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                }
                case 2: {
                    IndexInput ii;
                    action = "partially truncated";
                    String tempFileName = null;
                    try (IndexOutput tempOut = this.in.createTempOutput("name", "mdw_corrupt", LuceneTestCase.newIOContext(this.randomState));){
                        ii = this.in.openInput(name, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            tempFileName = tempOut.getName();
                            tempOut.copyBytes((DataInput)ii, ii.length() / 2L);
                        }
                        finally {
                            if (ii != null) {
                                ii.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                    this.deleteFile(name);
                    try (IndexOutput out = this.in.createOutput(name, LuceneTestCase.newIOContext(this.randomState));){
                        ii = this.in.openInput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            out.copyBytes((DataInput)ii, ii.length());
                        }
                        finally {
                            if (ii != null) {
                                ii.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                    this.deleteFile(tempFileName);
                    break;
                }
                case 3: {
                    action = "didn't change";
                    break;
                }
                case 4: {
                    IndexInput ii;
                    String tempFileName = null;
                    try (IndexOutput tempOut = this.in.createTempOutput("name", "mdw_corrupt", LuceneTestCase.newIOContext(this.randomState));){
                        ii = this.in.openInput(name, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            tempFileName = tempOut.getName();
                            if (ii.length() > 0L) {
                                long byteToCorrupt = (long)(this.randomState.nextDouble() * (double)ii.length());
                                if (byteToCorrupt > 0L) {
                                    tempOut.copyBytes((DataInput)ii, byteToCorrupt);
                                }
                                byte b = ii.readByte();
                                int bitToFlip = this.randomState.nextInt(8);
                                b = (byte)(b ^ 1 << bitToFlip);
                                tempOut.writeByte(b);
                                action = "flip bit " + bitToFlip + " of byte " + byteToCorrupt + " out of " + ii.length() + " bytes";
                                long bytesLeft = ii.length() - byteToCorrupt - 1L;
                                if (bytesLeft > 0L) {
                                    tempOut.copyBytes((DataInput)ii, bytesLeft);
                                }
                            } else {
                                action = "didn't change";
                            }
                        }
                        finally {
                            if (ii != null) {
                                ii.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                    this.deleteFile(name);
                    try (IndexOutput out = this.in.createOutput(name, LuceneTestCase.newIOContext(this.randomState));){
                        ii = this.in.openInput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            out.copyBytes((DataInput)ii, ii.length());
                        }
                        finally {
                            if (ii != null) {
                                ii.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                    this.deleteFile(tempFileName);
                    break;
                }
                case 5: {
                    IndexOutput out;
                    action = "fully truncated";
                    this.deleteFile(name);
                    try {
                        out = this.in.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                        try {
                            out.getFilePointer();
                            break;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("hit unexpected IOException while trying to corrupt file " + name, ioe);
                    }
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!LuceneTestCase.VERBOSE) continue;
            System.out.println("MockDirectoryWrapper: " + (String)action + " unsynced file: " + name);
        }
    }

    public synchronized void crash() throws IOException {
        this.openFiles = new HashMap<String, Integer>();
        this.openFilesForWrite = new HashSet<String>();
        this.openFilesDeleted = new HashSet<String>();
        IdentityHashMap<Closeable, Exception> m = new IdentityHashMap<Closeable, Exception>(this.openFileHandles);
        for (Closeable f : m.keySet()) {
            try {
                f.close();
            }
            catch (Exception exception) {}
        }
        this.corruptFiles(this.unSyncedFiles);
        this.crashed = true;
        this.unSyncedFiles = new HashSet<String>();
    }

    public synchronized void clearCrash() {
        this.crashed = false;
        this.openLocks.clear();
    }

    public void setMaxSizeInBytes(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSizeInBytes() {
        return this.maxSize;
    }

    public long getMaxUsedSizeInBytes() {
        return this.maxUsedSize;
    }

    public void resetMaxUsedSizeInBytes() throws IOException {
        this.maxUsedSize = this.sizeInBytes();
    }

    public void setAssertNoDeleteOpenFile(boolean value) {
        this.assertNoDeleteOpenFile = value;
    }

    public boolean getAssertNoDeleteOpenFile() {
        return this.assertNoDeleteOpenFile;
    }

    public void setRandomIOExceptionRate(double rate) {
        this.randomIOExceptionRate = rate;
    }

    public double getRandomIOExceptionRate() {
        return this.randomIOExceptionRate;
    }

    public void setRandomIOExceptionRateOnOpen(double rate) {
        this.randomIOExceptionRateOnOpen = rate;
    }

    public double getRandomIOExceptionRateOnOpen() {
        return this.randomIOExceptionRateOnOpen;
    }

    void maybeThrowIOException(String message) throws IOException {
        if (this.randomState.nextDouble() < this.randomIOExceptionRate) {
            IOException ioe = new IOException("a random IOException" + (String)(message == null ? "" : " (" + message + ")"));
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception" + (String)(message == null ? "" : " (" + message + ")"));
                ioe.printStackTrace(System.out);
            }
            throw ioe;
        }
    }

    void maybeThrowIOExceptionOnOpen(String name) throws IOException {
        if (this.randomState.nextDouble() < this.randomIOExceptionRateOnOpen) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception during open file=" + name);
                new Throwable().printStackTrace(System.out);
            }
            if (!this.allowRandomFileNotFoundException || this.randomState.nextBoolean()) {
                throw new IOException("a random IOException (" + name + ")");
            }
            throw this.randomState.nextBoolean() ? new FileNotFoundException("a random IOException (" + name + ")") : new NoSuchFileException("a random IOException (" + name + ")");
        }
    }

    public synchronized long getFileHandleCount() {
        return this.openFileHandles.size();
    }

    public synchronized void deleteFile(String name) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot delete after crash");
        }
        if (this.openFiles.containsKey(name)) {
            this.openFilesDeleted.add(name);
            if (this.assertNoDeleteOpenFile) {
                throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot delete"), name, true);
            }
        } else {
            this.openFilesDeleted.remove(name);
        }
        this.unSyncedFiles.remove(name);
        this.in.deleteFile(name);
        this.createdFiles.remove(name);
    }

    private synchronized <T extends Throwable> T fillOpenTrace(T t, String name, boolean input) {
        for (Map.Entry<Closeable, Exception> ent : this.openFileHandles.entrySet()) {
            if (input && ent.getKey() instanceof MockIndexInputWrapper && ((MockIndexInputWrapper)((Object)ent.getKey())).name.equals(name)) {
                t.initCause(ent.getValue());
                break;
            }
            if (input || !(ent.getKey() instanceof MockIndexOutputWrapper) || !((MockIndexOutputWrapper)((Object)ent.getKey())).name.equals(name)) continue;
            t.initCause(ent.getValue());
            break;
        }
        return t;
    }

    private void maybeYield() {
        if (this.randomState.nextBoolean()) {
            Thread.yield();
        }
    }

    public synchronized Set<String> getOpenDeletedFiles() {
        return new HashSet<String>(this.openFilesDeleted);
    }

    public void setFailOnCreateOutput(boolean v) {
        this.failOnCreateOutput = v;
    }

    public synchronized IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.maybeThrowDeterministicException();
        this.maybeThrowIOExceptionOnOpen(name);
        this.maybeYield();
        if (this.failOnCreateOutput) {
            this.maybeThrowDeterministicException();
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.init();
        if (this.createdFiles.contains(name)) {
            throw new FileAlreadyExistsException("File \"" + name + "\" was already written to.");
        }
        if (this.assertNoDeleteOpenFile && this.openFiles.containsKey(name)) {
            throw new AssertionError((Object)("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot overwrite"));
        }
        this.unSyncedFiles.add(name);
        this.createdFiles.add(name);
        IndexOutput delegateOutput = this.in.createOutput(name, LuceneTestCase.newIOContext(this.randomState, context));
        MockIndexOutputWrapper io = new MockIndexOutputWrapper(this, delegateOutput, name);
        this.addFileHandle((Closeable)((Object)io), name, Handle.Output);
        this.openFilesForWrite.add(name);
        return this.maybeThrottle(name, (IndexOutput)io);
    }

    private IndexOutput maybeThrottle(String name, IndexOutput output) {
        if (this.throttling == Throttling.ALWAYS || this.throttling == Throttling.SOMETIMES && this.randomState.nextInt(200) == 0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: throttling indexOutput (" + name + ")");
            }
            return this.throttledOutput.newFromDelegate(output);
        }
        return output;
    }

    public synchronized IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        this.maybeThrowDeterministicException();
        this.maybeThrowIOExceptionOnOpen("temp: prefix=" + prefix + " suffix=" + suffix);
        this.maybeYield();
        if (this.failOnCreateOutput) {
            this.maybeThrowDeterministicException();
        }
        if (this.crashed) {
            throw new IOException("cannot createTempOutput after crash");
        }
        this.init();
        IndexOutput delegateOutput = this.in.createTempOutput(prefix, suffix, LuceneTestCase.newIOContext(this.randomState, context));
        String name = delegateOutput.getName();
        if (!name.toLowerCase(Locale.ROOT).endsWith(".tmp")) {
            throw new IllegalStateException("wrapped directory failed to use .tmp extension: got: " + name);
        }
        this.unSyncedFiles.add(name);
        this.createdFiles.add(name);
        MockIndexOutputWrapper io = new MockIndexOutputWrapper(this, delegateOutput, name);
        this.addFileHandle((Closeable)((Object)io), name, Handle.Output);
        this.openFilesForWrite.add(name);
        return this.maybeThrottle(name, (IndexOutput)io);
    }

    synchronized void addFileHandle(Closeable c, String name, Handle handle) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            v = v + 1;
            this.openFiles.put(name, v);
        } else {
            this.openFiles.put(name, 1);
        }
        this.openFileHandles.put(c, new RuntimeException("unclosed Index" + handle.name() + ": " + name));
    }

    public void setFailOnOpenInput(boolean v) {
        this.failOnOpenInput = v;
    }

    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        MockIndexInputWrapper ii;
        this.maybeThrowDeterministicException();
        this.maybeThrowIOExceptionOnOpen(name);
        this.maybeYield();
        if (this.failOnOpenInput) {
            this.maybeThrowDeterministicException();
        }
        if (!LuceneTestCase.slowFileExists(this.in, name)) {
            throw this.randomState.nextBoolean() ? new FileNotFoundException(name + " in dir=" + this.in) : new NoSuchFileException(name + " in dir=" + this.in);
        }
        if (!this.allowReadingFilesStillOpenForWrite && this.openFilesForWrite.contains(name)) {
            throw this.fillOpenTrace(new AccessDeniedException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        IndexInput delegateInput = this.in.openInput(name, LuceneTestCase.newIOContext(this.randomState, context));
        int randomInt = this.randomState.nextInt(500);
        if (this.useSlowOpenClosers && randomInt == 0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: using SlowClosingMockIndexInputWrapper for file " + name);
            }
            ii = new SlowClosingMockIndexInputWrapper(this, name, delegateInput);
        } else if (this.useSlowOpenClosers && randomInt == 1) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: using SlowOpeningMockIndexInputWrapper for file " + name);
            }
            ii = new SlowOpeningMockIndexInputWrapper(this, name, delegateInput);
        } else {
            ii = new MockIndexInputWrapper(this, name, delegateInput, null);
        }
        this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
        return ii;
    }

    public void setAssertNoUnrefencedFilesOnClose(boolean v) {
        this.assertNoUnreferencedFilesOnClose = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        block22: {
            block21: {
                if (!this.isOpen) {
                    this.in.close();
                    return;
                }
                this.isOpen = false;
                boolean success = false;
                try {
                    this.maybeYield();
                    if (this.openFiles == null) {
                        this.openFiles = new HashMap<String, Integer>();
                        this.openFilesDeleted = new HashSet<String>();
                    }
                    if (this.openFiles.size() > 0) {
                        Exception cause = null;
                        Iterator<Exception> stacktraces = this.openFileHandles.values().iterator();
                        if (stacktraces.hasNext()) {
                            cause = stacktraces.next();
                        }
                        throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still " + this.openFiles.size() + " open files: " + this.openFiles, cause);
                    }
                    if (this.openLocks.size() > 0) {
                        Exception cause = null;
                        Iterator stacktraces = this.openLocks.values().iterator();
                        if (stacktraces.hasNext()) {
                            cause = (Exception)stacktraces.next();
                        }
                        throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open locks: " + this.openLocks, cause);
                    }
                    this.randomIOExceptionRate = 0.0;
                    this.randomIOExceptionRateOnOpen = 0.0;
                    if ((this.getCheckIndexOnClose() || this.assertNoUnreferencedFilesOnClose) && DirectoryReader.indexExists((Directory)this)) {
                        if (this.getCheckIndexOnClose()) {
                            if (LuceneTestCase.VERBOSE) {
                                System.out.println("\nNOTE: MockDirectoryWrapper: now crush");
                            }
                            this.crash();
                            if (LuceneTestCase.VERBOSE) {
                                System.out.println("\nNOTE: MockDirectoryWrapper: now run CheckIndex");
                            }
                            TestUtil.checkIndex((Directory)this, this.getCrossCheckTermVectorsOnClose(), true, false, null);
                        }
                        if (this.assertNoUnreferencedFilesOnClose) {
                            if (LuceneTestCase.VERBOSE) {
                                System.out.println("MDW: now assert no unref'd files at close");
                            }
                            HashSet<String> allFiles = new HashSet<String>(Arrays.asList(this.listAll()));
                            Object[] startFiles = allFiles.toArray(new String[0]);
                            IndexWriterConfig iwc = new IndexWriterConfig(null);
                            iwc.setIndexDeletionPolicy(NoDeletionPolicy.INSTANCE);
                            TestUtil.disableVirusChecker(this.in);
                            new IndexWriter(this.in, iwc).rollback();
                            Object[] endFiles = this.in.listAll();
                            TreeSet<String> startSet = new TreeSet<String>(Arrays.asList(startFiles));
                            TreeSet<String> endSet = new TreeSet<String>(Arrays.asList(endFiles));
                            startFiles = startSet.toArray(new String[0]);
                            endFiles = endSet.toArray(new String[0]);
                            if (!Arrays.equals(startFiles, endFiles)) {
                                ArrayList<Object> removed = new ArrayList<Object>();
                                for (Object fileName : startFiles) {
                                    if (endSet.contains(fileName)) continue;
                                    removed.add(fileName);
                                }
                                ArrayList<Object> added = new ArrayList<Object>();
                                for (Object fileName : endFiles) {
                                    if (startSet.contains(fileName)) continue;
                                    added.add(fileName);
                                }
                                Object extras = removed.size() != 0 ? "\n\nThese files were removed: " + removed : "";
                                if (added.size() != 0) {
                                    extras = (String)extras + "\n\nThese files were added (waaaaaaaaaat!): " + added;
                                }
                                throw new RuntimeException("unreferenced files: before delete:\n    " + Arrays.toString(startFiles) + "\n  after delete:\n    " + Arrays.toString(endFiles) + (String)extras);
                            }
                            DirectoryReader ir1 = DirectoryReader.open((Directory)this);
                            int numDocs1 = ir1.numDocs();
                            ir1.close();
                            new IndexWriter((Directory)this, new IndexWriterConfig(null)).close();
                            DirectoryReader ir2 = DirectoryReader.open((Directory)this);
                            int numDocs2 = ir2.numDocs();
                            ir2.close();
                            assert (numDocs1 == numDocs2) : "numDocs changed after opening/closing IW: before=" + numDocs1 + " after=" + numDocs2;
                        }
                    }
                    if (!(success = true)) break block21;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.in});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.in});
                break block22;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
        }
    }

    synchronized void removeOpenFile(Closeable c, String name) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            if (v == 1) {
                this.openFiles.remove(name);
            } else {
                v = v - 1;
                this.openFiles.put(name, v);
            }
        }
        this.openFileHandles.remove(c);
    }

    public synchronized void removeIndexOutput(IndexOutput out, String name) {
        this.openFilesForWrite.remove(name);
        this.removeOpenFile((Closeable)out, name);
    }

    public synchronized void removeIndexInput(IndexInput in, String name) {
        this.removeOpenFile((Closeable)in, name);
    }

    public synchronized void failOn(Failure fail) {
        if (this.failures == null) {
            this.failures = new ArrayList();
        }
        this.failures.add(fail);
    }

    synchronized void maybeThrowDeterministicException() throws IOException {
        if (this.failures != null) {
            for (int i = 0; i < this.failures.size(); ++i) {
                try {
                    this.failures.get(i).eval(this);
                    continue;
                }
                catch (Throwable t) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockDirectoryWrapper: throw exc");
                        t.printStackTrace(System.out);
                    }
                    throw IOUtils.rethrowAlways((Throwable)t);
                }
            }
        }
    }

    public synchronized String[] listAll() throws IOException {
        this.maybeYield();
        return this.in.listAll();
    }

    public synchronized long fileLength(String name) throws IOException {
        this.maybeYield();
        return this.in.fileLength(name);
    }

    public synchronized Lock obtainLock(String name) throws IOException {
        this.maybeYield();
        return super.obtainLock(name);
    }

    public String toString() {
        if (this.maxSize != 0L) {
            return "MockDirectoryWrapper(" + this.in + ", current=" + this.maxUsedSize + ",max=" + this.maxSize + ")";
        }
        return super.toString();
    }

    public final ChecksumIndexInput openChecksumInput(String name, IOContext context) throws IOException {
        return super.openChecksumInput(name, context);
    }

    public final void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        super.copyFrom(from, src, dest, context);
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        super.ensureOpen();
    }

    public static class FakeIOException
    extends IOException {
    }

    public static class Failure {
        protected boolean doFail;

        public void eval(MockDirectoryWrapper dir) throws IOException {
        }

        public Failure reset() {
            return this;
        }

        public void setDoFail() {
            this.doFail = true;
        }

        public void clearDoFail() {
            this.doFail = false;
        }
    }

    private static enum Handle {
        Input,
        Output,
        Slice;

    }

    public static enum Throttling {
        ALWAYS,
        SOMETIMES,
        NEVER;

    }
}

