/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search.similarities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.lucene.search.similarities.AxiomaticF1EXP;
import org.apache.lucene.search.similarities.AxiomaticF1LOG;
import org.apache.lucene.search.similarities.AxiomaticF2EXP;
import org.apache.lucene.search.similarities.AxiomaticF2LOG;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicModelG;
import org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.DFISimilarity;
import org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.DistributionLL;
import org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.lucene.search.similarities.Independence;
import org.apache.lucene.search.similarities.IndependenceChiSquared;
import org.apache.lucene.search.similarities.IndependenceSaturated;
import org.apache.lucene.search.similarities.IndependenceStandardized;
import org.apache.lucene.search.similarities.LMDirichletSimilarity;
import org.apache.lucene.search.similarities.LMJelinekMercerSimilarity;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.LambdaDF;
import org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.lucene.search.similarities.NormalizationZ;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;

public class RandomSimilarity
extends PerFieldSimilarityWrapper {
    final BM25Similarity defaultSim = new BM25Similarity();
    final List<Similarity> knownSims;
    Map<String, Similarity> previousMappings = new HashMap<String, Similarity>();
    final int perFieldSeed;
    final boolean shouldQueryNorm;
    static BasicModel[] BASIC_MODELS = new BasicModel[]{new BasicModelG(), new BasicModelIF(), new BasicModelIn(), new BasicModelIne()};
    static AfterEffect[] AFTER_EFFECTS = new AfterEffect[]{new AfterEffectB(), new AfterEffectL()};
    static Normalization[] NORMALIZATIONS = new Normalization[]{new NormalizationH1(), new NormalizationH2(), new NormalizationH3(), new NormalizationZ()};
    static Distribution[] DISTRIBUTIONS = new Distribution[]{new DistributionLL(), new DistributionSPL()};
    static Lambda[] LAMBDAS = new Lambda[]{new LambdaDF(), new LambdaTTF()};
    static Independence[] INDEPENDENCE_MEASURES = new Independence[]{new IndependenceStandardized(), new IndependenceSaturated(), new IndependenceChiSquared()};
    static List<Similarity> allSims = new ArrayList<Similarity>();

    public RandomSimilarity(Random random) {
        this.perFieldSeed = random.nextInt();
        this.shouldQueryNorm = random.nextBoolean();
        this.knownSims = new ArrayList<Similarity>(allSims);
        Collections.shuffle(this.knownSims, random);
    }

    public synchronized Similarity get(String field) {
        assert (field != null);
        Similarity sim = this.previousMappings.get(field);
        if (sim == null) {
            sim = this.knownSims.get(Math.max(0, Math.abs(this.perFieldSeed ^ field.hashCode())) % this.knownSims.size());
            this.previousMappings.put(field, sim);
        }
        return sim;
    }

    public synchronized String toString() {
        return "RandomSimilarity(queryNorm=" + this.shouldQueryNorm + "): " + this.previousMappings.toString();
    }

    static {
        allSims.add((Similarity)new ClassicSimilarity());
        allSims.add((Similarity)new BM25Similarity());
        allSims.add((Similarity)new AxiomaticF1EXP());
        allSims.add((Similarity)new AxiomaticF1LOG());
        allSims.add((Similarity)new AxiomaticF2EXP());
        allSims.add((Similarity)new AxiomaticF2LOG());
        allSims.add((Similarity)new BooleanSimilarity());
        for (BasicModel basicModel : BASIC_MODELS) {
            for (AfterEffect afterEffect : AFTER_EFFECTS) {
                for (Normalization normalization : NORMALIZATIONS) {
                    allSims.add((Similarity)new DFRSimilarity(basicModel, afterEffect, normalization));
                }
            }
        }
        for (BasicModel basicModel : DISTRIBUTIONS) {
            for (AfterEffect afterEffect : LAMBDAS) {
                for (Normalization normalization : NORMALIZATIONS) {
                    allSims.add((Similarity)new IBSimilarity((Distribution)basicModel, (Lambda)afterEffect, normalization));
                }
            }
        }
        allSims.add((Similarity)new LMDirichletSimilarity());
        allSims.add((Similarity)new LMJelinekMercerSimilarity(0.1f));
        allSims.add((Similarity)new LMJelinekMercerSimilarity(0.7f));
        for (BasicModel basicModel : INDEPENDENCE_MEASURES) {
            allSims.add((Similarity)new DFISimilarity((Independence)basicModel));
        }
    }
}

