/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.asserting;

import java.io.IOException;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;

public class AssertingKnnVectorsFormat
extends KnnVectorsFormat {
    private final KnnVectorsFormat delegate = TestUtil.getDefaultKnnVectorsFormat();

    public AssertingKnnVectorsFormat() {
        super("Asserting");
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingKnnVectorsWriter(this.delegate.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingKnnVectorsReader(this.delegate.fieldsReader(state), state.fieldInfos);
    }

    static class AssertingKnnVectorsReader
    extends KnnVectorsReader {
        final KnnVectorsReader delegate;
        final FieldInfos fis;

        AssertingKnnVectorsReader(KnnVectorsReader delegate, FieldInfos fis) {
            assert (delegate != null);
            this.delegate = delegate;
            this.fis = fis;
        }

        public void checkIntegrity() throws IOException {
            this.delegate.checkIntegrity();
        }

        public VectorValues getVectorValues(String field) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0);
            VectorValues values = this.delegate.getVectorValues(field);
            assert (values != null);
            assert (values.docID() == -1);
            assert (values.size() >= 0);
            assert (values.dimension() > 0);
            return values;
        }

        public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
            FieldInfo fi = this.fis.fieldInfo(field);
            assert (fi != null && fi.getVectorDimension() > 0);
            TopDocs hits = this.delegate.search(field, target, k, acceptDocs, visitedLimit);
            assert (hits != null);
            assert (hits.scoreDocs.length <= k);
            return hits;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }

    static class AssertingKnnVectorsWriter
    extends KnnVectorsWriter {
        final KnnVectorsWriter delegate;

        AssertingKnnVectorsWriter(KnnVectorsWriter delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.addField(fieldInfo);
        }

        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.delegate.flush(maxDoc, sortMap);
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            assert (fieldInfo != null);
            assert (mergeState != null);
            this.delegate.mergeOneField(fieldInfo, mergeState);
        }

        public void finish() throws IOException {
            this.delegate.finish();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }
    }
}

