/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.VectorUtil;

public abstract class BaseKnnVectorsFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new KnnVectorField("v2", this.randomVector(30), VectorSimilarityFunction.EUCLIDEAN));
    }

    public void testFieldConstructor() {
        float[] v = new float[1];
        KnnVectorField field = new KnnVectorField("f", v);
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)field.fieldType().vectorDimension());
        BaseKnnVectorsFormatTestCase.assertEquals((Object)VectorSimilarityFunction.EUCLIDEAN, (Object)field.fieldType().vectorSimilarityFunction());
        BaseKnnVectorsFormatTestCase.assertSame((Object)v, (Object)field.vectorValue());
    }

    public void testFieldConstructorExceptions() {
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField(null, new float[1]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField("f", null));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField("f", new float[1], (VectorSimilarityFunction)null));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField("f", new float[0]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField("f", new float[1025]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnVectorField("f", new float[1025], (FieldType)null));
    }

    public void testFieldSetValue() {
        KnnVectorField field = new KnnVectorField("f", new float[1]);
        float[] v1 = new float[1];
        field.setVectorValue(v1);
        BaseKnnVectorsFormatTestCase.assertSame((Object)v1, (Object)field.vectorValue());
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(new float[2]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(null));
    }

    public void testIllegalDimChangeTwoDocs() throws Exception {
        String errMsg;
        IllegalArgumentException expected;
        Document doc2;
        Document doc;
        IndexWriter w;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[3], VectorSimilarityFunction.DOT_PRODUCT));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "Inconsistency of field data structures across documents for field [f] of doc [1]. vector dimension: expected '4', but it has '3'.";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        dir = BaseKnnVectorsFormatTestCase.newDirectory();
        try {
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.commit();
                doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[3], VectorSimilarityFunction.DOT_PRODUCT));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "cannot change field \"f\" from vector dimension=4, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=3, vector similarity function=DOT_PRODUCT";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    public void testIllegalSimilarityFunctionChange() throws Exception {
        String errMsg;
        IllegalArgumentException expected;
        Document doc2;
        Document doc;
        IndexWriter w;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "Inconsistency of field data structures across documents for field [f] of doc [1]. vector similarity function: expected 'DOT_PRODUCT', but it has 'EUCLIDEAN'.";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        dir = BaseKnnVectorsFormatTestCase.newDirectory();
        try {
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.commit();
                doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "cannot change field \"f\" from vector dimension=4, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector similarity function=EUCLIDEAN";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    public void testIllegalDimChangeTwoWriters() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[1], VectorSimilarityFunction.DOT_PRODUCT));
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addDocument((Iterable)doc2));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=1, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeTwoWriters() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc2 = new Document();
                doc2.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addDocument((Iterable)doc2));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector similarity function=EUCLIDEAN", (Object)expected.getMessage());
            }
        }
    }

    public void testAddIndexesDirectory0() throws Exception {
        String fieldName = "field";
        Document doc = new Document();
        doc.add((IndexableField)new KnnVectorField(fieldName, new float[4], VectorSimilarityFunction.DOT_PRODUCT));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    VectorValues vectorValues = r.getVectorValues(fieldName);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)vectorValues.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues.nextDoc());
                }
            }
        }
    }

    public void testAddIndexesDirectory1() throws Exception {
        String fieldName = "field";
        Document doc = new Document();
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            doc.add((IndexableField)new KnnVectorField(fieldName, new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w2.addDocument((Iterable)doc);
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    VectorValues vectorValues = r.getVectorValues(fieldName);
                    BaseKnnVectorsFormatTestCase.assertNotEquals((long)Integer.MAX_VALUE, (long)vectorValues.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues.nextDoc());
                }
            }
        }
    }

    public void testAddIndexesDirectory01() throws Exception {
        String fieldName = "field";
        float[] vector = new float[1];
        Document doc = new Document();
        doc.add((IndexableField)new KnnVectorField(fieldName, vector, VectorSimilarityFunction.DOT_PRODUCT));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                vector[0] = 1.0f;
                w2.addDocument((Iterable)doc);
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    VectorValues vectorValues = r.getVectorValues(fieldName);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)vectorValues.nextDoc());
                    float value = vectorValues.vectorValue()[0];
                    BaseKnnVectorsFormatTestCase.assertTrue((value == 0.0f || value == 1.0f ? 1 : 0) != 0);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)vectorValues.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)(value += vectorValues.vectorValue()[0]), (float)0.0f);
                }
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesDirectory() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[5], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> BaseKnnVectorsFormatTestCase.lambda$testIllegalDimChangeViaAddIndexesDirectory$14(w2, (Directory)dir));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=5, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesDirectory() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> BaseKnnVectorsFormatTestCase.lambda$testIllegalSimilarityFunctionChangeViaAddIndexesDirectory$15(w2, (Directory)dir));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[5], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addIndexes(new CodecReader[]{(CodecReader)BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r)}));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=5, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addIndexes(new CodecReader[]{(CodecReader)BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r)}));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesSlowCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[5], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> TestUtil.addIndexesSlowly(w2, r));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=5, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesSlowCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> TestUtil.addIndexesSlowly(w2, r));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalMultipleValues() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc));
            BaseKnnVectorsFormatTestCase.assertEquals((Object)"VectorValuesField \"f\" appears more than once in this document (only one value is allowed per field)", (Object)expected.getMessage());
        }
    }

    public void testIllegalDimensionTooLarge() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> doc.add((IndexableField)new KnnVectorField("f", new float[1025], VectorSimilarityFunction.DOT_PRODUCT)));
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnVectorField("f", new float[1], VectorSimilarityFunction.EUCLIDEAN));
            w.addDocument((Iterable)doc2);
        }
    }

    public void testIllegalEmptyVector() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            Exception e = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> doc.add((IndexableField)new KnnVectorField("f", new float[0], VectorSimilarityFunction.EUCLIDEAN)));
            BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot index an empty vector", (Object)e.getMessage());
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnVectorField("f", new float[1], VectorSimilarityFunction.EUCLIDEAN));
            w.addDocument((Iterable)doc2);
        }
    }

    public void testDifferentCodecs1() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
            iwc.setCodec(Codec.forName((String)"SimpleText"));
            try (IndexWriter w = new IndexWriter((Directory)dir, iwc);){
                Document doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.forceMerge(1);
            }
        }
    }

    public void testDifferentCodecs2() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        iwc.setCodec(Codec.forName((String)"SimpleText"));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, iwc);){
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.forceMerge(1);
            }
            finally {
                w.close();
            }
        }
    }

    public void testInvalidKnnVectorFieldUsage() {
        KnnVectorField field = new KnnVectorField("field", new float[2], VectorSimilarityFunction.EUCLIDEAN);
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setIntValue(14));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(new float[1]));
        BaseKnnVectorsFormatTestCase.assertNull((Object)field.numericValue());
    }

    public void testDeleteAllVectorDocs() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc.add((IndexableField)new KnnVectorField("v", new float[]{2.0f, 3.0f, 5.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.addDocument((Iterable)new Document());
            w.commit();
            try (DirectoryReader r = DirectoryReader.open((IndexWriter)w);){
                VectorValues values = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r).getVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)values.size());
            }
            w.deleteDocuments(new Term[]{new Term("id", "0")});
            w.forceMerge(1);
            r = DirectoryReader.open((IndexWriter)w);
            try {
                LeafReader leafReader = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r);
                VectorValues values = leafReader.getVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)values.size());
                TopDocs results = leafReader.searchNearestVectors("v", this.randomVector(3), 1, leafReader.getLiveDocs(), Integer.MAX_VALUE);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)results.scoreDocs.length);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
    }

    public void testKnnVectorFieldMissingFromOneSegment() throws Exception {
        try (FSDirectory dir = FSDirectory.open((Path)BaseKnnVectorsFormatTestCase.createTempDir());
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc.add((IndexableField)new KnnVectorField("v0", new float[]{2.0f, 3.0f, 5.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.commit();
            doc = new Document();
            doc.add((IndexableField)new KnnVectorField("v1", new float[]{2.0f, 3.0f, 5.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.forceMerge(1);
        }
    }

    public void testSparseVectors() throws Exception {
        int numDocs = BaseKnnVectorsFormatTestCase.atLeast(1000);
        int numFields = TestUtil.nextInt(BaseKnnVectorsFormatTestCase.random(), 1, 10);
        int[] fieldDocCounts = new int[numFields];
        double[] fieldTotals = new double[numFields];
        int[] fieldDims = new int[numFields];
        VectorSimilarityFunction[] fieldSearchStrategies = new VectorSimilarityFunction[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldDims[i] = BaseKnnVectorsFormatTestCase.random().nextInt(20) + 1;
            fieldSearchStrategies[i] = VectorSimilarityFunction.values()[BaseKnnVectorsFormatTestCase.random().nextInt(VectorSimilarityFunction.values().length)];
        }
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             RandomIndexWriter w = new RandomIndexWriter(BaseKnnVectorsFormatTestCase.random(), (Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            for (int i = 0; i < numDocs; ++i) {
                Document doc = new Document();
                for (int field = 0; field < numFields; ++field) {
                    String fieldName = "int" + field;
                    if (BaseKnnVectorsFormatTestCase.random().nextInt(100) != 17) continue;
                    float[] v = this.randomVector(fieldDims[field]);
                    doc.add((IndexableField)new KnnVectorField(fieldName, v, fieldSearchStrategies[field]));
                    int n = field;
                    fieldDocCounts[n] = fieldDocCounts[n] + 1;
                    int n2 = field;
                    fieldTotals[n2] = fieldTotals[n2] + (double)v[0];
                }
                w.addDocument(doc);
            }
            try (DirectoryReader r = w.getReader();){
                for (int field = 0; field < numFields; ++field) {
                    int docCount = 0;
                    double checksum = 0.0;
                    String fieldName = "int" + field;
                    for (LeafReaderContext ctx : r.leaves()) {
                        VectorValues vectors = ctx.reader().getVectorValues(fieldName);
                        if (vectors == null) continue;
                        docCount += vectors.size();
                        while (vectors.nextDoc() != Integer.MAX_VALUE) {
                            checksum += (double)vectors.vectorValue()[0];
                        }
                    }
                    BaseKnnVectorsFormatTestCase.assertEquals((long)fieldDocCounts[field], (long)docCount);
                    BaseKnnVectorsFormatTestCase.assertEquals((double)fieldTotals[field], (double)checksum, (double)1.0E-5);
                }
            }
        }
    }

    public void testIndexedValueNotAliased() throws Exception {
        String fieldName = "field";
        float[] v = new float[]{0.0f};
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc1 = new Document();
            doc1.add((IndexableField)new KnnVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            v[0] = 1.0f;
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc1);
            iw.addDocument((Iterable)doc2);
            v[0] = 2.0f;
            Document doc3 = new Document();
            doc3.add((IndexableField)new KnnVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc3);
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                VectorValues vectorValues = r.getVectorValues(fieldName);
                vectorValues.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                vectorValues.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                vectorValues.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
            }
        }
    }

    public void testSortedIndex() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            this.add(iw, fieldName, 1, 1, new float[]{-1.0f, 0.0f});
            this.add(iw, fieldName, 4, 4, new float[]{0.0f, 1.0f});
            this.add(iw, fieldName, 3, 3, null);
            this.add(iw, fieldName, 2, 2, new float[]{1.0f, 0.0f});
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader leaf = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                VectorValues vectorValues = leaf.getVectorValues(fieldName);
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues.size());
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"1", (Object)leaf.document(vectorValues.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)-1.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"2", (Object)leaf.document(vectorValues.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"4", (Object)leaf.document(vectorValues.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues.nextDoc());
            }
        }
    }

    public void testIndexMultipleKnnVectorFields() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            float[] v = new float[]{1.0f};
            doc.add((IndexableField)new KnnVectorField("field1", v, VectorSimilarityFunction.EUCLIDEAN));
            doc.add((IndexableField)new KnnVectorField("field2", new float[]{1.0f, 2.0f, 3.0f}, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc);
            v[0] = 2.0f;
            iw.addDocument((Iterable)doc);
            doc = new Document();
            doc.add((IndexableField)new KnnVectorField("field3", new float[]{1.0f, 2.0f, 3.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            iw.addDocument((Iterable)doc);
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader leaf = ((LeafReaderContext)reader.leaves().get(0)).reader();
                VectorValues vectorValues = leaf.getVectorValues("field1");
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)vectorValues.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.size());
                vectorValues.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                vectorValues.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues.vectorValue()[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues.nextDoc());
                VectorValues vectorValues2 = leaf.getVectorValues("field2");
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues2.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues2.size());
                vectorValues2.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues2.vectorValue()[1], (float)0.0f);
                vectorValues2.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues2.vectorValue()[1], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues2.nextDoc());
                VectorValues vectorValues3 = leaf.getVectorValues("field3");
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues3.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)vectorValues3.size());
                vectorValues3.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues3.vectorValue()[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues3.nextDoc());
            }
        }
    }

    public void testRandom() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
            iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        }
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            float[] scratch = new float[dimension];
            int numValues = 0;
            float[][] values = new float[numDoc][];
            for (int i = 0; i < numDoc; ++i) {
                if (BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3) {
                    values[i] = this.randomVector(dimension);
                    ++numValues;
                }
                if (BaseKnnVectorsFormatTestCase.random().nextBoolean() && values[i] != null) {
                    System.arraycopy(values[i], 0, scratch, 0, scratch.length);
                    this.add(iw, fieldName, i, scratch, VectorSimilarityFunction.EUCLIDEAN);
                } else {
                    this.add(iw, fieldName, i, values[i], VectorSimilarityFunction.EUCLIDEAN);
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) == 2) {
                    int idToDelete = BaseKnnVectorsFormatTestCase.random().nextInt(i + 1);
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(idToDelete))});
                    if (values[idToDelete] != null) {
                        values[idToDelete] = null;
                        --numValues;
                    }
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) != 3) continue;
                iw.commit();
            }
            int numDeletes = 0;
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                int valueCount = 0;
                int totalSize = 0;
                for (LeafReaderContext ctx : reader.leaves()) {
                    int docId;
                    VectorValues vectorValues = ctx.reader().getVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    totalSize += vectorValues.size();
                    while ((docId = vectorValues.nextDoc()) != Integer.MAX_VALUE) {
                        float[] v = vectorValues.vectorValue();
                        BaseKnnVectorsFormatTestCase.assertEquals((long)dimension, (long)v.length);
                        String idString = ctx.reader().document(docId).getField("id").stringValue();
                        int id = Integer.parseInt(idString);
                        if (ctx.reader().getLiveDocs() == null || ctx.reader().getLiveDocs().get(docId)) {
                            BaseKnnVectorsFormatTestCase.assertArrayEquals((String)idString, (float[])values[id], (float[])v, (float)0.0f);
                            ++valueCount;
                            continue;
                        }
                        ++numDeletes;
                        BaseKnnVectorsFormatTestCase.assertNull((Object)values[id]);
                    }
                }
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)valueCount);
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)(totalSize - numDeletes));
            }
        }
    }

    public void testSearchWithVisitedLimit() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int i;
            int numDoc = 300;
            int dimension = 10;
            for (i = 0; i < numDoc; ++i) {
                float[] value = BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3 ? this.randomVector(dimension) : null;
                this.add(iw, fieldName, i, value, VectorSimilarityFunction.EUCLIDEAN);
            }
            iw.forceMerge(1);
            for (i = 0; i < 30; ++i) {
                int idToDelete = BaseKnnVectorsFormatTestCase.random().nextInt(numDoc);
                iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(idToDelete))});
            }
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    Bits liveDocs = ctx.reader().getLiveDocs();
                    VectorValues vectorValues = ctx.reader().getVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    int k = 5 + BaseKnnVectorsFormatTestCase.random().nextInt(45);
                    int visitedLimit = k + BaseKnnVectorsFormatTestCase.random().nextInt(5);
                    TopDocs results = ctx.reader().searchNearestVectors(fieldName, this.randomVector(dimension), k, liveDocs, visitedLimit);
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO, (Object)results.totalHits.relation);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)visitedLimit, (long)results.totalHits.value);
                    k = vectorValues.size();
                    visitedLimit = k + 30;
                    results = ctx.reader().searchNearestVectors(fieldName, this.randomVector(dimension), k, liveDocs, visitedLimit);
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)TotalHits.Relation.EQUAL_TO, (Object)results.totalHits.relation);
                    BaseKnnVectorsFormatTestCase.assertTrue((results.totalHits.value <= (long)visitedLimit ? 1 : 0) != 0);
                }
            }
        }
    }

    public void testRandomWithUpdatesAndGraph() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            float[][] id2value = new float[numDoc][];
            int[] id2ord = new int[numDoc];
            int i = 0;
            while (i < numDoc) {
                int id = BaseKnnVectorsFormatTestCase.random().nextInt(numDoc);
                float[] value = BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3 ? this.randomVector(dimension) : null;
                id2value[id] = value;
                id2ord[id] = i++;
                this.add(iw, fieldName, id, value, VectorSimilarityFunction.EUCLIDEAN);
            }
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    int docId;
                    Bits liveDocs = ctx.reader().getLiveDocs();
                    VectorValues vectorValues = ctx.reader().getVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    int numLiveDocsWithVectors = 0;
                    while ((docId = vectorValues.nextDoc()) != Integer.MAX_VALUE) {
                        float[] v = vectorValues.vectorValue();
                        BaseKnnVectorsFormatTestCase.assertEquals((long)dimension, (long)v.length);
                        String idString = ctx.reader().document(docId).getField("id").stringValue();
                        int id = Integer.parseInt(idString);
                        if (liveDocs == null || liveDocs.get(docId)) {
                            BaseKnnVectorsFormatTestCase.assertArrayEquals((String)("values differ for id=" + idString + ", docid=" + docId + " leaf=" + ctx.ord), (float[])id2value[id], (float[])v, (float)0.0f);
                            ++numLiveDocsWithVectors;
                            continue;
                        }
                        if (id2value[id] == null) continue;
                        BaseKnnVectorsFormatTestCase.assertFalse((boolean)Arrays.equals(id2value[id], v));
                    }
                    if (numLiveDocsWithVectors == 0) continue;
                    int size = ctx.reader().getVectorValues(fieldName).size();
                    int k = BaseKnnVectorsFormatTestCase.random().nextInt(size / 2 + 1) + 1;
                    if (k > numLiveDocsWithVectors) {
                        k = numLiveDocsWithVectors;
                    }
                    TopDocs results = ctx.reader().searchNearestVectors(fieldName, this.randomVector(dimension), k, liveDocs, Integer.MAX_VALUE);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Math.min(k, size), (long)results.scoreDocs.length);
                    for (int i2 = 0; i2 < k - 1; ++i2) {
                        BaseKnnVectorsFormatTestCase.assertTrue((results.scoreDocs[i2].score >= results.scoreDocs[i2 + 1].score ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    private void add(IndexWriter iw, String field, int id, float[] vector, VectorSimilarityFunction similarityFunction) throws IOException {
        this.add(iw, field, id, BaseKnnVectorsFormatTestCase.random().nextInt(100), vector, similarityFunction);
    }

    private void add(IndexWriter iw, String field, int id, int sortkey, float[] vector) throws IOException {
        this.add(iw, field, id, sortkey, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    private void add(IndexWriter iw, String field, int id, int sortkey, float[] vector, VectorSimilarityFunction similarityFunction) throws IOException {
        Document doc = new Document();
        if (vector != null) {
            doc.add((IndexableField)new KnnVectorField(field, vector, similarityFunction));
        }
        doc.add((IndexableField)new NumericDocValuesField("sortkey", (long)sortkey));
        String idString = Integer.toString(id);
        doc.add((IndexableField)new StringField("id", idString, Field.Store.YES));
        Term idTerm = new Term("id", idString);
        iw.updateDocument(idTerm, (Iterable)doc);
    }

    private float[] randomVector(int dim) {
        float[] v = new float[dim];
        for (int i = 0; i < dim; ++i) {
            v[i] = BaseKnnVectorsFormatTestCase.random().nextFloat();
        }
        VectorUtil.l2normalize((float[])v);
        return v;
    }

    public void testCheckIndexIncludesVectors() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnVectorField("v1", this.randomVector(3), VectorSimilarityFunction.EUCLIDEAN));
                w.addDocument((Iterable)doc);
                doc.add((IndexableField)new KnnVectorField("v2", this.randomVector(3), VectorSimilarityFunction.EUCLIDEAN));
                w.addDocument((Iterable)doc);
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            CheckIndex.Status status = TestUtil.checkIndex((Directory)dir, false, true, true, output);
            BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)status.segmentInfos.size());
            CheckIndex.Status.SegmentInfoStatus segStatus = (CheckIndex.Status.SegmentInfoStatus)status.segmentInfos.get(0);
            BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)segStatus.vectorValuesStatus.totalVectorValues);
            BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)segStatus.vectorValuesStatus.totalKnnVectorFields);
            BaseKnnVectorsFormatTestCase.assertTrue((boolean)output.toString(IOUtils.UTF_8).contains("test: vectors..."));
        }
    }

    public void testSimilarityFunctionIdentifiers() {
        BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)VectorSimilarityFunction.EUCLIDEAN.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)VectorSimilarityFunction.DOT_PRODUCT.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)VectorSimilarityFunction.COSINE.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)VectorSimilarityFunction.values().length);
    }

    public void testAdvance() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            int numdocs = BaseKnnVectorsFormatTestCase.atLeast(1500);
            String fieldName = "field";
            for (int i = 0; i < numdocs; ++i) {
                Document doc = new Document();
                if (BaseKnnVectorsFormatTestCase.random().nextInt(4) == 3) {
                    doc.add((IndexableField)new KnnVectorField(fieldName, new float[4], VectorSimilarityFunction.EUCLIDEAN));
                }
                w.addDocument((Iterable)doc);
            }
            w.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                VectorValues vectorValues = r.getVectorValues(fieldName);
                int[] vectorDocs = new int[vectorValues.size() + 1];
                int cur = -1;
                while (++cur < vectorValues.size() + 1) {
                    vectorDocs[cur] = vectorValues.nextDoc();
                    if (cur == 0) continue;
                    BaseKnnVectorsFormatTestCase.assertTrue((vectorDocs[cur] > vectorDocs[cur - 1] ? 1 : 0) != 0);
                }
                vectorValues = r.getVectorValues(fieldName);
                cur = -1;
                for (int i = 0; i < numdocs; ++i) {
                    if (BaseKnnVectorsFormatTestCase.random().nextInt(4) != 3) continue;
                    while (vectorDocs[++cur] < i) {
                    }
                    BaseKnnVectorsFormatTestCase.assertEquals((long)vectorDocs[cur], (long)vectorValues.advance(i));
                    BaseKnnVectorsFormatTestCase.assertEquals((long)vectorDocs[cur], (long)vectorValues.docID());
                    if (vectorValues.docID() == Integer.MAX_VALUE) {
                        break;
                    }
                    i = vectorValues.docID();
                }
            }
        }
    }

    public void testVectorValuesReportCorrectDocs() throws Exception {
        int numDocs = BaseKnnVectorsFormatTestCase.atLeast(1000);
        int dim = BaseKnnVectorsFormatTestCase.random().nextInt(20) + 1;
        VectorSimilarityFunction similarityFunction = VectorSimilarityFunction.values()[BaseKnnVectorsFormatTestCase.random().nextInt(VectorSimilarityFunction.values().length)];
        double fieldValuesCheckSum = 0.0;
        int fieldDocCount = 0;
        long fieldSumDocIDs = 0L;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             RandomIndexWriter w = new RandomIndexWriter(BaseKnnVectorsFormatTestCase.random(), (Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            for (int i = 0; i < numDocs; ++i) {
                Document doc = new Document();
                int docID = BaseKnnVectorsFormatTestCase.random().nextInt(numDocs);
                doc.add((IndexableField)new StoredField("id", docID));
                if (BaseKnnVectorsFormatTestCase.random().nextInt(4) == 3) {
                    float[] vector = this.randomVector(dim);
                    doc.add((IndexableField)new KnnVectorField("knn_vector", vector, similarityFunction));
                    fieldValuesCheckSum += (double)vector[0];
                    ++fieldDocCount;
                    fieldSumDocIDs += (long)docID;
                }
                w.addDocument(doc);
            }
            if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
                w.forceMerge(1);
            }
            try (DirectoryReader r = w.getReader();){
                double checksum = 0.0;
                int docCount = 0;
                long sumDocIds = 0L;
                for (LeafReaderContext ctx : r.leaves()) {
                    VectorValues vectors = ctx.reader().getVectorValues("knn_vector");
                    if (vectors == null) continue;
                    docCount += vectors.size();
                    while (vectors.nextDoc() != Integer.MAX_VALUE) {
                        checksum += (double)vectors.vectorValue()[0];
                        Document doc = ctx.reader().document(vectors.docID(), Set.of("id"));
                        sumDocIds += (long)Integer.parseInt(doc.get("id"));
                    }
                }
                BaseKnnVectorsFormatTestCase.assertEquals((double)fieldValuesCheckSum, (double)checksum, (double)0.001);
                BaseKnnVectorsFormatTestCase.assertEquals((long)fieldDocCount, (long)docCount);
                BaseKnnVectorsFormatTestCase.assertEquals((long)fieldSumDocIDs, (long)sumDocIds);
            }
        }
    }

    private static /* synthetic */ void lambda$testIllegalSimilarityFunctionChangeViaAddIndexesDirectory$15(IndexWriter w2, Directory dir) throws Throwable {
        w2.addIndexes(new Directory[]{dir});
    }

    private static /* synthetic */ void lambda$testIllegalDimChangeViaAddIndexesDirectory$14(IndexWriter w2, Directory dir) throws Throwable {
        w2.addIndexes(new Directory[]{dir});
    }
}

