/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;

public class FixedBitSetCollector
extends SimpleCollector {
    private final FixedBitSet bitSet;
    private int docBase;

    FixedBitSetCollector(int maxDoc) {
        this.bitSet = new FixedBitSet(maxDoc);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public void collect(int doc) throws IOException {
        this.bitSet.set(this.docBase + doc);
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public static CollectorManager<FixedBitSetCollector, FixedBitSet> createManager(final int maxDoc) {
        return new CollectorManager<FixedBitSetCollector, FixedBitSet>(){

            public FixedBitSetCollector newCollector() {
                return new FixedBitSetCollector(maxDoc);
            }

            public FixedBitSet reduce(Collection<FixedBitSetCollector> collectors) {
                FixedBitSet reduced = new FixedBitSet(maxDoc);
                for (FixedBitSetCollector collector : collectors) {
                    reduced.or(collector.bitSet);
                }
                return reduced;
            }
        };
    }
}

