/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterIndexOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class CorruptingIndexOutput
extends FilterIndexOutput {
    final Directory dir;
    final long byteToCorrupt;
    private boolean closed;

    public CorruptingIndexOutput(Directory dir, long byteToCorrupt, IndexOutput out) {
        super("CorruptingIndexOutput(" + out + ")", out.getName(), out);
        this.dir = dir;
        this.byteToCorrupt = byteToCorrupt;
    }

    public String getName() {
        return this.out.getName();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.out.close();
            this.corruptFile();
            this.closed = true;
        }
    }

    protected void corruptFile() throws IOException {
        String newTempName;
        try (IndexOutput tmpOut = this.dir.createTempOutput("tmp", "tmp", IOContext.DEFAULT);
             IndexInput in = this.dir.openInput(this.out.getName(), IOContext.DEFAULT);){
            newTempName = tmpOut.getName();
            if (this.byteToCorrupt >= in.length()) {
                throw new IllegalArgumentException("byteToCorrupt=" + this.byteToCorrupt + " but file \"" + this.out.getName() + "\" is only length=" + in.length());
            }
            tmpOut.copyBytes((DataInput)in, this.byteToCorrupt);
            tmpOut.writeByte((byte)(in.readByte() ^ 1));
            tmpOut.copyBytes((DataInput)in, in.length() - this.byteToCorrupt - 1L);
        }
        this.dir.deleteFile(this.out.getName());
        this.dir.copyFrom(this.dir, newTempName, this.out.getName(), IOContext.DEFAULT);
        this.dir.deleteFile(newTempName);
    }

    public long getChecksum() throws IOException {
        return this.out.getChecksum() ^ 1L;
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeByte(b[offset + i]);
        }
    }
}

