/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.tests.mockfile.FilterPath;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.Constants;

@LuceneTestCase.SuppressFileSystems(value={"*"})
public abstract class MockFileSystemTestCase
extends LuceneTestCase {
    protected abstract Path wrap(Path var1);

    public void testHashCodeEquals() throws IOException {
        Path dir = this.wrap(MockFileSystemTestCase.createTempDir());
        Path f1 = dir.resolve("file1");
        Path f1Again = dir.resolve("file1");
        Path f2 = dir.resolve("file2");
        MockFileSystemTestCase.assertEquals((Object)f1, (Object)f1);
        MockFileSystemTestCase.assertFalse((boolean)f1.equals(null));
        MockFileSystemTestCase.assertEquals((Object)f1, (Object)f1Again);
        MockFileSystemTestCase.assertEquals((long)f1.hashCode(), (long)f1Again.hashCode());
        MockFileSystemTestCase.assertFalse((boolean)f1.equals(f2));
        dir.getFileSystem().close();
    }

    public void testURI() throws IOException {
        this.implTestURI("file1");
    }

    public void testURIumlaute() throws IOException {
        this.implTestURI("\u00e4\u00c4\u00f6\u00d6\u00fc\u00dc\u00df");
    }

    public void testURIchinese() throws IOException {
        this.implTestURI("\u4e2d\u56fd");
    }

    private void implTestURI(String fileName) throws IOException {
        MockFileSystemTestCase.assumeFalse("broken on J9: see https://issues.apache.org/jira/browse/LUCENE-6517", Constants.JAVA_VENDOR.startsWith("IBM"));
        Path dir = this.wrap(MockFileSystemTestCase.createTempDir());
        Path f1 = null;
        try {
            f1 = dir.resolve(fileName);
        }
        catch (InvalidPathException ipe) {
            MockFileSystemTestCase.assumeNoException("couldn't resolve '" + fileName + "'", ipe);
        }
        URI uri = f1.toUri();
        Path f2 = dir.getFileSystem().provider().getPath(uri);
        MockFileSystemTestCase.assertEquals((Object)f1, (Object)f2);
        dir.getFileSystem().close();
    }

    public void testDirectoryStreamFiltered() throws IOException {
        Path dir = this.wrap(MockFileSystemTestCase.createTempDir());
        OutputStream file = Files.newOutputStream(dir.resolve("file1"), new OpenOption[0]);
        file.write(5);
        file.close();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            int count = 0;
            for (Path path : stream) {
                MockFileSystemTestCase.assertTrue((boolean)(path instanceof FilterPath));
                if (path.getFileName().toString().startsWith("extra")) continue;
                ++count;
            }
            MockFileSystemTestCase.assertEquals((long)1L, (long)count);
        }
        dir.getFileSystem().close();
    }

    public void testDirectoryStreamGlobFiltered() throws IOException {
        Path dir = this.wrap(MockFileSystemTestCase.createTempDir());
        OutputStream file = Files.newOutputStream(dir.resolve("foo"), new OpenOption[0]);
        file.write(5);
        file.close();
        file = Files.newOutputStream(dir.resolve("bar"), new OpenOption[0]);
        file.write(5);
        file.close();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "f*");){
            int count = 0;
            for (Path path : stream) {
                MockFileSystemTestCase.assertTrue((boolean)(path instanceof FilterPath));
                ++count;
            }
            MockFileSystemTestCase.assertEquals((long)1L, (long)count);
        }
        dir.getFileSystem().close();
    }
}

