/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.Scorable;

public class AssertingScorable
extends FilterScorable {
    public AssertingScorable(Scorable in) {
        super(in);
    }

    public float score() throws IOException {
        int docId = this.docID();
        assert (docId != -1 && docId != Integer.MAX_VALUE) : "score() called on unpositioned Scorable docid=" + this.docID();
        float score = this.in.score();
        assert (!Float.isNaN(score)) : "NaN score for in=" + this.in;
        return score;
    }

    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.in.setMinCompetitiveScore(minScore);
    }

    public static Scorable wrap(Scorable in) {
        if (in instanceof AssertingScorable) {
            return in;
        }
        return new AssertingScorable(in);
    }

    public static Scorable unwrap(Scorable in) {
        while (true) {
            if (in instanceof AssertingScorable) {
                in = ((AssertingScorable)in).in;
                continue;
            }
            if (!(in instanceof AssertingScorer)) break;
            in = ((AssertingScorer)in).in;
        }
        return in;
    }
}

