/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToIntFunction;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.MockRandomMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NullInfoStream;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

public abstract class BaseMergePolicyTestCase
extends LuceneTestCase {
    protected abstract MergePolicy mergePolicy();

    public void testForceMergeNotNeeded() throws IOException {
        try (BaseDirectoryWrapper dir = BaseMergePolicyTestCase.newDirectory();){
            int i;
            final AtomicBoolean mayMerge = new AtomicBoolean(true);
            SerialMergeScheduler mergeScheduler = new SerialMergeScheduler(){

                public synchronized void merge(IndexWriter writer, MergeTrigger trigger, boolean newMergesFound) throws IOException {
                    MergePolicy.OneMerge merge;
                    if (!mayMerge.get() && (merge = writer.getNextMerge()) != null) {
                        System.out.println("TEST: we should not need any merging, yet merge policy returned merge " + merge);
                        throw new AssertionError();
                    }
                    super.merge(writer, trigger, newMergesFound);
                }
            };
            MergePolicy mp = this.mergePolicy();
            BaseMergePolicyTestCase.assumeFalse("this test cannot tolerate random forceMerges", mp.toString().contains("MockRandomMergePolicy"));
            mp.setNoCFSRatio(BaseMergePolicyTestCase.random().nextBoolean() ? 0.0 : 1.0);
            IndexWriterConfig iwc = BaseMergePolicyTestCase.newIndexWriterConfig(new MockAnalyzer(BaseMergePolicyTestCase.random()));
            iwc.setMergeScheduler((MergeScheduler)mergeScheduler);
            iwc.setMergePolicy(mp);
            IndexWriter writer = new IndexWriter((Directory)dir, iwc);
            int numSegments = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 2, 20);
            for (i = 0; i < numSegments; ++i) {
                int numDocs = TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 5);
                for (int j = 0; j < numDocs; ++j) {
                    writer.addDocument((Iterable)new Document());
                }
                writer.getReader().close();
            }
            for (i = 5; i >= 0; --i) {
                int segmentCount = writer.getSegmentCount();
                int maxNumSegments = i == 0 ? 1 : TestUtil.nextInt(BaseMergePolicyTestCase.random(), 1, 10);
                mayMerge.set(segmentCount > maxNumSegments);
                if (VERBOSE) {
                    System.out.println("TEST: now forceMerge(maxNumSegments=" + maxNumSegments + ") vs segmentCount=" + segmentCount);
                }
                writer.forceMerge(maxNumSegments);
            }
            writer.close();
        }
    }

    public void testFindForcedDeletesMerges() throws IOException {
        MergePolicy mp = this.mergePolicy();
        if (mp instanceof FilterMergePolicy) {
            BaseMergePolicyTestCase.assumeFalse("test doesn't work with MockRandomMP", ((FilterMergePolicy)mp).in instanceof MockRandomMergePolicy);
        }
        SegmentInfos infos = new SegmentInfos(Version.LATEST.major);
        try (BaseDirectoryWrapper directory = BaseMergePolicyTestCase.newDirectory();){
            MockMergeContext context = new MockMergeContext(s -> 0);
            int numSegs = BaseMergePolicyTestCase.random().nextInt(10);
            for (int i = 0; i < numSegs; ++i) {
                SegmentInfo info = new SegmentInfo((Directory)directory, Version.LATEST, Version.LATEST, TestUtil.randomSimpleString(BaseMergePolicyTestCase.random()), BaseMergePolicyTestCase.random().nextInt(Integer.MAX_VALUE), BaseMergePolicyTestCase.random().nextBoolean(), null, Collections.emptyMap(), TestUtil.randomSimpleString(BaseMergePolicyTestCase.random(), 16, 16).getBytes(StandardCharsets.US_ASCII), Collections.emptyMap(), null);
                info.setFiles(Collections.emptyList());
                infos.add(new SegmentCommitInfo(info, BaseMergePolicyTestCase.random().nextInt(1), 0, -1L, -1L, -1L));
            }
            MergePolicy.MergeSpecification forcedDeletesMerges = mp.findForcedDeletesMerges(infos, (MergePolicy.MergeContext)context);
            if (forcedDeletesMerges != null) {
                BaseMergePolicyTestCase.assertEquals((long)0L, (long)forcedDeletesMerges.merges.size());
            }
        }
    }

    public static final class MockMergeContext
    implements MergePolicy.MergeContext {
        private final ToIntFunction<SegmentCommitInfo> numDeletesFunc;
        private final InfoStream infoStream = new NullInfoStream();

        public MockMergeContext(ToIntFunction<SegmentCommitInfo> numDeletesFunc) {
            this.numDeletesFunc = numDeletesFunc;
        }

        public int numDeletesToMerge(SegmentCommitInfo info) {
            return this.numDeletesFunc.applyAsInt(info);
        }

        public int numDeletedDocs(SegmentCommitInfo info) {
            return this.numDeletesToMerge(info);
        }

        public InfoStream getInfoStream() {
            return this.infoStream;
        }

        public Set<SegmentCommitInfo> getMergingSegments() {
            return Collections.emptySet();
        }
    }
}

