/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class ScorerIndexSearcher
extends IndexSearcher {
    public ScorerIndexSearcher(IndexReader r, ExecutorService executor) {
        super(r, executor);
    }

    public ScorerIndexSearcher(IndexReader r) {
        super(r);
    }

    protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        for (LeafReaderContext ctx : leaves) {
            Scorer scorer = weight.scorer(ctx);
            if (scorer == null) continue;
            LeafCollector leafCollector = collector.getLeafCollector(ctx);
            leafCollector.setScorer(scorer);
            int doc = scorer.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                leafCollector.collect(doc);
                doc = scorer.nextDoc();
            }
        }
    }
}

