/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class FilterFileChannel
extends FileChannel {
    protected final FileChannel delegate;

    public FilterFileChannel(FileChannel delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long position() throws IOException {
        return this.delegate.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.delegate.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.delegate.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.delegate.read(dst, position);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return this.delegate.write(src, position);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        return this.delegate.map(mode, position, size);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.delegate.lock(position, size, shared);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.delegate.tryLock(position, size, shared);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        for (Class<?> clazz = this.delegate.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method method;
            try {
                method = clazz.getDeclaredMethod("implCloseChannel", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                method.setAccessible(true);
                method.invoke((Object)this.delegate, new Object[0]);
                return;
            }
            catch (ReflectiveOperationException e) {
                throw new IOError(e);
            }
        }
        throw new AssertionError();
    }
}

