/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.AssertingSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class AssertingSpanQuery
extends SpanQuery {
    private final SpanQuery in;

    public AssertingSpanQuery(SpanQuery in) {
        this.in = in;
    }

    protected void extractTerms(Set<Term> terms) {
        this.in.extractTerms(terms);
    }

    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        Spans spans = this.in.getSpans(context, acceptDocs, termContexts);
        if (spans == null) {
            return null;
        }
        return new AssertingSpans(spans);
    }

    public String getField() {
        return this.in.getField();
    }

    public String toString(String field) {
        return "AssertingSpanQuery(" + this.in.toString(field) + ")";
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight weight = this.in.createWeight(searcher, needsScores);
        if (weight.getClass() == SpanWeight.class) {
            return super.createWeight(searcher, needsScores);
        }
        return weight;
    }

    public void setBoost(float b) {
        this.in.setBoost(b);
    }

    public float getBoost() {
        return this.in.getBoost();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query q = this.in.rewrite(reader);
        if (q == this.in) {
            return this;
        }
        if (q instanceof SpanQuery) {
            return new AssertingSpanQuery((SpanQuery)q);
        }
        return q;
    }

    public Query clone() {
        return new AssertingSpanQuery((SpanQuery)this.in.clone());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.in == null ? 0 : this.in.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AssertingSpanQuery other = (AssertingSpanQuery)((Object)obj);
        return !(this.in == null ? other.in != null : !this.in.equals((Object)other.in));
    }
}

