/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.mockfile.DisableFsyncFS;
import org.apache.lucene.mockfile.ExtrasFS;
import org.apache.lucene.mockfile.HandleLimitFS;
import org.apache.lucene.mockfile.LeakFS;
import org.apache.lucene.mockfile.VerboseFS;
import org.apache.lucene.mockfile.WindowsFS;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestRuleSetupAndRestoreClassEnv;

final class TestRuleTemporaryFilesCleanup
extends TestRuleAdapter {
    private static final int TEMP_NAME_RETRY_THRESHOLD = 9999;
    private Path javaTempDir;
    private Path tempDirBase;
    private FileSystem fileSystem;
    private final TestRuleMarkFailure failureMarker;
    private static final List<Path> cleanupQueue = new ArrayList<Path>();
    private static final int MAX_OPEN_FILES = 2048;

    public TestRuleTemporaryFilesCleanup(TestRuleMarkFailure failureMarker) {
        this.failureMarker = failureMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerToRemoveAfterSuite(Path f) {
        assert (f != null);
        if (LuceneTestCase.LEAVE_TEMPORARY) {
            System.err.println("INFO: Will leave temporary file: " + f.toAbsolutePath());
            return;
        }
        List<Path> list = cleanupQueue;
        synchronized (list) {
            cleanupQueue.add(f);
        }
    }

    protected void before() throws Throwable {
        super.before();
        assert (this.tempDirBase == null);
        this.fileSystem = this.initializeFileSystem();
        this.javaTempDir = this.initializeJavaTempDir();
    }

    private boolean allowed(Set<String> avoid, Class<? extends FileSystemProvider> clazz) {
        return !avoid.contains("*") && !avoid.contains(clazz.getSimpleName());
    }

    private FileSystem initializeFileSystem() {
        Random random;
        Class targetClass = RandomizedContext.current().getTargetClass();
        HashSet<String> avoid = new HashSet<String>();
        if (targetClass.isAnnotationPresent(LuceneTestCase.SuppressFileSystems.class)) {
            LuceneTestCase.SuppressFileSystems a = targetClass.getAnnotation(LuceneTestCase.SuppressFileSystems.class);
            avoid.addAll(Arrays.asList(a.value()));
        }
        FileSystem fs = FileSystems.getDefault();
        if (LuceneTestCase.VERBOSE && this.allowed(avoid, VerboseFS.class)) {
            fs = new VerboseFS(fs, (InfoStream)new TestRuleSetupAndRestoreClassEnv.ThreadNameFixingPrintStreamInfoStream(System.out)).getFileSystem(null);
        }
        if ((random = RandomizedContext.current().getRandom()).nextInt(10) > 0) {
            if (this.allowed(avoid, DisableFsyncFS.class)) {
                fs = new DisableFsyncFS(fs).getFileSystem(null);
            }
            if (this.allowed(avoid, LeakFS.class)) {
                fs = new LeakFS(fs).getFileSystem(null);
            }
            if (this.allowed(avoid, HandleLimitFS.class)) {
                fs = new HandleLimitFS(fs, 2048).getFileSystem(null);
            }
            if (random.nextInt(10) == 0 && !Constants.WINDOWS && this.allowed(avoid, WindowsFS.class)) {
                fs = new WindowsFS(fs).getFileSystem(null);
            }
            if (this.allowed(avoid, ExtrasFS.class)) {
                fs = new ExtrasFS(fs, new Random(random.nextLong())).getFileSystem(null);
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("filesystem: " + fs.provider());
        }
        return fs.provider().getFileSystem(URI.create("file:///"));
    }

    private Path initializeJavaTempDir() throws IOException {
        Path javaTempDir = this.fileSystem.getPath(System.getProperty("tempDir", System.getProperty("java.io.tmpdir")), new String[0]);
        Files.createDirectories(javaTempDir, new FileAttribute[0]);
        assert (Files.isDirectory(javaTempDir, new LinkOption[0]) && Files.isWritable(javaTempDir));
        return javaTempDir.toRealPath(new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterAlways(List<Throwable> errors) throws Throwable {
        Path[] everything;
        String tempDirBasePath;
        List<Path> list = cleanupQueue;
        synchronized (list) {
            tempDirBasePath = this.tempDirBase != null ? this.tempDirBase.toAbsolutePath().toString() : null;
            this.tempDirBase = null;
            Collections.reverse(cleanupQueue);
            everything = new Path[cleanupQueue.size()];
            cleanupQueue.toArray(everything);
            cleanupQueue.clear();
        }
        if (this.failureMarker.wasSuccessful()) {
            try {
                IOUtils.rm((Path[])everything);
            }
            catch (IOException e) {
                Class suiteClass = RandomizedContext.current().getTargetClass();
                if (suiteClass.isAnnotationPresent(LuceneTestCase.SuppressTempFileChecks.class)) {
                    System.err.println("WARNING: Leftover undeleted temporary files (bugUrl: " + suiteClass.getAnnotation(LuceneTestCase.SuppressTempFileChecks.class).bugUrl() + "): " + e.getMessage());
                    return;
                }
                throw e;
            }
            if (this.fileSystem != FileSystems.getDefault()) {
                this.fileSystem.close();
            }
        } else if (tempDirBasePath != null) {
            System.err.println("NOTE: leaving temporary files on disk at: " + tempDirBasePath);
        }
    }

    final Path getPerTestClassTempDir() {
        if (this.tempDirBase == null) {
            Path f;
            RandomizedContext ctx = RandomizedContext.current();
            Class clazz = ctx.getTargetClass();
            String prefix = clazz.getName();
            prefix = prefix.replaceFirst("^org.apache.lucene.", "lucene.");
            prefix = prefix.replaceFirst("^org.apache.solr.", "solr.");
            int attempt = 0;
            boolean success = false;
            do {
                if (attempt++ >= 9999) {
                    throw new RuntimeException("Failed to get a temporary name too many times, check your temp directory and consider manually cleaning it: " + this.javaTempDir.toAbsolutePath());
                }
                f = this.javaTempDir.resolve(prefix + " " + ctx.getRunnerSeedAsString() + "-" + String.format(Locale.ENGLISH, "%03d", attempt));
                try {
                    Files.createDirectory(f, new FileAttribute[0]);
                    success = true;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            } while (!success);
            this.tempDirBase = f;
            this.registerToRemoveAfterSuite(this.tempDirBase);
        }
        return this.tempDirBase;
    }

    public Path createTempDir(String prefix) {
        Path f;
        Path base = this.getPerTestClassTempDir();
        int attempt = 0;
        boolean success = false;
        do {
            if (attempt++ >= 9999) {
                throw new RuntimeException("Failed to get a temporary name too many times, check your temp directory and consider manually cleaning it: " + base.toAbsolutePath());
            }
            f = base.resolve(prefix + "-" + String.format(Locale.ENGLISH, "%03d", attempt));
            try {
                Files.createDirectory(f, new FileAttribute[0]);
                success = true;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        } while (!success);
        this.registerToRemoveAfterSuite(f);
        return f;
    }

    public Path createTempFile(String prefix, String suffix) throws IOException {
        Path f;
        Path base = this.getPerTestClassTempDir();
        int attempt = 0;
        boolean success = false;
        do {
            if (attempt++ >= 9999) {
                throw new RuntimeException("Failed to get a temporary name too many times, check your temp directory and consider manually cleaning it: " + base.toAbsolutePath());
            }
            f = base.resolve(prefix + "-" + String.format(Locale.ENGLISH, "%03d", attempt) + suffix);
            try {
                Files.createFile(f, new FileAttribute[0]);
                success = true;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        } while (!success);
        this.registerToRemoveAfterSuite(f);
        return f;
    }
}

