/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.apache.lucene.search.Scorer;

public class AssertingScorer
extends Scorer {
    private static Map<Scorer, WeakReference<AssertingScorer>> ASSERTING_INSTANCES = Collections.synchronizedMap(new WeakHashMap());
    final Random random;
    final Scorer in;
    IteratorState state = IteratorState.START;
    int doc = -1;

    public static Scorer wrap(Random random, Scorer other) {
        if (other == null || other instanceof AssertingScorer) {
            return other;
        }
        AssertingScorer assertScorer = new AssertingScorer(random, other);
        ASSERTING_INSTANCES.put(other, new WeakReference<AssertingScorer>(assertScorer));
        return assertScorer;
    }

    static Scorer getAssertingScorer(Random random, Scorer other) {
        AssertingScorer assertingScorer;
        if (other == null || other instanceof AssertingScorer) {
            return other;
        }
        WeakReference<AssertingScorer> assertingScorerRef = ASSERTING_INSTANCES.get(other);
        AssertingScorer assertingScorer2 = assertingScorer = assertingScorerRef == null ? null : (AssertingScorer)((Object)assertingScorerRef.get());
        if (assertingScorer == null) {
            return new AssertingScorer(random, other);
        }
        return assertingScorer;
    }

    private AssertingScorer(Random random, Scorer in) {
        super(in.weight);
        this.random = random;
        this.in = in;
    }

    public Scorer getIn() {
        return this.in;
    }

    boolean iterating() {
        switch (this.docID()) {
            case -1: 
            case 0x7FFFFFFF: {
                return false;
            }
        }
        return true;
    }

    public float score() throws IOException {
        assert (this.iterating());
        float score = this.in.score();
        assert (!Float.isNaN(score)) : "NaN score for in=" + this.in;
        return score;
    }

    public Collection<Scorer.ChildScorer> getChildren() {
        return Collections.singletonList(new Scorer.ChildScorer(this.in, "SHOULD"));
    }

    public int freq() throws IOException {
        assert (this.iterating());
        return this.in.freq();
    }

    public int docID() {
        return this.in.docID();
    }

    public int nextDoc() throws IOException {
        assert (this.state != IteratorState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
        int nextDoc = this.in.nextDoc();
        assert (nextDoc > this.doc) : "backwards nextDoc from " + this.doc + " to " + nextDoc + " " + this.in;
        this.state = nextDoc == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
        assert (this.in.docID() == nextDoc);
        this.doc = nextDoc;
        return this.doc;
    }

    public int advance(int target) throws IOException {
        assert (this.state != IteratorState.FINISHED) : "advance() called after NO_MORE_DOCS";
        assert (target > this.doc) : "target must be > docID(), got " + target + " <= " + this.doc;
        int advanced = this.in.advance(target);
        assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
        this.state = advanced == Integer.MAX_VALUE ? IteratorState.FINISHED : IteratorState.ITERATING;
        assert (this.in.docID() == advanced);
        this.doc = advanced;
        return this.doc;
    }

    public long cost() {
        return this.in.cost();
    }

    public String toString() {
        return "AssertingScorer(" + this.in + ")";
    }

    static enum IteratorState {
        START,
        ITERATING,
        FINISHED;

    }
}

