/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.mockfile.FilterAsynchronousFileChannel;
import org.apache.lucene.mockfile.FilterDirectoryStream;
import org.apache.lucene.mockfile.FilterFileChannel;
import org.apache.lucene.mockfile.FilterFileSystemProvider;
import org.apache.lucene.mockfile.FilterInputStream2;
import org.apache.lucene.mockfile.FilterOutputStream2;
import org.apache.lucene.mockfile.FilterSecureDirectoryStream;
import org.apache.lucene.mockfile.FilterSeekableByteChannel;
import org.apache.lucene.util.IOUtils;

public abstract class HandleTrackingFS
extends FilterFileSystemProvider {
    public HandleTrackingFS(String scheme, FileSystem delegate) {
        super(scheme, delegate);
    }

    protected abstract void onOpen(Path var1, Object var2) throws IOException;

    protected abstract void onClose(Path var1, Object var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void callOpenHook(Path path, Closeable stream) throws IOException {
        boolean success = false;
        try {
            this.onOpen(path, stream);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{stream});
            throw throwable;
        }
    }

    @Override
    public InputStream newInputStream(final Path path, OpenOption ... options) throws IOException {
        FilterInputStream2 stream = new FilterInputStream2(super.newInputStream(path, options)){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(path, this);
                }
                super.close();
            }

            public String toString() {
                return "InputStream(" + path.toString() + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(path, stream);
        return stream;
    }

    @Override
    public OutputStream newOutputStream(final Path path, OpenOption ... options) throws IOException {
        FilterOutputStream2 stream = new FilterOutputStream2(super.newOutputStream(path, options)){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(path, this);
                }
                super.close();
            }

            public String toString() {
                return "OutputStream(" + path.toString() + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(path, stream);
        return stream;
    }

    @Override
    public FileChannel newFileChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FilterFileChannel channel = new FilterFileChannel(super.newFileChannel(path, options, attrs)){
            boolean closed;

            @Override
            protected void implCloseChannel() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(path, this);
                }
                super.implCloseChannel();
            }

            public String toString() {
                return "FileChannel(" + path.toString() + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(path, channel);
        return channel;
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(final Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        FilterAsynchronousFileChannel channel = new FilterAsynchronousFileChannel(super.newAsynchronousFileChannel(path, options, executor, attrs)){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(path, this);
                }
                super.close();
            }

            public String toString() {
                return "AsynchronousFileChannel(" + path.toString() + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(path, channel);
        return channel;
    }

    @Override
    public SeekableByteChannel newByteChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FilterSeekableByteChannel channel = new FilterSeekableByteChannel(super.newByteChannel(path, options, attrs)){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(path, this);
                }
                super.close();
            }

            public String toString() {
                return "SeekableByteChannel(" + path.toString() + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(path, channel);
        return channel;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(final Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        DirectoryStream<Path> stream = super.newDirectoryStream(dir, filter);
        stream = stream instanceof SecureDirectoryStream ? new TrackingSecureDirectoryStream((SecureDirectoryStream)stream, dir) : new FilterDirectoryStream<Path>(stream){
            boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    HandleTrackingFS.this.onClose(dir, this);
                }
                super.close();
            }

            public String toString() {
                return "DirectoryStream(" + dir + ")";
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        this.callOpenHook(dir, stream);
        return stream;
    }

    class TrackingSecureDirectoryStream
    extends FilterSecureDirectoryStream<Path> {
        final Path dir;
        boolean closed;

        TrackingSecureDirectoryStream(SecureDirectoryStream<Path> delegate, Path dir) {
            super(delegate);
            this.dir = dir;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                HandleTrackingFS.this.onClose(this.dir, this);
            }
            super.close();
        }

        public String toString() {
            return "SecureDirectoryStream(" + this.dir + ")";
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public SecureDirectoryStream<Path> newDirectoryStream(Path path, LinkOption ... options) throws IOException {
            TrackingSecureDirectoryStream stream = new TrackingSecureDirectoryStream(super.newDirectoryStream(path, options), path);
            HandleTrackingFS.this.callOpenHook(path, stream);
            return stream;
        }

        @Override
        public SeekableByteChannel newByteChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            FilterSeekableByteChannel channel = new FilterSeekableByteChannel(super.newByteChannel(path, options, attrs)){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        this.closed = true;
                        HandleTrackingFS.this.onClose(path, this);
                    }
                    super.close();
                }

                public String toString() {
                    return "SeekableByteChannel(" + path.toString() + ")";
                }

                public int hashCode() {
                    return System.identityHashCode(this);
                }

                public boolean equals(Object obj) {
                    return this == obj;
                }
            };
            HandleTrackingFS.this.callOpenHook(path, channel);
            return channel;
        }
    }
}

