/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.ramonly;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public final class RAMOnlyPostingsFormat
extends PostingsFormat {
    private final Map<Integer, RAMPostings> state = new HashMap<Integer, RAMPostings>();
    private final AtomicInteger nextID = new AtomicInteger();
    private final String RAM_ONLY_NAME = "RAMOnly";
    private static final int VERSION_START = 0;
    private static final int VERSION_LATEST = 0;
    private static final String ID_EXTENSION = "id";

    public RAMOnlyPostingsFormat() {
        super("RAMOnly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState writeState) throws IOException {
        int id;
        block8: {
            IndexOutput out;
            block7: {
                id = this.nextID.getAndIncrement();
                String idFileName = IndexFileNames.segmentFileName((String)writeState.segmentInfo.name, (String)writeState.segmentSuffix, (String)ID_EXTENSION);
                out = writeState.directory.createOutput(idFileName, writeState.context);
                boolean success = false;
                try {
                    CodecUtil.writeHeader((DataOutput)out, (String)"RAMOnly", (int)0);
                    out.writeVInt(id);
                    success = true;
                    if (success) break block7;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    } else {
                        IOUtils.close((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                break block8;
            }
            IOUtils.close((Closeable[])new Closeable[]{out});
        }
        RAMPostings postings = new RAMPostings();
        RAMFieldsConsumer consumer = new RAMFieldsConsumer(writeState, postings);
        Map<Integer, RAMPostings> map = this.state;
        synchronized (map) {
            this.state.put(id, postings);
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState readState) throws IOException {
        int id;
        block8: {
            IndexInput in;
            block7: {
                String idFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)ID_EXTENSION);
                in = readState.directory.openInput(idFileName, readState.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)in, (String)"RAMOnly", (int)0, (int)0);
                    id = in.readVInt();
                    success = true;
                    if (success) break block7;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    } else {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                break block8;
            }
            IOUtils.close((Closeable[])new Closeable[]{in});
        }
        Map<Integer, RAMPostings> map = this.state;
        synchronized (map) {
            return this.state.get(id);
        }
    }

    private static class RAMDocsEnum
    extends PostingsEnum {
        private final RAMTerm ramTerm;
        private final Bits liveDocs;
        private RAMDoc current;
        int upto = -1;
        int posUpto = 0;

        public RAMDocsEnum(RAMTerm ramTerm, Bits liveDocs) {
            this.ramTerm = ramTerm;
            this.liveDocs = liveDocs;
        }

        public int advance(int targetDocID) throws IOException {
            return this.slowAdvance(targetDocID);
        }

        public int nextDoc() {
            block1: {
                do {
                    ++this.upto;
                    if (this.upto >= this.ramTerm.docs.size()) break block1;
                    this.current = this.ramTerm.docs.get(this.upto);
                } while (this.liveDocs != null && !this.liveDocs.get(this.current.docID));
                this.posUpto = 0;
                return this.current.docID;
            }
            return Integer.MAX_VALUE;
        }

        public int freq() throws IOException {
            return this.current.positions.length;
        }

        public int docID() {
            return this.current.docID;
        }

        public int nextPosition() {
            assert (this.posUpto < this.current.positions.length);
            return this.current.positions[this.posUpto++];
        }

        public int startOffset() {
            return -1;
        }

        public int endOffset() {
            return -1;
        }

        public BytesRef getPayload() {
            if (this.current.payloads != null && this.current.payloads[this.posUpto - 1] != null) {
                return new BytesRef(this.current.payloads[this.posUpto - 1]);
            }
            return null;
        }

        public long cost() {
            return this.ramTerm.docs.size();
        }
    }

    static class RAMTermsEnum
    extends TermsEnum {
        Iterator<String> it;
        String current;
        private final RAMField ramField;

        public RAMTermsEnum(RAMField field) {
            this.ramField = field;
        }

        public BytesRef next() {
            if (this.it == null) {
                this.it = this.current == null ? this.ramField.termToDocs.keySet().iterator() : this.ramField.termToDocs.tailMap(this.current).keySet().iterator();
            }
            if (this.it.hasNext()) {
                this.current = this.it.next();
                return new BytesRef((CharSequence)this.current);
            }
            return null;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term) {
            this.current = term.utf8ToString();
            this.it = null;
            if (this.ramField.termToDocs.containsKey(this.current)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            if (this.current.compareTo(this.ramField.termToDocs.lastKey()) > 0) {
                return TermsEnum.SeekStatus.END;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public long ord() {
            throw new UnsupportedOperationException();
        }

        public BytesRef term() {
            return new BytesRef((CharSequence)this.current);
        }

        public int docFreq() {
            return ((RAMTerm)this.ramField.termToDocs.get((Object)this.current)).docs.size();
        }

        public long totalTermFreq() {
            return ((RAMTerm)this.ramField.termToDocs.get((Object)this.current)).totalTermFreq;
        }

        public PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) {
            return new RAMDocsEnum((RAMTerm)this.ramField.termToDocs.get(this.current), liveDocs);
        }
    }

    static class RAMPostingsWriterImpl {
        private RAMTerm term;
        private RAMDoc current;
        private int posUpto = 0;

        RAMPostingsWriterImpl() {
        }

        public void reset(RAMTerm term) {
            this.term = term;
        }

        public void startDoc(int docID, int freq) {
            this.current = new RAMDoc(docID, freq);
            this.term.docs.add(this.current);
            this.posUpto = 0;
        }

        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) {
            assert (startOffset == -1);
            assert (endOffset == -1);
            this.current.positions[this.posUpto] = position;
            if (payload != null && payload.length > 0) {
                if (this.current.payloads == null) {
                    this.current.payloads = new byte[this.current.positions.length][];
                }
                this.current.payloads[this.posUpto] = new byte[payload.length];
                byte[] bytes = this.current.payloads[this.posUpto];
                System.arraycopy(payload.bytes, payload.offset, bytes, 0, payload.length);
            }
            ++this.posUpto;
        }

        public void finishDoc() {
            assert (this.posUpto == this.current.positions.length);
        }
    }

    private static class RAMTermsConsumer {
        private RAMField field;
        private final RAMPostingsWriterImpl postingsWriter = new RAMPostingsWriterImpl();
        RAMTerm current;

        private RAMTermsConsumer() {
        }

        void reset(RAMField field) {
            this.field = field;
        }

        public RAMPostingsWriterImpl startTerm(BytesRef text) {
            String term = text.utf8ToString();
            this.current = new RAMTerm(term);
            this.postingsWriter.reset(this.current);
            return this.postingsWriter;
        }

        public void finishTerm(BytesRef text, TermStats stats) {
            assert (stats.docFreq > 0);
            assert (stats.docFreq == this.current.docs.size());
            this.current.totalTermFreq = stats.totalTermFreq;
            this.field.termToDocs.put(this.current.term, this.current);
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) {
            this.field.sumTotalTermFreq = sumTotalTermFreq;
            this.field.sumDocFreq = sumDocFreq;
            this.field.docCount = docCount;
        }
    }

    private static class RAMFieldsConsumer
    extends FieldsConsumer {
        private final RAMPostings postings;
        private final RAMTermsConsumer termsConsumer = new RAMTermsConsumer();
        private final SegmentWriteState state;

        public RAMFieldsConsumer(SegmentWriteState writeState, RAMPostings postings) {
            this.postings = postings;
            this.state = writeState;
        }

        public void write(Fields fields) throws IOException {
            for (String field : fields) {
                BytesRef term;
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                TermsEnum termsEnum = terms.iterator(null);
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
                if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
                    throw new UnsupportedOperationException("this codec cannot index offsets");
                }
                RAMField ramField = new RAMField(field, fieldInfo);
                this.postings.fieldToTerms.put(field, ramField);
                this.termsConsumer.reset(ramField);
                FixedBitSet docsSeen = new FixedBitSet(this.state.segmentInfo.maxDoc());
                long sumTotalTermFreq = 0L;
                long sumDocFreq = 0L;
                PostingsEnum postingsEnum = null;
                IndexOptions indexOptions = fieldInfo.getIndexOptions();
                boolean writeFreqs = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
                boolean writePositions = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                boolean writeOffsets = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                boolean writePayloads = fieldInfo.hasPayloads();
                int enumFlags = !writeFreqs ? 0 : (!writePositions ? 8 : (!writeOffsets ? (writePayloads ? 88 : 0) : (writePayloads ? 120 : 56)));
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    RAMPostingsWriterImpl postingsWriter = this.termsConsumer.startTerm(term);
                    postingsEnum = termsEnum.postings(null, postingsEnum, enumFlags);
                    int docFreq = 0;
                    long totalTermFreq = 0L;
                    while ((docID = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        int freq;
                        docsSeen.set(docID);
                        ++docFreq;
                        if (writeFreqs) {
                            freq = postingsEnum.freq();
                            totalTermFreq += (long)freq;
                        } else {
                            freq = -1;
                        }
                        postingsWriter.startDoc(docID, freq);
                        if (writePositions) {
                            for (int i = 0; i < freq; ++i) {
                                int endOffset;
                                int startOffset;
                                BytesRef payload;
                                int pos = postingsEnum.nextPosition();
                                BytesRef bytesRef = payload = writePayloads ? postingsEnum.getPayload() : null;
                                if (writeOffsets) {
                                    startOffset = postingsEnum.startOffset();
                                    endOffset = postingsEnum.endOffset();
                                } else {
                                    startOffset = -1;
                                    endOffset = -1;
                                }
                                postingsWriter.addPosition(pos, payload, startOffset, endOffset);
                            }
                        }
                        postingsWriter.finishDoc();
                    }
                    this.termsConsumer.finishTerm(term, new TermStats(docFreq, totalTermFreq));
                    sumDocFreq += (long)docFreq;
                    sumTotalTermFreq += totalTermFreq;
                }
                this.termsConsumer.finish(sumTotalTermFreq, sumDocFreq, docsSeen.cardinality());
            }
        }

        public void close() throws IOException {
        }
    }

    static class RAMDoc
    implements Accountable {
        final int docID;
        final int[] positions;
        byte[][] payloads;

        public RAMDoc(int docID, int freq) {
            this.docID = docID;
            this.positions = new int[freq];
        }

        public long ramBytesUsed() {
            long sizeInBytes = 0L;
            sizeInBytes += this.positions != null ? RamUsageEstimator.sizeOf((int[])this.positions) : 0L;
            if (this.payloads != null) {
                for (byte[] payload : this.payloads) {
                    sizeInBytes += payload != null ? RamUsageEstimator.sizeOf((byte[])payload) : 0L;
                }
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static class RAMTerm
    implements Accountable {
        final String term;
        long totalTermFreq;
        final List<RAMDoc> docs = new ArrayList<RAMDoc>();

        public RAMTerm(String term) {
            this.term = term;
        }

        public long ramBytesUsed() {
            long sizeInBytes = 0L;
            for (RAMDoc rDoc : this.docs) {
                sizeInBytes += rDoc.ramBytesUsed();
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static class RAMField
    extends Terms
    implements Accountable {
        final String field;
        final SortedMap<String, RAMTerm> termToDocs = new TreeMap<String, RAMTerm>();
        long sumTotalTermFreq;
        long sumDocFreq;
        int docCount;
        final FieldInfo info;

        RAMField(String field, FieldInfo info) {
            this.field = field;
            this.info = info;
        }

        public long ramBytesUsed() {
            long sizeInBytes = 0L;
            for (RAMTerm term : this.termToDocs.values()) {
                sizeInBytes += term.ramBytesUsed();
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public long size() {
            return this.termToDocs.size();
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        public TermsEnum iterator(TermsEnum reuse) {
            return new RAMTermsEnum(this);
        }

        public boolean hasFreqs() {
            return this.info.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public boolean hasOffsets() {
            return this.info.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.info.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.info.hasPayloads();
        }
    }

    static class RAMPostings
    extends FieldsProducer {
        final Map<String, RAMField> fieldToTerms = new TreeMap<String, RAMField>();

        RAMPostings() {
        }

        public Terms terms(String field) {
            return this.fieldToTerms.get(field);
        }

        public int size() {
            return this.fieldToTerms.size();
        }

        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fieldToTerms.keySet()).iterator();
        }

        public void close() {
        }

        public long ramBytesUsed() {
            long sizeInBytes = 0L;
            for (RAMField field : this.fieldToTerms.values()) {
                sizeInBytes += field.ramBytesUsed();
            }
            return sizeInBytes;
        }

        public Collection<Accountable> getChildResources() {
            return Accountables.namedAccountables((String)"field", this.fieldToTerms);
        }

        public void checkIntegrity() throws IOException {
        }
    }
}

