/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

class AssertingLeafCollector
extends FilterLeafCollector {
    private final Random random;
    private final int max;
    private Scorer scorer;
    private int lastCollected = -1;

    AssertingLeafCollector(Random random, LeafCollector collector, int max) {
        super(collector);
        this.random = random;
        this.max = max;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        super.setScorer(AssertingScorer.getAssertingScorer(this.random, scorer));
    }

    public void collect(int doc) throws IOException {
        assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
        assert (doc < this.max) : "Out of range: " + doc + " >= " + this.max;
        assert (this.scorer.docID() == doc) : "Collected: " + doc + " but scorer: " + this.scorer.docID();
        this.in.collect(doc);
        this.lastCollected = doc;
    }
}

