/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AssertingLeafCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.LeafCollector;

class AssertingCollector
extends FilterCollector {
    private final Random random;
    private int maxDoc = -1;

    public static Collector wrap(Random random, Collector in) {
        if (in instanceof AssertingCollector) {
            return in;
        }
        return new AssertingCollector(random, in);
    }

    private AssertingCollector(Random random, Collector in) {
        super(in);
        this.random = random;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        LeafCollector in = super.getLeafCollector(context);
        final int docBase = context.docBase;
        return new AssertingLeafCollector(this.random, in, Integer.MAX_VALUE){

            @Override
            public void collect(int doc) throws IOException {
                assert (docBase + doc >= AssertingCollector.this.maxDoc) : "collection is not in order: current doc=" + (docBase + doc) + " while " + AssertingCollector.access$000(AssertingCollector.this) + " has already been collected";
                super.collect(doc);
                AssertingCollector.this.maxDoc = docBase + doc;
            }
        };
    }
}

