/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.search.AssertingLeafCollector;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;

final class AssertingBulkScorer
extends BulkScorer {
    final Random random;
    final BulkScorer in;

    public static BulkScorer wrap(Random random, BulkScorer other) {
        if (other == null || other instanceof AssertingBulkScorer) {
            return other;
        }
        return new AssertingBulkScorer(random, other);
    }

    private AssertingBulkScorer(Random random, BulkScorer in) {
        this.random = random;
        this.in = in;
    }

    public BulkScorer getIn() {
        return this.in;
    }

    public void score(LeafCollector collector) throws IOException {
        collector = new AssertingLeafCollector(this.random, (LeafCollector)collector, Integer.MAX_VALUE);
        if (this.random.nextBoolean()) {
            try {
                boolean remaining = this.in.score(collector, Integer.MAX_VALUE);
                assert (!remaining);
            }
            catch (UnsupportedOperationException e) {
                this.in.score(collector);
            }
        } else {
            this.in.score(collector);
        }
    }

    public boolean score(LeafCollector collector, int max) throws IOException {
        collector = new AssertingLeafCollector(this.random, (LeafCollector)collector, max);
        return this.in.score(collector, max);
    }

    public String toString() {
        return "AssertingBulkScorer(" + this.in + ")";
    }
}

