/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomCodec;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SimpleMergedSegmentWarmer;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.DoubleBarrelLRUCache;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.RamUsageTester;

abstract class BaseIndexFileFormatTestCase
extends LuceneTestCase {
    private static final Set<Class<?>> EXCLUDED_CLASSES = Collections.newSetFromMap(new IdentityHashMap());
    private Codec savedCodec;

    BaseIndexFileFormatTestCase() {
    }

    protected abstract Codec getCodec();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    protected abstract void addRandomFields(Document var1);

    private Map<String, Long> bytesUsedByExtension(Directory d) throws IOException {
        HashMap<String, Long> bytesUsedByExtension = new HashMap<String, Long>();
        for (String file : d.listAll()) {
            String ext = IndexFileNames.getExtension((String)file);
            long previousLength = bytesUsedByExtension.containsKey(ext) ? (Long)bytesUsedByExtension.get(ext) : 0L;
            bytesUsedByExtension.put(ext, previousLength + d.fileLength(file));
        }
        bytesUsedByExtension.keySet().removeAll(this.excludedExtensionsFromByteCounts());
        return bytesUsedByExtension;
    }

    protected Collection<String> excludedExtensionsFromByteCounts() {
        return new HashSet<String>(Arrays.asList("si", "lock"));
    }

    public void testMergeStability() throws Exception {
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newDirectory();
        TieredMergePolicy mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        IndexWriterConfig cfg = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDirectoryWrapper dir2 = BaseIndexFileFormatTestCase.newDirectory();
        mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        cfg = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        w = new IndexWriter((Directory)dir2, cfg);
        w.addIndexes(new IndexReader[]{reader});
        w.commit();
        w.close();
        BaseIndexFileFormatTestCase.assertEquals(this.bytesUsedByExtension((Directory)dir), this.bytesUsedByExtension((Directory)dir2));
        reader.close();
        dir.close();
        dir2.close();
    }

    public void testRamBytesUsed() throws IOException {
        if (Codec.getDefault() instanceof RandomCodec) {
            HashSet<String> avoidCodecs = new HashSet<String>(((RandomCodec)Codec.getDefault()).avoidCodecs);
            avoidCodecs.add(new MockRandomPostingsFormat().getName());
            Codec.setDefault((Codec)new RandomCodec(BaseIndexFileFormatTestCase.random(), avoidCodecs));
        }
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newDirectory();
        IndexWriterConfig cfg = BaseIndexFileFormatTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(BaseIndexFileFormatTestCase.random()));
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(10000);
        SegmentReader reader1 = null;
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
            if (i != 100) continue;
            w.forceMerge(1);
            w.commit();
            reader1 = BaseIndexFileFormatTestCase.getOnlySegmentReader(DirectoryReader.open((Directory)dir));
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        SegmentReader reader2 = BaseIndexFileFormatTestCase.getOnlySegmentReader(DirectoryReader.open((Directory)dir));
        for (AtomicReader reader : Arrays.asList(reader1, reader2)) {
            new SimpleMergedSegmentWarmer(InfoStream.NO_OUTPUT).warm(reader);
        }
        long actualBytes = RamUsageTester.sizeOf(reader2, new Accumulator(reader2)) - RamUsageTester.sizeOf(reader1, new Accumulator(reader1));
        long expectedBytes = reader2.ramBytesUsed() - reader1.ramBytesUsed();
        long absoluteError = actualBytes - expectedBytes;
        double relativeError = (double)absoluteError / (double)actualBytes;
        String message = "Actual RAM usage " + actualBytes + ", but got " + expectedBytes + ", " + 100.0 * relativeError + "% error";
        BaseIndexFileFormatTestCase.assertTrue((String)message, (Math.abs(relativeError) < 0.2 || Math.abs(absoluteError) < 1000L ? 1 : 0) != 0);
        reader1.close();
        reader2.close();
        dir.close();
    }

    static {
        EXCLUDED_CLASSES.add(Directory.class);
        EXCLUDED_CLASSES.add(IndexInput.class);
        EXCLUDED_CLASSES.add(IntIndexInput.class);
        EXCLUDED_CLASSES.add(CloseableThreadLocal.class);
        EXCLUDED_CLASSES.add(ThreadLocal.class);
        EXCLUDED_CLASSES.add(IndexReader.class);
        EXCLUDED_CLASSES.add(IndexReaderContext.class);
        EXCLUDED_CLASSES.add(FieldInfos.class);
        EXCLUDED_CLASSES.add(SegmentInfo.class);
        EXCLUDED_CLASSES.add(SegmentCommitInfo.class);
        EXCLUDED_CLASSES.add(FieldInfo.class);
        EXCLUDED_CLASSES.add(DoubleBarrelLRUCache.class);
        EXCLUDED_CLASSES.add(String.class);
    }

    static class Accumulator
    extends RamUsageTester.Accumulator {
        private final Object root;

        Accumulator(Object root) {
            this.root = root;
        }

        @Override
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!EXCLUDED_CLASSES.contains(clazz) || o == this.root) continue;
                return 0L;
            }
            if (o instanceof Collection) {
                Collection coll = (Collection)o;
                queue.addAll((Collection)o);
                return (long)coll.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                queue.addAll(map.keySet());
                queue.addAll(map.values());
                return 2L * (long)map.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
            long v = super.accumulateObject(o, shallowSize, fieldValues, queue);
            return v;
        }

        @Override
        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            long v = super.accumulateArray(array, shallowSize, values, queue);
            return v;
        }
    }
}

