/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

abstract class BaseIndexFileFormatTestCase
extends LuceneTestCase {
    private Codec savedCodec;

    BaseIndexFileFormatTestCase() {
    }

    protected abstract Codec getCodec();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    protected abstract void addRandomFields(Document var1);

    private Map<String, Long> bytesUsedByExtension(Directory d) throws IOException {
        HashMap<String, Long> bytesUsedByExtension = new HashMap<String, Long>();
        for (String file : d.listAll()) {
            String ext = IndexFileNames.getExtension((String)file);
            long previousLength = bytesUsedByExtension.containsKey(ext) ? (Long)bytesUsedByExtension.get(ext) : 0L;
            bytesUsedByExtension.put(ext, previousLength + d.fileLength(file));
        }
        bytesUsedByExtension.keySet().removeAll(this.excludedExtensionsFromByteCounts());
        return bytesUsedByExtension;
    }

    protected Collection<String> excludedExtensionsFromByteCounts() {
        return new HashSet<String>(Arrays.asList("si", "lock"));
    }

    public void testMergeStability() throws Exception {
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newDirectory();
        TieredMergePolicy mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        IndexWriterConfig cfg = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        RandomIndexWriter w = new RandomIndexWriter(BaseIndexFileFormatTestCase.random(), (Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument(d);
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDirectoryWrapper dir2 = BaseIndexFileFormatTestCase.newDirectory();
        mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        cfg = new IndexWriterConfig(TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        w = new RandomIndexWriter(BaseIndexFileFormatTestCase.random(), (Directory)dir2, cfg);
        w.addIndexes(new IndexReader[]{reader});
        w.commit();
        w.close();
        BaseIndexFileFormatTestCase.assertEquals(this.bytesUsedByExtension((Directory)dir), this.bytesUsedByExtension((Directory)dir2));
        reader.close();
        dir.close();
        dir2.close();
    }
}

