/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class TestSecurityManager
extends SecurityManager {
    static final String TEST_RUNNER_PACKAGE = "com.carrotsearch.ant.tasks.junit4.";

    @Override
    public void checkExit(final int status) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String systemClassName = System.class.getName();
                String runtimeClassName = Runtime.class.getName();
                String exitMethodHit = null;
                for (StackTraceElement se : Thread.currentThread().getStackTrace()) {
                    String className = se.getClassName();
                    String methodName = se.getMethodName();
                    if (("exit".equals(methodName) || "halt".equals(methodName)) && (systemClassName.equals(className) || runtimeClassName.equals(className))) {
                        exitMethodHit = className + '#' + methodName + '(' + status + ')';
                        continue;
                    }
                    if (exitMethodHit == null) continue;
                    if (!className.startsWith(TestSecurityManager.TEST_RUNNER_PACKAGE)) break;
                    return null;
                }
                if (exitMethodHit == null) {
                    exitMethodHit = "JVM exit method";
                }
                throw new SecurityException(exitMethodHit + " calls are not allowed because they terminate the test runner's JVM.");
            }
        });
        super.checkExit(status);
    }
}

