/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;

public final class CannedBinaryTokenStream
extends TokenStream {
    private final BinaryToken[] tokens;
    private int upto = 0;
    private final BinaryTermAttribute termAtt = (BinaryTermAttribute)this.addAttribute(BinaryTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    public CannedBinaryTokenStream(BinaryToken ... tokens) {
        this.tokens = tokens;
    }

    public boolean incrementToken() {
        if (this.upto < this.tokens.length) {
            BinaryToken token = this.tokens[this.upto++];
            this.clearAttributes();
            this.termAtt.setBytesRef(token.term);
            this.posIncrAtt.setPositionIncrement(token.posInc);
            this.posLengthAtt.setPositionLength(token.posLen);
            this.offsetAtt.setOffset(token.startOffset, token.endOffset);
            return true;
        }
        return false;
    }

    public static final class BinaryTermAttributeImpl
    extends AttributeImpl
    implements BinaryTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRef bytes = new BytesRef();

        public int fillBytesRef() {
            return this.bytes.hashCode();
        }

        public BytesRef getBytesRef() {
            return this.bytes;
        }

        @Override
        public void setBytesRef(BytesRef bytes) {
            this.bytes.copyBytes(bytes);
        }

        public void clear() {
        }

        public boolean equals(Object other) {
            return other == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public void copyTo(AttributeImpl target) {
            BinaryTermAttributeImpl other = (BinaryTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        public BinaryTermAttributeImpl clone() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface BinaryTermAttribute
    extends TermToBytesRefAttribute {
        public void setBytesRef(BytesRef var1);
    }

    public static final class BinaryToken {
        BytesRef term;
        int posInc;
        int posLen;
        int startOffset;
        int endOffset;

        public BinaryToken(BytesRef term) {
            this.term = term;
            this.posInc = 1;
            this.posLen = 1;
        }

        public BinaryToken(BytesRef term, int posInc, int posLen) {
            this.term = term;
            this.posInc = posInc;
            this.posLen = posLen;
        }
    }
}

