/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AssertingWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class AssertingQuery
extends Query {
    private final Random random;
    private final Query in;

    public AssertingQuery(Random random, Query in) {
        this.random = random;
        this.in = in;
    }

    public static Query wrap(Random random, Query query) {
        return query instanceof AssertingQuery ? query : new AssertingQuery(random, query);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return AssertingWeight.wrap(new Random(this.random.nextLong()), this.in.createWeight(searcher));
    }

    public void extractTerms(Set<Term> terms) {
        this.in.extractTerms(terms);
    }

    public String toString(String field) {
        return this.in.toString(field);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AssertingQuery)) {
            return false;
        }
        AssertingQuery that = (AssertingQuery)((Object)obj);
        return this.in.equals((Object)that.in);
    }

    public int hashCode() {
        return -this.in.hashCode();
    }

    public Query clone() {
        return AssertingQuery.wrap(new Random(this.random.nextLong()), this.in.clone());
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return AssertingQuery.wrap(new Random(this.random.nextLong()), rewritten);
    }

    public float getBoost() {
        return this.in.getBoost();
    }

    public void setBoost(float b) {
        this.in.setBoost(b);
    }
}

