/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.util.Iterator;
import org.apache.lucene.util.BytesRef;

public class MissingOrdRemapper {
    public static Iterable<BytesRef> insertEmptyValue(final Iterable<BytesRef> iterable) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    boolean seenEmpty = false;
                    Iterator<BytesRef> in;
                    {
                        this.in = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.seenEmpty || this.in.hasNext();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.seenEmpty) {
                            this.seenEmpty = true;
                            return new BytesRef();
                        }
                        return this.in.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Number> mapMissingToOrd0(final Iterable<Number> iterable) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    Iterator<Number> in;
                    {
                        this.in = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.in.hasNext();
                    }

                    @Override
                    public Number next() {
                        Number n = this.in.next();
                        if (n.longValue() == -1L) {
                            return 0;
                        }
                        return n;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Number> mapAllOrds(final Iterable<Number> iterable) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    Iterator<Number> in;
                    {
                        this.in = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.in.hasNext();
                    }

                    @Override
                    public Number next() {
                        Number n = this.in.next();
                        return n.longValue() + 1L;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

