/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;

public class MockIndexOutputWrapper
extends IndexOutput {
    private MockDirectoryWrapper dir;
    private final IndexOutput delegate;
    private boolean first = true;
    final String name;
    byte[] singleByte = new byte[1];

    public MockIndexOutputWrapper(MockDirectoryWrapper dir, IndexOutput delegate, String name) {
        this.dir = dir;
        this.name = name;
        this.delegate = delegate;
    }

    private void checkCrashed() throws IOException {
        if (this.dir.crashed) {
            throw new IOException("MockRAMDirectory was crashed; cannot write to " + this.name);
        }
    }

    private void checkDiskFull(byte[] b, int offset, DataInput in, long len) throws IOException {
        long freeSpace = this.dir.maxSize == 0L ? 0L : this.dir.maxSize - this.dir.sizeInBytes();
        long realUsage = 0L;
        if (this.dir.maxSize != 0L && freeSpace <= len) {
            realUsage = this.dir.getRecomputedActualSizeInBytes();
            freeSpace = this.dir.maxSize - realUsage;
        }
        if (this.dir.maxSize != 0L && freeSpace <= len) {
            if (freeSpace > 0L) {
                realUsage += freeSpace;
                if (b != null) {
                    this.delegate.writeBytes(b, offset, (int)freeSpace);
                } else {
                    this.delegate.copyBytes(in, len);
                }
            }
            if (realUsage > this.dir.maxUsedSize) {
                this.dir.maxUsedSize = realUsage;
            }
            String message = "fake disk full at " + this.dir.getRecomputedActualSizeInBytes() + " bytes when writing " + this.name + " (file length=" + this.delegate.length();
            if (freeSpace > 0L) {
                message = message + "; wrote " + freeSpace + " of " + len + " bytes";
            }
            message = message + ")";
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MDW: now throw fake disk full");
                new Throwable().printStackTrace(System.out);
            }
            throw new IOException(message);
        }
    }

    public void close() throws IOException {
        try {
            this.dir.maybeThrowDeterministicException();
        }
        finally {
            long size;
            this.delegate.close();
            if (this.dir.trackDiskUsage && (size = this.dir.getRecomputedActualSizeInBytes()) > this.dir.maxUsedSize) {
                this.dir.maxUsedSize = size;
            }
            this.dir.removeIndexOutput(this, this.name);
        }
    }

    public void flush() throws IOException {
        this.dir.maybeThrowDeterministicException();
        this.delegate.flush();
    }

    public void writeByte(byte b) throws IOException {
        this.singleByte[0] = b;
        this.writeBytes(this.singleByte, 0, 1);
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        this.checkCrashed();
        this.checkDiskFull(b, offset, null, len);
        if (this.dir.randomState.nextInt(200) == 0) {
            int half = len / 2;
            this.delegate.writeBytes(b, offset, half);
            Thread.yield();
            this.delegate.writeBytes(b, offset + half, len - half);
        } else {
            this.delegate.writeBytes(b, offset, len);
        }
        this.dir.maybeThrowDeterministicException();
        if (this.first) {
            this.first = false;
            this.dir.maybeThrowIOException(this.name);
        }
    }

    public long getFilePointer() {
        return this.delegate.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.delegate.seek(pos);
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public void setLength(long length) throws IOException {
        this.delegate.setLength(length);
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.checkCrashed();
        this.checkDiskFull(null, 0, input, numBytes);
        this.delegate.copyBytes(input, numBytes);
        this.dir.maybeThrowDeterministicException();
    }

    public String toString() {
        return "MockIndexOutputWrapper(" + this.delegate + ")";
    }
}

