/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene41ords;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsReader;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;

public final class Lucene41WithOrds
extends PostingsFormat {
    public static final int TERMS_CACHE_SIZE = 1024;
    static final String FREQ_EXTENSION = "frq";
    static final String PROX_EXTENSION = "prx";

    public Lucene41WithOrds() {
        super("Lucene41WithOrds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        Lucene41PostingsWriter docs = new Lucene41PostingsWriter(state);
        boolean success = false;
        try {
            indexWriter = new FixedGapTermsIndexWriter(state);
            success = true;
        }
        finally {
            if (!success) {
                docs.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)docs);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    docs.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        Lucene41PostingsReader postings = new Lucene41PostingsReader(state.directory, state.fieldInfos, state.segmentInfo, state.context, state.segmentSuffix);
        boolean success = false;
        try {
            indexReader = new FixedGapTermsIndexReader(state.directory, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, BytesRef.getUTF8SortedAsUnicodeComparator(), state.segmentSuffix, state.context);
            success = true;
        }
        finally {
            if (!success) {
                postings.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, state.directory, state.fieldInfos, state.segmentInfo, (PostingsReaderBase)postings, state.context, 1024, state.segmentSuffix);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postings.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }
}

