/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.lucene3x.PreFlexRWSkipListWriter;
import org.apache.lucene.codecs.lucene3x.TermInfo;
import org.apache.lucene.codecs.lucene3x.TermInfosWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class PreFlexRWFieldsWriter
extends FieldsConsumer {
    private final TermInfosWriter termsOut;
    private final IndexOutput freqOut;
    private final IndexOutput proxOut;
    private final PreFlexRWSkipListWriter skipListWriter;
    private final int totalNumDocs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreFlexRWFieldsWriter(SegmentWriteState state) throws IOException {
        block9: {
            boolean success;
            block8: {
                this.termsOut = new TermInfosWriter(state.directory, state.segmentInfo.name, state.fieldInfos, state.termIndexInterval);
                success = false;
                try {
                    String freqFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)"", (String)"frq");
                    this.freqOut = state.directory.createOutput(freqFile, state.context);
                    this.totalNumDocs = state.segmentInfo.getDocCount();
                    success = true;
                    if (success) break block8;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut});
            }
            success = false;
            try {
                if (state.fieldInfos.hasProx()) {
                    String proxFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)"", (String)"prx");
                    this.proxOut = state.directory.createOutput(proxFile, state.context);
                } else {
                    this.proxOut = null;
                }
                success = true;
                if (success) break block9;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut, this.freqOut});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut, this.freqOut});
        }
        this.skipListWriter = new PreFlexRWSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, this.freqOut, this.proxOut);
    }

    public TermsConsumer addField(FieldInfo field) throws IOException {
        assert (field.number != -1);
        if (field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
            throw new UnsupportedOperationException("this codec cannot index offsets");
        }
        return new PreFlexTermsWriter(field);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.termsOut, this.freqOut, this.proxOut});
    }

    private class PreFlexTermsWriter
    extends TermsConsumer {
        private final FieldInfo fieldInfo;
        private final boolean omitTF;
        private final boolean storePayloads;
        private final TermInfo termInfo = new TermInfo();
        private final PostingsWriter postingsWriter = new PostingsWriter();

        public PreFlexTermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.omitTF = fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY;
            this.storePayloads = fieldInfo.hasPayloads();
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            PreFlexRWFieldsWriter.this.skipListWriter.resetSkip();
            this.termInfo.freqPointer = PreFlexRWFieldsWriter.this.freqOut.getFilePointer();
            if (PreFlexRWFieldsWriter.this.proxOut != null) {
                this.termInfo.proxPointer = PreFlexRWFieldsWriter.this.proxOut.getFilePointer();
            }
            return this.postingsWriter.reset();
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (stats.docFreq > 0) {
                long skipPointer = PreFlexRWFieldsWriter.this.skipListWriter.writeSkip(PreFlexRWFieldsWriter.this.freqOut);
                this.termInfo.docFreq = stats.docFreq;
                this.termInfo.skipOffset = (int)(skipPointer - this.termInfo.freqPointer);
                PreFlexRWFieldsWriter.this.termsOut.add(this.fieldInfo.number, text, this.termInfo);
            }
        }

        public void finish(long sumTotalTermCount, long sumDocFreq, int docCount) throws IOException {
        }

        public Comparator<BytesRef> getComparator() throws IOException {
            return BytesRef.getUTF8SortedAsUTF16Comparator();
        }

        private class PostingsWriter
        extends PostingsConsumer {
            private int lastDocID;
            private int lastPayloadLength = -1;
            private int lastPosition;
            private int df;

            private PostingsWriter() {
            }

            public PostingsWriter reset() {
                this.df = 0;
                this.lastDocID = 0;
                this.lastPayloadLength = -1;
                return this;
            }

            public void startDoc(int docID, int termDocFreq) throws IOException {
                int delta = docID - this.lastDocID;
                if (docID < 0 || this.df > 0 && delta <= 0) {
                    throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )");
                }
                if (++this.df % ((PreFlexRWFieldsWriter)PreFlexRWFieldsWriter.this).termsOut.skipInterval == 0) {
                    PreFlexRWFieldsWriter.this.skipListWriter.setSkipData(this.lastDocID, PreFlexTermsWriter.this.storePayloads, this.lastPayloadLength);
                    PreFlexRWFieldsWriter.this.skipListWriter.bufferSkip(this.df);
                }
                this.lastDocID = docID;
                assert (docID < PreFlexRWFieldsWriter.this.totalNumDocs) : "docID=" + docID + " totalNumDocs=" + PreFlexRWFieldsWriter.access$400(PreFlexRWFieldsWriter.this);
                if (PreFlexTermsWriter.this.omitTF) {
                    PreFlexRWFieldsWriter.this.freqOut.writeVInt(delta);
                } else {
                    int code = delta << 1;
                    if (termDocFreq == 1) {
                        PreFlexRWFieldsWriter.this.freqOut.writeVInt(code | 1);
                    } else {
                        PreFlexRWFieldsWriter.this.freqOut.writeVInt(code);
                        PreFlexRWFieldsWriter.this.freqOut.writeVInt(termDocFreq);
                    }
                }
                this.lastPosition = 0;
            }

            public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
                assert (PreFlexRWFieldsWriter.this.proxOut != null);
                assert (startOffset == -1);
                assert (endOffset == -1);
                int delta = position - this.lastPosition;
                this.lastPosition = position;
                if (PreFlexTermsWriter.this.storePayloads) {
                    int payloadLength;
                    int n = payloadLength = payload == null ? 0 : payload.length;
                    if (payloadLength != this.lastPayloadLength) {
                        this.lastPayloadLength = payloadLength;
                        PreFlexRWFieldsWriter.this.proxOut.writeVInt(delta << 1 | 1);
                        PreFlexRWFieldsWriter.this.proxOut.writeVInt(payloadLength);
                    } else {
                        PreFlexRWFieldsWriter.this.proxOut.writeVInt(delta << 1);
                    }
                    if (payloadLength > 0) {
                        PreFlexRWFieldsWriter.this.proxOut.writeBytes(payload.bytes, payload.offset, payload.length);
                    }
                } else {
                    PreFlexRWFieldsWriter.this.proxOut.writeVInt(delta);
                }
            }

            public void finishDoc() throws IOException {
            }
        }
    }
}

