/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

class AssertingWeight
extends Weight {
    final Random random;
    final Weight in;

    static Weight wrap(Random random, Weight other) {
        return other instanceof AssertingWeight ? other : new AssertingWeight(random, other);
    }

    AssertingWeight(Random random, Weight in) {
        this.random = random;
        this.in = in;
    }

    public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
        return this.in.explain(context, doc);
    }

    public Query getQuery() {
        return this.in.getQuery();
    }

    public float getValueForNormalization() throws IOException {
        return this.in.getValueForNormalization();
    }

    public void normalize(float norm, float topLevelBoost) {
        this.in.normalize(norm, topLevelBoost);
    }

    public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
        boolean inOrder = scoreDocsInOrder || !this.scoresDocsOutOfOrder();
        Scorer inScorer = this.in.scorer(context, scoreDocsInOrder, topScorer, acceptDocs);
        return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer, topScorer, inOrder);
    }

    public boolean scoresDocsOutOfOrder() {
        return this.in.scoresDocsOutOfOrder();
    }
}

