/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class AssertingCollector
extends Collector {
    final Random random;
    final Collector in;
    final boolean inOrder;
    int lastCollected;

    public static Collector wrap(Random random, Collector other, boolean inOrder) {
        return other instanceof AssertingCollector ? other : new AssertingCollector(random, other, inOrder);
    }

    AssertingCollector(Random random, Collector in, boolean inOrder) {
        this.random = random;
        this.in = in;
        this.inOrder = inOrder;
        this.lastCollected = -1;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.in.setScorer(AssertingScorer.getAssertingScorer(this.random, scorer));
    }

    public void collect(int doc) throws IOException {
        if (this.inOrder || !this.acceptsDocsOutOfOrder()) assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
        this.in.collect(doc);
        this.lastCollected = doc;
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.lastCollected = -1;
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.in.acceptsDocsOutOfOrder();
    }
}

