/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FieldInfosReader;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

class CrankyFieldInfosFormat
extends FieldInfosFormat {
    final FieldInfosFormat delegate;
    final Random random;

    CrankyFieldInfosFormat(FieldInfosFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public FieldInfosReader getFieldInfosReader() throws IOException {
        return this.delegate.getFieldInfosReader();
    }

    public FieldInfosWriter getFieldInfosWriter() throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from FieldInfosFormat.getFieldInfosWriter()");
        }
        return new CrankyFieldInfosWriter(this.delegate.getFieldInfosWriter(), this.random);
    }

    static class CrankyFieldInfosWriter
    extends FieldInfosWriter {
        final FieldInfosWriter delegate;
        final Random random;

        CrankyFieldInfosWriter(FieldInfosWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void write(Directory directory, String segmentName, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldInfosWriter.write()");
            }
            this.delegate.write(directory, segmentName, segmentSuffix, infos, context);
        }
    }
}

