/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedBytesDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class LineFileDocs
implements Closeable {
    private BufferedReader reader;
    private static final int BUFFER_SIZE = 65536;
    private final AtomicInteger id = new AtomicInteger();
    private final String path;
    private final boolean useDocValues;
    private static final char SEP = '\t';
    private final ThreadLocal<DocState> threadDocs = new ThreadLocal();

    public LineFileDocs(Random random, String path, boolean useDocValues) throws IOException {
        this.path = path;
        this.useDocValues = useDocValues;
        this.open(random);
    }

    public LineFileDocs(Random random) throws IOException {
        this(random, LuceneTestCase.TEST_LINE_DOCS_FILE, true);
    }

    public LineFileDocs(Random random, boolean useDocValues) throws IOException {
        this(random, LuceneTestCase.TEST_LINE_DOCS_FILE, useDocValues);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private long randomSeekPos(Random random, long size) {
        if (random == null || size <= 3L) {
            return 0L;
        }
        return (random.nextLong() & Long.MAX_VALUE) % (size / 3L);
    }

    private synchronized void open(Random random) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.path);
        boolean needSkip = true;
        long size = 0L;
        long seekTo = 0L;
        if (is == null) {
            File file = new File(this.path);
            size = file.length();
            if (this.path.endsWith(".gz")) {
                is = new FileInputStream(file);
            } else {
                seekTo = this.randomSeekPos(random, size);
                FileChannel channel = new RandomAccessFile(this.path, "r").getChannel();
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: file seek to fp=" + seekTo + " on open");
                }
                channel.position(seekTo);
                is = Channels.newInputStream(channel);
                needSkip = false;
            }
        } else {
            size = is.available();
        }
        if (this.path.endsWith(".gz")) {
            is = new GZIPInputStream(is);
            size = (long)((double)size * 2.8);
        }
        if (needSkip) {
            seekTo = this.randomSeekPos(random, size);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: LineFileDocs: stream skip to fp=" + seekTo + " on open");
            }
            is.skip(seekTo);
        }
        if (seekTo > 0L) {
            int b;
            while ((b = is.read()) >= 0 && b != 13 && b != 10) {
            }
        }
        CharsetDecoder decoder = IOUtils.CHARSET_UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        this.reader = new BufferedReader(new InputStreamReader(is, decoder), 65536);
        if (seekTo > 0L) {
            this.reader.readLine();
        }
    }

    public synchronized void reset(Random random) throws IOException {
        this.close();
        this.open(random);
        this.id.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document nextDoc() throws IOException {
        int spot;
        String line;
        LineFileDocs lineFileDocs = this;
        synchronized (lineFileDocs) {
            line = this.reader.readLine();
            if (line == null) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: now rewind file...");
                }
                this.close();
                this.open(null);
                line = this.reader.readLine();
            }
        }
        DocState docState = this.threadDocs.get();
        if (docState == null) {
            docState = new DocState(this.useDocValues);
            this.threadDocs.set(docState);
        }
        if ((spot = line.indexOf(9)) == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        int spot2 = line.indexOf(9, 1 + spot);
        if (spot2 == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        docState.body.setStringValue(line.substring(1 + spot2, line.length()));
        String title = line.substring(0, spot);
        docState.title.setStringValue(title);
        if (docState.titleDV != null) {
            docState.titleDV.setBytesValue(new BytesRef((CharSequence)title));
        }
        docState.titleTokenized.setStringValue(title);
        docState.date.setStringValue(line.substring(1 + spot, spot2));
        docState.id.setStringValue(Integer.toString(this.id.getAndIncrement()));
        return docState.doc;
    }

    private static final class DocState {
        final Document doc = new Document();
        final Field titleTokenized;
        final Field title = new StringField("title", "", Field.Store.NO);
        final Field titleDV;
        final Field body;
        final Field id;
        final Field date;

        public DocState(boolean useDocValues) {
            this.doc.add((IndexableField)this.title);
            FieldType ft = new FieldType(TextField.TYPE_STORED);
            ft.setStoreTermVectors(true);
            ft.setStoreTermVectorOffsets(true);
            ft.setStoreTermVectorPositions(true);
            this.titleTokenized = new Field("titleTokenized", "", ft);
            this.doc.add((IndexableField)this.titleTokenized);
            this.body = new Field("body", "", ft);
            this.doc.add((IndexableField)this.body);
            this.id = new StringField("docid", "", Field.Store.YES);
            this.doc.add((IndexableField)this.id);
            this.date = new StringField("date", "", Field.Store.YES);
            this.doc.add((IndexableField)this.date);
            if (useDocValues) {
                this.titleDV = new SortedBytesDocValuesField("titleDV", new BytesRef());
                this.doc.add((IndexableField)this.titleDV);
            } else {
                this.titleDV = null;
            }
        }
    }
}

