/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class AssertingAtomicReader
extends FilterAtomicReader {
    private final Object cacheKey = new Object();

    public AssertingAtomicReader(AtomicReader in) {
        super(in);
        assert (in.maxDoc() >= 0);
        assert (in.numDocs() <= in.maxDoc());
        assert (in.numDeletedDocs() + in.numDocs() == in.maxDoc());
        assert (!in.hasDeletions() || in.numDeletedDocs() > 0 && in.numDocs() < in.maxDoc());
    }

    public Fields fields() throws IOException {
        Fields fields = super.fields();
        return fields == null ? null : new AssertingFields(fields);
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        return fields == null ? null : new AssertingFields(fields);
    }

    public Object getCoreCacheKey() {
        return this.cacheKey;
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.cacheKey;
    }

    static class AssertingDocsAndPositionsEnum
    extends FilterAtomicReader.FilterDocsAndPositionsEnum {
        private DocsEnumState state = DocsEnumState.START;
        private int positionMax = 0;
        private int positionCount = 0;

        public AssertingDocsAndPositionsEnum(DocsAndPositionsEnum in) {
            super(in);
            int docid = in.docID();
            assert (docid == -1 || docid == Integer.MAX_VALUE) : "invalid initial doc id: " + docid;
        }

        public int nextDoc() throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc >= 0) : "invalid doc id: " + nextDoc;
            this.positionCount = 0;
            if (nextDoc == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            return nextDoc;
        }

        public int advance(int target) throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            int advanced = super.advance(target);
            assert (advanced >= 0) : "invalid doc id: " + advanced;
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            this.positionCount = 0;
            if (advanced == Integer.MAX_VALUE) {
                this.state = DocsEnumState.FINISHED;
                this.positionMax = 0;
            } else {
                this.state = DocsEnumState.ITERATING;
                this.positionMax = super.freq();
            }
            return advanced;
        }

        public int freq() throws IOException {
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }

        public int nextPosition() throws IOException {
            assert (this.state != DocsEnumState.START) : "nextPosition() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "nextPosition() called after NO_MORE_DOCS";
            assert (this.positionCount < this.positionMax) : "nextPosition() called more than freq() times!";
            int position = super.nextPosition();
            assert (position >= 0 || position == -1) : "invalid position: " + position;
            ++this.positionCount;
            return position;
        }

        public int startOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "startOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "startOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "startOffset() called before nextPosition()!";
            return super.startOffset();
        }

        public int endOffset() throws IOException {
            assert (this.state != DocsEnumState.START) : "endOffset() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "endOffset() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "endOffset() called before nextPosition()!";
            return super.endOffset();
        }

        public BytesRef getPayload() throws IOException {
            assert (this.state != DocsEnumState.START) : "getPayload() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "getPayload() called after NO_MORE_DOCS";
            assert (this.positionCount > 0) : "getPayload() called before nextPosition()!";
            BytesRef payload = super.getPayload();
            assert (payload == null || payload.length > 0) : "getPayload() returned payload with invalid length!";
            return payload;
        }
    }

    static class AssertingDocsEnum
    extends FilterAtomicReader.FilterDocsEnum {
        private DocsEnumState state = DocsEnumState.START;

        public AssertingDocsEnum(DocsEnum in) {
            super(in);
            int docid = in.docID();
            assert (docid == -1 || docid == Integer.MAX_VALUE) : "invalid initial doc id: " + docid;
        }

        public int nextDoc() throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "nextDoc() called after NO_MORE_DOCS";
            int nextDoc = super.nextDoc();
            assert (nextDoc >= 0) : "invalid doc id: " + nextDoc;
            this.state = nextDoc == Integer.MAX_VALUE ? DocsEnumState.FINISHED : DocsEnumState.ITERATING;
            return nextDoc;
        }

        public int advance(int target) throws IOException {
            assert (this.state != DocsEnumState.FINISHED) : "advance() called after NO_MORE_DOCS";
            int advanced = super.advance(target);
            assert (advanced >= 0) : "invalid doc id: " + advanced;
            assert (advanced >= target) : "backwards advance from: " + target + " to: " + advanced;
            this.state = advanced == Integer.MAX_VALUE ? DocsEnumState.FINISHED : DocsEnumState.ITERATING;
            return advanced;
        }

        public int freq() throws IOException {
            assert (this.state != DocsEnumState.START) : "freq() called before nextDoc()/advance()";
            assert (this.state != DocsEnumState.FINISHED) : "freq() called after NO_MORE_DOCS";
            int freq = super.freq();
            assert (freq > 0);
            return freq;
        }
    }

    static enum DocsEnumState {
        START,
        ITERATING,
        FINISHED;

    }

    static class AssertingTermsEnum
    extends FilterAtomicReader.FilterTermsEnum {
        private State state = State.INITIAL;

        public AssertingTermsEnum(TermsEnum in) {
            super(in);
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            DocsEnum docs;
            assert (this.state == State.POSITIONED) : "docs(...) called on unpositioned TermsEnum";
            if (reuse instanceof AssertingDocsEnum) {
                reuse = ((AssertingDocsEnum)reuse).in;
            }
            return (docs = super.docs(liveDocs, reuse, flags)) == null ? null : new AssertingDocsEnum(docs);
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            DocsAndPositionsEnum docs;
            assert (this.state == State.POSITIONED) : "docsAndPositions(...) called on unpositioned TermsEnum";
            if (reuse instanceof AssertingDocsAndPositionsEnum) {
                reuse = ((AssertingDocsAndPositionsEnum)reuse).in;
            }
            return (docs = super.docsAndPositions(liveDocs, reuse, flags)) == null ? null : new AssertingDocsAndPositionsEnum(docs);
        }

        public BytesRef next() throws IOException {
            assert (this.state == State.INITIAL || this.state == State.POSITIONED) : "next() called on unpositioned TermsEnum";
            BytesRef result = super.next();
            this.state = result == null ? State.UNPOSITIONED : State.POSITIONED;
            return result;
        }

        public long ord() throws IOException {
            assert (this.state == State.POSITIONED) : "ord() called on unpositioned TermsEnum";
            return super.ord();
        }

        public int docFreq() throws IOException {
            assert (this.state == State.POSITIONED) : "docFreq() called on unpositioned TermsEnum";
            return super.docFreq();
        }

        public long totalTermFreq() throws IOException {
            assert (this.state == State.POSITIONED) : "totalTermFreq() called on unpositioned TermsEnum";
            return super.totalTermFreq();
        }

        public BytesRef term() throws IOException {
            assert (this.state == State.POSITIONED) : "term() called on unpositioned TermsEnum";
            return super.term();
        }

        public void seekExact(long ord) throws IOException {
            super.seekExact(ord);
            this.state = State.POSITIONED;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef term, boolean useCache) throws IOException {
            TermsEnum.SeekStatus result = super.seekCeil(term, useCache);
            this.state = result == TermsEnum.SeekStatus.END ? State.UNPOSITIONED : State.POSITIONED;
            return result;
        }

        public boolean seekExact(BytesRef text, boolean useCache) throws IOException {
            if (super.seekExact(text, useCache)) {
                this.state = State.POSITIONED;
                return true;
            }
            this.state = State.UNPOSITIONED;
            return false;
        }

        public TermState termState() throws IOException {
            assert (this.state == State.POSITIONED) : "termState() called on unpositioned TermsEnum";
            return super.termState();
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            super.seekExact(term, state);
            this.state = State.POSITIONED;
        }

        private static enum State {
            INITIAL,
            POSITIONED,
            UNPOSITIONED;

        }
    }

    public static class AssertingTerms
    extends FilterAtomicReader.FilterTerms {
        public AssertingTerms(Terms in) {
            super(in);
        }

        public TermsEnum intersect(CompiledAutomaton automaton, BytesRef bytes) throws IOException {
            TermsEnum termsEnum = super.intersect(automaton, bytes);
            assert (termsEnum != null);
            return new AssertingTermsEnum(termsEnum);
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (reuse instanceof AssertingTermsEnum) {
                reuse = ((AssertingTermsEnum)reuse).in;
            }
            TermsEnum termsEnum = super.iterator(reuse);
            assert (termsEnum != null);
            return new AssertingTermsEnum(termsEnum);
        }
    }

    public static class AssertingFields
    extends FilterAtomicReader.FilterFields {
        public AssertingFields(Fields in) {
            super(in);
        }

        public Iterator<String> iterator() {
            Iterator iterator = super.iterator();
            assert (iterator != null);
            return iterator;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            return terms == null ? null : new AssertingTerms(terms);
        }
    }
}

