/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.ClassValidator;
import com.carrotsearch.randomizedtesting.MethodCollector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestRuleNoStaticHooksShadowing
implements TestRule,
ClassValidator {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestRuleNoStaticHooksShadowing.this.validate(description.getTestClass());
                base.evaluate();
            }
        };
    }

    public void validate(Class<?> clazz) throws Throwable {
        List all = MethodCollector.allDeclaredMethods(clazz);
        this.checkNoShadows(clazz, all, BeforeClass.class);
        this.checkNoShadows(clazz, all, AfterClass.class);
    }

    private void checkNoShadows(Class<?> clazz, List<List<Method>> all, Class<? extends Annotation> ann) {
        List methodHierarchy = MethodCollector.annotatedWith(all, ann);
        List noShadows = MethodCollector.removeShadowed((List)methodHierarchy);
        if (!((Object)noShadows).equals(methodHierarchy)) {
            HashSet shadowed = new HashSet(MethodCollector.flatten((List)methodHierarchy));
            shadowed.removeAll(MethodCollector.flatten((List)noShadows));
            StringBuilder b = new StringBuilder();
            for (Method m : shadowed) {
                String sig = this.signature(m);
                for (Method other : MethodCollector.flatten((List)methodHierarchy)) {
                    if (other == m || !sig.equals(this.signature(other))) continue;
                    b.append("Method: " + m.toString() + "#" + sig + " possibly shadowed by " + other.toString() + "#" + this.signature(other) + "\n");
                }
            }
            throw new RuntimeException("There are shadowed methods annotated with " + ann.getName() + ". These methods would not be executed by JUnit and need to manually chain themselves which can lead to" + " maintenance problems.\n" + b.toString().trim());
        }
    }

    private String signature(Method m) {
        return m.getName() + Arrays.toString(m.getParameterTypes());
    }
}

