/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.carrotsearch.randomizedtesting.JUnit4MethodProvider;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.MixWithSuiteName;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.SeedDecorators;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import com.carrotsearch.randomizedtesting.annotations.TestMethodProviders;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeaks;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.rules.SystemPropertiesInvariantRule;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AlcoholicMergePolicy;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.AssertingDirectoryReader;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldFilterAtomicReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MockRandomMergePolicy;
import org.apache.lucene.index.ParallelAtomicReader;
import org.apache.lucene.index.ParallelCompositeReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.AssertingIndexSearcher;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.CloseableDirectory;
import org.apache.lucene.util.CommandLineUtil;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.lucene.util.LuceneJUnit3MethodProvider;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.RunListenerPrintReproduceInfo;
import org.apache.lucene.util.TestRuleAssertionsRequired;
import org.apache.lucene.util.TestRuleFieldCacheSanity;
import org.apache.lucene.util.TestRuleIgnoreAfterMaxFailures;
import org.apache.lucene.util.TestRuleIgnoreTestSuites;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestRuleNoInstanceHooksOverrides;
import org.apache.lucene.util.TestRuleNoStaticHooksShadowing;
import org.apache.lucene.util.TestRuleReportUncaughtExceptions;
import org.apache.lucene.util.TestRuleSetupAndRestoreClassEnv;
import org.apache.lucene.util.TestRuleSetupAndRestoreInstanceEnv;
import org.apache.lucene.util.TestRuleSetupTeardownChained;
import org.apache.lucene.util.TestRuleStoreClassName;
import org.apache.lucene.util.TestRuleThreadAndTestName;
import org.apache.lucene.util.Version;
import org.apache.lucene.util._TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=RandomizedRunner.class)
@TestMethodProviders(value={LuceneJUnit3MethodProvider.class, JUnit4MethodProvider.class})
@Listeners(value={RunListenerPrintReproduceInfo.class})
@SeedDecorators(value={MixWithSuiteName.class})
@ThreadLeaks(failTestIfLeaking=false)
public abstract class LuceneTestCase
extends Assert {
    public static final String SYSPROP_NIGHTLY = "tests.nightly";
    public static final String SYSPROP_WEEKLY = "tests.weekly";
    public static final String SYSPROP_AWAITSFIX = "tests.awaitsfix";
    public static final String SYSPROP_SLOW = "tests.slow";
    private static final String SYSPROP_MAXFAILURES = "tests.maxfailures";
    private static final String SYSPROP_FAILFAST = "tests.failfast";
    public static final Version TEST_VERSION_CURRENT = Version.LUCENE_40;
    public static final boolean VERBOSE = RandomizedTest.systemPropertyAsBoolean((String)"tests.verbose", (boolean)false);
    public static final boolean INFOSTREAM = RandomizedTest.systemPropertyAsBoolean((String)"tests.infostream", (boolean)VERBOSE);
    public static final int RANDOM_MULTIPLIER = RandomizedTest.systemPropertyAsInt((String)"tests.multiplier", (int)1);
    public static final String DEFAULT_LINE_DOCS_FILE = "europarl.lines.txt.gz";
    public static final String JENKINS_LARGE_LINE_DOCS_FILE = "enwiki.random.lines.txt";
    public static final String TEST_CODEC = System.getProperty("tests.codec", "random");
    public static final String TEST_POSTINGSFORMAT = System.getProperty("tests.postingsformat", "random");
    public static final String TEST_DIRECTORY = System.getProperty("tests.directory", "random");
    public static final String TEST_LINE_DOCS_FILE = System.getProperty("tests.linedocsfile", "europarl.lines.txt.gz");
    public static final boolean TEST_NIGHTLY = RandomizedTest.systemPropertyAsBoolean((String)"tests.nightly", (boolean)false);
    public static final boolean TEST_WEEKLY = RandomizedTest.systemPropertyAsBoolean((String)"tests.weekly", (boolean)false);
    public static final boolean TEST_AWAITSFIX = RandomizedTest.systemPropertyAsBoolean((String)"tests.awaitsfix", (boolean)false);
    public static final boolean TEST_SLOW = RandomizedTest.systemPropertyAsBoolean((String)"tests.slow", (boolean)false);
    public static final MockDirectoryWrapper.Throttling TEST_THROTTLING = TEST_NIGHTLY ? MockDirectoryWrapper.Throttling.SOMETIMES : MockDirectoryWrapper.Throttling.NEVER;
    public static final File TEMP_DIR;
    private static final String[] IGNORED_INVARIANT_PROPERTIES;
    private static final List<String> FS_DIRECTORIES;
    private static final List<String> CORE_DIRECTORIES;
    protected static final Set<String> doesntSupportOffsets;
    public static boolean PREFLEX_IMPERSONATION_IS_ACTIVE;
    private static final TestRuleStoreClassName classNameRule;
    static final TestRuleSetupAndRestoreClassEnv classEnvRule;
    public static final TestRuleMarkFailure suiteFailureMarker;
    static final TestRuleIgnoreAfterMaxFailures ignoreAfterMaxFailures;
    @ClassRule
    public static TestRule classRules;
    private TestRuleSetupTeardownChained parentChainCallRule = new TestRuleSetupTeardownChained();
    private TestRuleThreadAndTestName threadAndTestNameRule = new TestRuleThreadAndTestName();
    private TestRuleMarkFailure testFailureMarker = new TestRuleMarkFailure(suiteFailureMarker);
    @Rule
    public final TestRule ruleChain = RuleChain.outerRule((TestRule)this.testFailureMarker).around((TestRule)ignoreAfterMaxFailures).around((TestRule)this.threadAndTestNameRule).around((TestRule)new TestRuleReportUncaughtExceptions()).around((TestRule)new SystemPropertiesInvariantRule(IGNORED_INVARIANT_PROPERTIES)).around((TestRule)new TestRuleSetupAndRestoreInstanceEnv()).around((TestRule)new TestRuleFieldCacheSanity()).around((TestRule)this.parentChainCallRule);

    @Before
    public void setUp() throws Exception {
        this.parentChainCallRule.setupCalled = true;
    }

    @After
    public void tearDown() throws Exception {
        this.parentChainCallRule.teardownCalled = true;
    }

    public static Random random() {
        return RandomizedContext.current().getRandom();
    }

    public <T extends Closeable> T closeAfterTest(T resource) {
        return (T)RandomizedContext.current().closeAtEnd(resource, LifecycleScope.TEST);
    }

    public static <T extends Closeable> T closeAfterSuite(T resource) {
        return (T)RandomizedContext.current().closeAtEnd(resource, LifecycleScope.SUITE);
    }

    public static Class<?> getTestClass() {
        return classNameRule.getTestClass();
    }

    public String getTestName() {
        return this.threadAndTestNameRule.testMethodName;
    }

    public static SegmentReader getOnlySegmentReader(DirectoryReader reader) {
        List subReaders = reader.getSequentialSubReaders();
        if (subReaders.size() != 1) {
            throw new IllegalArgumentException(reader + " has " + subReaders.size() + " segments instead of exactly one");
        }
        IndexReader r = (IndexReader)subReaders.get(0);
        LuceneTestCase.assertTrue((boolean)(r instanceof SegmentReader));
        return (SegmentReader)r;
    }

    protected boolean isTestThread() {
        LuceneTestCase.assertNotNull((String)"Test case thread not set?", (Object)this.threadAndTestNameRule.testCaseThread);
        return Thread.currentThread() == this.threadAndTestNameRule.testCaseThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertSaneFieldCaches(String msg) {
        Object[] entries = FieldCache.DEFAULT.getCacheEntries();
        Object[] insanity = null;
        try {
            try {
                insanity = FieldCacheSanityChecker.checkSanity((FieldCache.CacheEntry[])entries);
            }
            catch (RuntimeException e) {
                LuceneTestCase.dumpArray(msg + ": FieldCache", entries, System.err);
                throw e;
            }
            LuceneTestCase.assertEquals((String)(msg + ": Insane FieldCache usage(s) found"), (long)0L, (long)insanity.length);
            insanity = null;
        }
        finally {
            if (null != insanity) {
                LuceneTestCase.dumpArray(msg + ": Insane FieldCache usage(s)", insanity, System.err);
            }
        }
    }

    public static int atLeast(Random random, int i) {
        int min = (TEST_NIGHTLY ? 2 * i : i) * RANDOM_MULTIPLIER;
        int max = min + min / 2;
        return _TestUtil.nextInt(random, min, max);
    }

    public static int atLeast(int i) {
        return LuceneTestCase.atLeast(LuceneTestCase.random(), i);
    }

    public static boolean rarely(Random random) {
        int p = TEST_NIGHTLY ? 10 : 5;
        p = (int)((double)p + (double)p * Math.log(RANDOM_MULTIPLIER));
        int min = 100 - Math.min(p, 50);
        return random.nextInt(100) >= min;
    }

    public static boolean rarely() {
        return LuceneTestCase.rarely(LuceneTestCase.random());
    }

    public static boolean usually(Random random) {
        return !LuceneTestCase.rarely(random);
    }

    public static boolean usually() {
        return LuceneTestCase.usually(LuceneTestCase.random());
    }

    public static void assumeTrue(String msg, boolean condition) {
        RandomizedTest.assumeTrue((String)msg, (boolean)condition);
    }

    public static void assumeFalse(String msg, boolean condition) {
        RandomizedTest.assumeFalse((String)msg, (boolean)condition);
    }

    public static void assumeNoException(String msg, Exception e) {
        RandomizedTest.assumeNoException((String)msg, (Throwable)e);
    }

    public static <T> Set<T> asSet(T ... args) {
        return new HashSet<T>(Arrays.asList(args));
    }

    public static void dumpIterator(String label, Iterator<?> iter, PrintStream stream) {
        stream.println("*** BEGIN " + label + " ***");
        if (null == iter) {
            stream.println(" ... NULL ...");
        } else {
            while (iter.hasNext()) {
                stream.println(iter.next().toString());
            }
        }
        stream.println("*** END " + label + " ***");
    }

    public static void dumpArray(String label, Object[] objs, PrintStream stream) {
        Iterator<Object> iter = null == objs ? null : Arrays.asList(objs).iterator();
        LuceneTestCase.dumpIterator(label, iter, stream);
    }

    public static IndexWriterConfig newIndexWriterConfig(Version v, Analyzer a) {
        return LuceneTestCase.newIndexWriterConfig(LuceneTestCase.random(), v, a);
    }

    public static IndexWriterConfig newIndexWriterConfig(Random r, Version v, Analyzer a) {
        IndexWriterConfig c = new IndexWriterConfig(v, a);
        c.setSimilarity(LuceneTestCase.classEnvRule.similarity);
        if (r.nextBoolean()) {
            c.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        }
        if (r.nextBoolean()) {
            if (LuceneTestCase.rarely(r)) {
                c.setMaxBufferedDocs(_TestUtil.nextInt(r, 2, 15));
            } else {
                c.setMaxBufferedDocs(_TestUtil.nextInt(r, 16, 1000));
            }
        }
        if (r.nextBoolean()) {
            if (LuceneTestCase.rarely(r)) {
                c.setTermIndexInterval(r.nextBoolean() ? _TestUtil.nextInt(r, 1, 31) : _TestUtil.nextInt(r, 129, 1000));
            } else {
                c.setTermIndexInterval(_TestUtil.nextInt(r, 32, 128));
            }
        }
        if (r.nextBoolean()) {
            int maxNumThreadStates = LuceneTestCase.rarely(r) ? _TestUtil.nextInt(r, 5, 20) : _TestUtil.nextInt(r, 1, 4);
            Method setIndexerThreadPoolMethod = null;
            try {
                for (Method m : IndexWriterConfig.class.getDeclaredMethods()) {
                    if (!m.getName().equals("setIndexerThreadPool")) continue;
                    m.setAccessible(true);
                    setIndexerThreadPoolMethod = m;
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (setIndexerThreadPoolMethod == null) {
                throw new RuntimeException("failed to lookup IndexWriterConfig.setIndexerThreadPool method");
            }
            try {
                if (LuceneTestCase.rarely(r)) {
                    Class<?> clazz = Class.forName("org.apache.lucene.index.RandomDocumentsWriterPerThreadPool");
                    Constructor<?> ctor = clazz.getConstructor(Integer.TYPE, Random.class);
                    ctor.setAccessible(true);
                    setIndexerThreadPoolMethod.invoke((Object)c, ctor.newInstance(maxNumThreadStates, r));
                } else {
                    c.setMaxThreadStates(maxNumThreadStates);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (LuceneTestCase.rarely(r)) {
            c.setMergePolicy((MergePolicy)new MockRandomMergePolicy(r));
        } else if (r.nextBoolean()) {
            c.setMergePolicy((MergePolicy)LuceneTestCase.newTieredMergePolicy());
        } else if (r.nextInt(5) == 0) {
            c.setMergePolicy((MergePolicy)LuceneTestCase.newAlcoholicMergePolicy());
        } else {
            c.setMergePolicy((MergePolicy)LuceneTestCase.newLogMergePolicy());
        }
        c.setReaderPooling(r.nextBoolean());
        c.setReaderTermsIndexDivisor(_TestUtil.nextInt(r, 1, 4));
        return c;
    }

    public static LogMergePolicy newLogMergePolicy() {
        return LuceneTestCase.newLogMergePolicy(LuceneTestCase.random());
    }

    public static TieredMergePolicy newTieredMergePolicy() {
        return LuceneTestCase.newTieredMergePolicy(LuceneTestCase.random());
    }

    public static AlcoholicMergePolicy newAlcoholicMergePolicy() {
        return LuceneTestCase.newAlcoholicMergePolicy(LuceneTestCase.random(), LuceneTestCase.classEnvRule.timeZone);
    }

    public static AlcoholicMergePolicy newAlcoholicMergePolicy(Random r, TimeZone tz) {
        return new AlcoholicMergePolicy(tz, new Random(r.nextLong()));
    }

    public static LogMergePolicy newLogMergePolicy(Random r) {
        LogDocMergePolicy logmp = r.nextBoolean() ? new LogDocMergePolicy() : new LogByteSizeMergePolicy();
        logmp.setUseCompoundFile(r.nextBoolean());
        logmp.setCalibrateSizeByDeletes(r.nextBoolean());
        if (LuceneTestCase.rarely(r)) {
            logmp.setMergeFactor(_TestUtil.nextInt(r, 2, 9));
        } else {
            logmp.setMergeFactor(_TestUtil.nextInt(r, 10, 50));
        }
        return logmp;
    }

    public static TieredMergePolicy newTieredMergePolicy(Random r) {
        TieredMergePolicy tmp = new TieredMergePolicy();
        if (LuceneTestCase.rarely(r)) {
            tmp.setMaxMergeAtOnce(_TestUtil.nextInt(r, 2, 9));
            tmp.setMaxMergeAtOnceExplicit(_TestUtil.nextInt(r, 2, 9));
        } else {
            tmp.setMaxMergeAtOnce(_TestUtil.nextInt(r, 10, 50));
            tmp.setMaxMergeAtOnceExplicit(_TestUtil.nextInt(r, 10, 50));
        }
        if (LuceneTestCase.rarely(r)) {
            tmp.setMaxMergedSegmentMB(0.2 + r.nextDouble() * 2.0);
        } else {
            tmp.setMaxMergedSegmentMB(r.nextDouble() * 100.0);
        }
        tmp.setFloorSegmentMB(0.2 + r.nextDouble() * 2.0);
        tmp.setForceMergeDeletesPctAllowed(0.0 + r.nextDouble() * 30.0);
        if (LuceneTestCase.rarely(r)) {
            tmp.setSegmentsPerTier((double)_TestUtil.nextInt(r, 2, 20));
        } else {
            tmp.setSegmentsPerTier((double)_TestUtil.nextInt(r, 10, 50));
        }
        tmp.setUseCompoundFile(r.nextBoolean());
        tmp.setNoCFSRatio(0.1 + r.nextDouble() * 0.8);
        tmp.setReclaimDeletesWeight(r.nextDouble() * 4.0);
        return tmp;
    }

    public static LogMergePolicy newLogMergePolicy(boolean useCFS) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setUseCompoundFile(useCFS);
        return logmp;
    }

    public static LogMergePolicy newLogMergePolicy(boolean useCFS, int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setUseCompoundFile(useCFS);
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    public static LogMergePolicy newLogMergePolicy(int mergeFactor) {
        LogMergePolicy logmp = LuceneTestCase.newLogMergePolicy();
        logmp.setMergeFactor(mergeFactor);
        return logmp;
    }

    public static BaseDirectoryWrapper newDirectory() {
        return LuceneTestCase.newDirectory(LuceneTestCase.random());
    }

    public static BaseDirectoryWrapper newDirectory(Random r) {
        return LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY), LuceneTestCase.rarely(r));
    }

    public static MockDirectoryWrapper newMockDirectory() {
        return LuceneTestCase.newMockDirectory(LuceneTestCase.random());
    }

    public static MockDirectoryWrapper newMockDirectory(Random r) {
        return (MockDirectoryWrapper)LuceneTestCase.wrapDirectory(r, LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY), false);
    }

    public static MockDirectoryWrapper newMockFSDirectory(File f) {
        return (MockDirectoryWrapper)LuceneTestCase.newFSDirectory(f, null, false);
    }

    public static BaseDirectoryWrapper newDirectory(Directory d) throws IOException {
        return LuceneTestCase.newDirectory(LuceneTestCase.random(), d);
    }

    public static BaseDirectoryWrapper newFSDirectory(File f) {
        return LuceneTestCase.newFSDirectory(f, null);
    }

    public static BaseDirectoryWrapper newFSDirectory(File f, LockFactory lf) {
        return LuceneTestCase.newFSDirectory(f, lf, LuceneTestCase.rarely());
    }

    private static BaseDirectoryWrapper newFSDirectory(File f, LockFactory lf, boolean bare) {
        String fsdirClass = TEST_DIRECTORY;
        if (fsdirClass.equals("random")) {
            fsdirClass = (String)RandomPicks.randomFrom((Random)LuceneTestCase.random(), FS_DIRECTORIES);
        }
        try {
            Class clazz;
            try {
                clazz = CommandLineUtil.loadFSDirectoryClass((String)fsdirClass);
            }
            catch (ClassCastException e) {
                fsdirClass = (String)RandomPicks.randomFrom((Random)LuceneTestCase.random(), FS_DIRECTORIES);
                clazz = CommandLineUtil.loadFSDirectoryClass((String)fsdirClass);
            }
            Directory fsdir = LuceneTestCase.newFSDirectoryImpl(clazz, f);
            BaseDirectoryWrapper wrapped = LuceneTestCase.wrapDirectory(LuceneTestCase.random(), fsdir, bare);
            if (lf != null) {
                wrapped.setLockFactory(lf);
            }
            return wrapped;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseDirectoryWrapper newDirectory(Random r, Directory d) throws IOException {
        Directory impl = LuceneTestCase.newDirectoryImpl(r, TEST_DIRECTORY);
        for (String file : d.listAll()) {
            d.copy(impl, file, file, LuceneTestCase.newIOContext(r));
        }
        return LuceneTestCase.wrapDirectory(r, impl, LuceneTestCase.rarely(r));
    }

    private static BaseDirectoryWrapper wrapDirectory(Random random, Directory directory, boolean bare) {
        if (LuceneTestCase.rarely(random)) {
            directory = new NRTCachingDirectory(directory, random.nextDouble(), random.nextDouble());
        }
        if (bare) {
            BaseDirectoryWrapper base = new BaseDirectoryWrapper(directory);
            LuceneTestCase.closeAfterSuite(new CloseableDirectory(base, suiteFailureMarker));
            return base;
        }
        MockDirectoryWrapper mock = new MockDirectoryWrapper(random, directory);
        mock.setThrottling(TEST_THROTTLING);
        LuceneTestCase.closeAfterSuite(new CloseableDirectory(mock, suiteFailureMarker));
        return mock;
    }

    public static Field newStringField(String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static Field newTextField(String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, stored == Field.Store.YES ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED);
    }

    public static Field newStringField(Random random, String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(random, name, value, stored == Field.Store.YES ? StringField.TYPE_STORED : StringField.TYPE_NOT_STORED);
    }

    public static Field newTextField(Random random, String name, String value, Field.Store stored) {
        return LuceneTestCase.newField(random, name, value, stored == Field.Store.YES ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED);
    }

    public static Field newField(String name, String value, FieldType type) {
        return LuceneTestCase.newField(LuceneTestCase.random(), name, value, type);
    }

    public static Field newField(Random random, String name, String value, FieldType type) {
        name = new String(name);
        if (LuceneTestCase.usually(random) || !type.indexed()) {
            return new Field(name, value, type);
        }
        FieldType newType = new FieldType(type);
        if (!newType.stored() && random.nextBoolean()) {
            newType.setStored(true);
        }
        if (!newType.storeTermVectors() && random.nextBoolean()) {
            newType.setStoreTermVectors(true);
            if (!newType.storeTermVectorOffsets()) {
                newType.setStoreTermVectorOffsets(random.nextBoolean());
            }
            if (!newType.storeTermVectorPositions()) {
                newType.setStoreTermVectorPositions(random.nextBoolean());
            }
        }
        return new Field(name, value, newType);
    }

    public static Locale randomLocale(Random random) {
        Locale[] locales = Locale.getAvailableLocales();
        return locales[random.nextInt(locales.length)];
    }

    public static TimeZone randomTimeZone(Random random) {
        String[] tzIds = TimeZone.getAvailableIDs();
        return TimeZone.getTimeZone(tzIds[random.nextInt(tzIds.length)]);
    }

    public static Locale localeForName(String localeName) {
        String[] elements = localeName.split("\\_");
        switch (elements.length) {
            case 3: 
            case 4: {
                return new Locale(elements[0], elements[1], elements[2]);
            }
            case 2: {
                return new Locale(elements[0], elements[1]);
            }
            case 1: {
                return new Locale(elements[0]);
            }
        }
        throw new IllegalArgumentException("Invalid Locale: " + localeName);
    }

    public static boolean defaultCodecSupportsDocValues() {
        return !Codec.getDefault().getName().equals("Lucene3x");
    }

    private static Directory newFSDirectoryImpl(Class<? extends FSDirectory> clazz, File file) throws IOException {
        FSDirectory d = null;
        try {
            d = CommandLineUtil.newFSDirectory(clazz, (File)file);
        }
        catch (Exception e) {
            d = FSDirectory.open((File)file);
        }
        return d;
    }

    static Directory newDirectoryImpl(Random random, String clazzName) {
        if (clazzName.equals("random")) {
            clazzName = LuceneTestCase.rarely(random) ? (String)RandomPicks.randomFrom((Random)random, CORE_DIRECTORIES) : "RAMDirectory";
        }
        try {
            Class clazz = CommandLineUtil.loadDirectoryClass((String)clazzName);
            if (FSDirectory.class.isAssignableFrom(clazz)) {
                File dir = _TestUtil.getTempDir("index");
                dir.mkdirs();
                return LuceneTestCase.newFSDirectoryImpl(clazz.asSubclass(FSDirectory.class), dir);
            }
            return (Directory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexReader maybeWrapReader(IndexReader r) throws IOException {
        Random random = LuceneTestCase.random();
        if (LuceneTestCase.rarely()) {
            boolean wasOriginallyAtomic = r instanceof AtomicReader;
            int c = random.nextInt(6) + 1;
            block7: for (int i = 0; i < c; ++i) {
                switch (random.nextInt(5)) {
                    case 0: {
                        r = SlowCompositeReaderWrapper.wrap((IndexReader)r);
                        continue block7;
                    }
                    case 1: {
                        r = r instanceof AtomicReader ? new ParallelAtomicReader(new AtomicReader[]{(AtomicReader)r}) : new ParallelCompositeReader(new CompositeReader[]{(CompositeReader)r});
                        continue block7;
                    }
                    case 2: {
                        r = new QueryUtils.FCInvisibleMultiReader(new IndexReader[]{r});
                        continue block7;
                    }
                    case 3: {
                        AtomicReader ar = SlowCompositeReaderWrapper.wrap((IndexReader)r);
                        ArrayList<String> allFields = new ArrayList<String>();
                        for (FieldInfo fi : ar.getFieldInfos()) {
                            allFields.add(fi.name);
                        }
                        Collections.shuffle(allFields, random);
                        int end = allFields.isEmpty() ? 0 : random.nextInt(allFields.size());
                        HashSet<String> fields = new HashSet<String>(allFields.subList(0, end));
                        r = new ParallelAtomicReader(new AtomicReader[]{new FieldFilterAtomicReader(ar, fields, false), new FieldFilterAtomicReader(ar, fields, true)});
                        continue block7;
                    }
                    case 4: {
                        if (r instanceof AtomicReader) {
                            r = new AssertingAtomicReader((AtomicReader)r);
                            continue block7;
                        }
                        if (!(r instanceof DirectoryReader)) continue block7;
                        r = new AssertingDirectoryReader((DirectoryReader)r);
                        continue block7;
                    }
                    default: {
                        LuceneTestCase.fail((String)"should not get here");
                    }
                }
            }
            if (wasOriginallyAtomic) {
                r = SlowCompositeReaderWrapper.wrap((IndexReader)r);
            } else if (r instanceof CompositeReader && !(r instanceof QueryUtils.FCInvisibleMultiReader)) {
                r = new QueryUtils.FCInvisibleMultiReader(new IndexReader[]{r});
            }
            if (VERBOSE) {
                System.out.println("maybeWrapReader wrapped: " + r);
            }
        }
        return r;
    }

    public static IOContext newIOContext(Random random) {
        IOContext context;
        int randomNumDocs = random.nextInt(4192);
        int size = random.nextInt(512) * randomNumDocs;
        switch (random.nextInt(5)) {
            case 0: {
                context = IOContext.DEFAULT;
                break;
            }
            case 1: {
                context = IOContext.READ;
                break;
            }
            case 2: {
                context = IOContext.READONCE;
                break;
            }
            case 3: {
                context = new IOContext(new MergeInfo(randomNumDocs, (long)size, true, -1));
                break;
            }
            case 4: {
                context = new IOContext(new FlushInfo(randomNumDocs, (long)size));
                break;
            }
            default: {
                context = IOContext.DEFAULT;
            }
        }
        return context;
    }

    public static IndexSearcher newSearcher(IndexReader r) throws IOException {
        return LuceneTestCase.newSearcher(r, true);
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap) throws IOException {
        ThreadPoolExecutor ex;
        Random random = LuceneTestCase.random();
        if (LuceneTestCase.usually()) {
            if (maybeWrap) {
                r = LuceneTestCase.maybeWrapReader(r);
            }
            AssertingIndexSearcher ret = random.nextBoolean() ? new AssertingIndexSearcher(random, r) : new AssertingIndexSearcher(random, r.getTopReaderContext());
            ret.setSimilarity(LuceneTestCase.classEnvRule.similarity);
            return ret;
        }
        int threads = 0;
        if (random.nextBoolean()) {
            ex = null;
        } else {
            threads = _TestUtil.nextInt(random, 1, 8);
            ex = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("LuceneTestCase"));
        }
        if (ex != null) {
            if (VERBOSE) {
                System.out.println("NOTE: newSearcher using ExecutorService with " + threads + " threads");
            }
            r.addReaderClosedListener(new IndexReader.ReaderClosedListener(){

                public void onClose(IndexReader reader) {
                    _TestUtil.shutdownExecutorService(ex);
                }
            });
        }
        AssertingIndexSearcher ret = random.nextBoolean() ? new AssertingIndexSearcher(random, r, ex) : new AssertingIndexSearcher(random, r.getTopReaderContext(), ex);
        ret.setSimilarity(LuceneTestCase.classEnvRule.similarity);
        return ret;
    }

    protected File getDataFile(String name) throws IOException {
        try {
            return new File(((Object)((Object)this)).getClass().getResource(name).toURI());
        }
        catch (Exception e) {
            throw new IOException("Cannot find resource: " + name);
        }
    }

    static {
        String s = System.getProperty("tempDir", System.getProperty("java.io.tmpdir"));
        if (s == null) {
            throw new RuntimeException("To run tests, you need to define system property 'tempDir' or 'java.io.tmpdir'.");
        }
        TEMP_DIR = new File(s);
        TEMP_DIR.mkdirs();
        IGNORED_INVARIANT_PROPERTIES = new String[]{"user.timezone"};
        FS_DIRECTORIES = Arrays.asList("SimpleFSDirectory", "NIOFSDirectory", "MMapDirectory");
        CORE_DIRECTORIES = new ArrayList<String>(FS_DIRECTORIES);
        CORE_DIRECTORIES.add("RAMDirectory");
        doesntSupportOffsets = new HashSet<String>(Arrays.asList("Lucene3x", "MockFixedIntBlock", "MockVariableIntBlock", "MockSep", "MockRandom", "For", "PFor"));
        suiteFailureMarker = new TestRuleMarkFailure(new TestRuleMarkFailure[0]);
        int maxFailures = RandomizedTest.systemPropertyAsInt((String)SYSPROP_MAXFAILURES, (int)Integer.MAX_VALUE);
        boolean failFast = RandomizedTest.systemPropertyAsBoolean((String)SYSPROP_FAILFAST, (boolean)false);
        if (failFast) {
            if (maxFailures == Integer.MAX_VALUE) {
                maxFailures = 1;
            } else {
                Logger.getLogger(LuceneTestCase.class.getSimpleName()).warning("Property 'tests.maxfailures'=" + maxFailures + ", 'failfast' is" + " ignored.");
            }
        }
        ignoreAfterMaxFailures = new TestRuleIgnoreAfterMaxFailures(maxFailures);
        classNameRule = new TestRuleStoreClassName();
        classEnvRule = new TestRuleSetupAndRestoreClassEnv();
        classRules = RuleChain.outerRule((TestRule)new TestRuleIgnoreTestSuites()).around((TestRule)ignoreAfterMaxFailures).around((TestRule)suiteFailureMarker).around((TestRule)new TestRuleAssertionsRequired()).around((TestRule)new TestRuleNoStaticHooksShadowing()).around((TestRule)new TestRuleNoInstanceHooksOverrides()).around((TestRule)new SystemPropertiesInvariantRule(IGNORED_INVARIANT_PROPERTIES)).around((TestRule)classNameRule).around((TestRule)new TestRuleReportUncaughtExceptions()).around((TestRule)classEnvRule);
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressCodecs {
        public String[] value();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=true, sysProperty="tests.slow")
    public static @interface Slow {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.awaitsfix")
    public static @interface AwaitsFix {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.weekly")
    public static @interface Weekly {
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestGroup(enabled=false, sysProperty="tests.nightly")
    public static @interface Nightly {
    }
}

