/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicModelG;
import org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.DistributionLL;
import org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.lucene.search.similarities.LMJelinekMercerSimilarity;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.LambdaDF;
import org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.lucene.search.similarities.NormalizationZ;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;

public class RandomSimilarityProvider
extends PerFieldSimilarityWrapper {
    final DefaultSimilarity defaultSim = new DefaultSimilarity();
    final List<Similarity> knownSims;
    Map<String, Similarity> previousMappings = new HashMap<String, Similarity>();
    final int perFieldSeed;
    final boolean shouldCoord;
    final boolean shouldQueryNorm;
    static BasicModel[] BASIC_MODELS = new BasicModel[]{new BasicModelG(), new BasicModelIF(), new BasicModelIn(), new BasicModelIne()};
    static AfterEffect[] AFTER_EFFECTS = new AfterEffect[]{new AfterEffectB(), new AfterEffectL(), new AfterEffect.NoAfterEffect()};
    static Normalization[] NORMALIZATIONS = new Normalization[]{new NormalizationH1(), new NormalizationH2(), new NormalizationH3(), new NormalizationZ()};
    static Distribution[] DISTRIBUTIONS = new Distribution[]{new DistributionLL(), new DistributionSPL()};
    static Lambda[] LAMBDAS = new Lambda[]{new LambdaDF(), new LambdaTTF()};
    static List<Similarity> allSims = new ArrayList<Similarity>();

    public RandomSimilarityProvider(Random random) {
        this.perFieldSeed = random.nextInt();
        this.shouldCoord = random.nextBoolean();
        this.shouldQueryNorm = random.nextBoolean();
        this.knownSims = new ArrayList<Similarity>(allSims);
        Collections.shuffle(this.knownSims, random);
    }

    public float coord(int overlap, int maxOverlap) {
        if (this.shouldCoord) {
            return this.defaultSim.coord(overlap, maxOverlap);
        }
        return 1.0f;
    }

    public float queryNorm(float sumOfSquaredWeights) {
        if (this.shouldQueryNorm) {
            return this.defaultSim.queryNorm(sumOfSquaredWeights);
        }
        return 1.0f;
    }

    public synchronized Similarity get(String field) {
        assert (field != null);
        Similarity sim = this.previousMappings.get(field);
        if (sim == null) {
            sim = this.knownSims.get(Math.abs(this.perFieldSeed ^ field.hashCode()) % this.knownSims.size());
            this.previousMappings.put(field, sim);
        }
        return sim;
    }

    public synchronized String toString() {
        return "RandomSimilarityProvider(queryNorm=" + this.shouldQueryNorm + ",coord=" + this.shouldCoord + "): " + this.previousMappings.toString();
    }

    static {
        allSims.add((Similarity)new DefaultSimilarity());
        allSims.add((Similarity)new BM25Similarity());
        for (BasicModel basicModel : BASIC_MODELS) {
            for (AfterEffect afterEffect : AFTER_EFFECTS) {
                for (Normalization normalization : NORMALIZATIONS) {
                    allSims.add((Similarity)new DFRSimilarity(basicModel, afterEffect, normalization));
                }
            }
        }
        for (BasicModel basicModel : DISTRIBUTIONS) {
            for (AfterEffect afterEffect : LAMBDAS) {
                for (Normalization normalization : NORMALIZATIONS) {
                    allSims.add((Similarity)new IBSimilarity((Distribution)basicModel, (Lambda)afterEffect, normalization));
                }
            }
        }
        allSims.add((Similarity)new LMJelinekMercerSimilarity(0.1f));
        allSims.add((Similarity)new LMJelinekMercerSimilarity(0.7f));
    }
}

