/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mockrandom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.lucene.codecs.BlockTermsReader;
import org.apache.lucene.codecs.BlockTermsWriter;
import org.apache.lucene.codecs.BlockTreeTermsReader;
import org.apache.lucene.codecs.BlockTreeTermsWriter;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsIndexReaderBase;
import org.apache.lucene.codecs.TermsIndexWriterBase;
import org.apache.lucene.codecs.VariableGapTermsIndexReader;
import org.apache.lucene.codecs.VariableGapTermsIndexWriter;
import org.apache.lucene.codecs.lucene40.Lucene40PostingsReader;
import org.apache.lucene.codecs.lucene40.Lucene40PostingsWriter;
import org.apache.lucene.codecs.mockintblock.MockFixedIntBlockPostingsFormat;
import org.apache.lucene.codecs.mockintblock.MockVariableIntBlockPostingsFormat;
import org.apache.lucene.codecs.mocksep.MockSingleIntFactory;
import org.apache.lucene.codecs.pulsing.PulsingPostingsReader;
import org.apache.lucene.codecs.pulsing.PulsingPostingsWriter;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepPostingsReader;
import org.apache.lucene.codecs.sep.SepPostingsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

public class MockRandomPostingsFormat
extends PostingsFormat {
    private final Random seedRandom;
    private final String SEED_EXT = "sd";

    public MockRandomPostingsFormat() {
        this(null);
    }

    public MockRandomPostingsFormat(Random random) {
        super("MockRandom");
        this.seedRandom = random == null ? new Random(0L){

            @Override
            protected int next(int arg0) {
                throw new IllegalStateException("Please use MockRandomPostingsFormat(Random)");
            }
        } : new Random(random.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        BlockTreeTermsWriter fields;
        Lucene40PostingsWriter postingsWriter;
        int skipInterval = _TestUtil.nextInt(this.seedRandom, 2, 10);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: skipInterval=" + skipInterval);
        }
        long seed = this.seedRandom.nextLong();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: writing to seg=" + state.segmentInfo.name + " formatID=" + state.segmentSuffix + " seed=" + seed);
        }
        String seedFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sd");
        IndexOutput out = state.directory.createOutput(seedFileName, state.context);
        try {
            out.writeLong(seed);
        }
        finally {
            out.close();
        }
        Random random = new Random(seed);
        random.nextInt();
        if (random.nextBoolean()) {
            postingsWriter = new SepPostingsWriter(state, (IntStreamFactory)new MockIntStreamFactory(random), skipInterval);
        } else {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing Standard postings");
            }
            postingsWriter = new Lucene40PostingsWriter(state, skipInterval);
        }
        if (random.nextBoolean()) {
            int totTFCutoff = _TestUtil.nextInt(random, 1, 20);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing pulsing postings with totTFCutoff=" + totTFCutoff);
            }
            postingsWriter = new PulsingPostingsWriter(totTFCutoff, (PostingsWriterBase)postingsWriter);
        }
        if (random.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: writing BlockTree terms dict");
            }
            int minTermsInBlock = _TestUtil.nextInt(random, 2, 100);
            int maxTermsInBlock = Math.max(2, (minTermsInBlock - 1) * 2 + random.nextInt(100));
            boolean success = false;
            try {
                fields = new BlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, minTermsInBlock, maxTermsInBlock);
                success = true;
            }
            finally {
                if (!success) {
                    postingsWriter.close();
                }
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: writing Block terms dict");
        }
        boolean success = false;
        try {
            if (random.nextBoolean()) {
                state.termIndexInterval = _TestUtil.nextInt(random, 1, 100);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("MockRandomCodec: fixed-gap terms index (tii=" + state.termIndexInterval + ")");
                }
                indexWriter = new FixedGapTermsIndexWriter(state);
            } else {
                Object selector;
                int n2 = random.nextInt(3);
                if (n2 == 0) {
                    int tii = _TestUtil.nextInt(random, 1, 100);
                    selector = new VariableGapTermsIndexWriter.EveryNTermSelector(tii);
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockRandomCodec: variable-gap terms index (tii=" + tii + ")");
                    }
                } else if (n2 == 1) {
                    int docFreqThresh = _TestUtil.nextInt(random, 2, 100);
                    int tii = _TestUtil.nextInt(random, 1, 100);
                    selector = new VariableGapTermsIndexWriter.EveryNOrDocFreqTermSelector(docFreqThresh, tii);
                } else {
                    final long seed2 = random.nextLong();
                    final int gap = _TestUtil.nextInt(random, 2, 40);
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("MockRandomCodec: random-gap terms index (max gap=" + gap + ")");
                    }
                    selector = new VariableGapTermsIndexWriter.IndexTermSelector(){
                        final Random rand;
                        {
                            this.rand = new Random(seed2);
                        }

                        public boolean isIndexTerm(BytesRef term, TermStats stats) {
                            return this.rand.nextInt(gap) == gap / 2;
                        }

                        public void newField(FieldInfo fieldInfo) {
                        }
                    };
                }
                indexWriter = new VariableGapTermsIndexWriter(state, (VariableGapTermsIndexWriter.IndexTermSelector)selector);
            }
            success = true;
        }
        finally {
            if (!success) {
                postingsWriter.close();
            }
        }
        success = false;
        try {
            fields = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)postingsWriter);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    postingsWriter.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        BlockTreeTermsReader fields;
        Lucene40PostingsReader postingsReader;
        String seedFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"sd");
        IndexInput in = state.dir.openInput(seedFileName, state.context);
        long seed = in.readLong();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: reading from seg=" + state.segmentInfo.name + " formatID=" + state.segmentSuffix + " seed=" + seed);
        }
        in.close();
        Random random = new Random(seed);
        int readBufferSize = _TestUtil.nextInt(random, 1, 4096);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: readBufferSize=" + readBufferSize);
        }
        if (random.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading Sep postings");
            }
            postingsReader = new SepPostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, (IntStreamFactory)new MockIntStreamFactory(random), state.segmentSuffix);
        } else {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading Standard postings");
            }
            postingsReader = new Lucene40PostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, state.segmentSuffix);
        }
        if (random.nextBoolean()) {
            int totTFCutoff = _TestUtil.nextInt(random, 1, 20);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading pulsing postings with totTFCutoff=" + totTFCutoff);
            }
            postingsReader = new PulsingPostingsReader((PostingsReaderBase)postingsReader);
        }
        if (random.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: reading BlockTree terms dict");
            }
            boolean success = false;
            try {
                fields = new BlockTreeTermsReader(state.dir, state.fieldInfos, state.segmentInfo.name, (PostingsReaderBase)postingsReader, state.context, state.segmentSuffix, state.termsIndexDivisor);
                success = true;
            }
            finally {
                if (!success) {
                    postingsReader.close();
                }
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("MockRandomCodec: reading Block terms dict");
        }
        boolean success = false;
        try {
            boolean doFixedGap = random.nextBoolean();
            if (state.termsIndexDivisor != -1) {
                state.termsIndexDivisor = _TestUtil.nextInt(random, 1, 10);
            }
            if (doFixedGap) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("MockRandomCodec: fixed-gap terms index (divisor=" + state.termsIndexDivisor + ")");
                }
                indexReader = new FixedGapTermsIndexReader(state.dir, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, BytesRef.getUTF8SortedAsUnicodeComparator(), state.segmentSuffix, state.context);
            } else {
                int n2 = random.nextInt(3);
                if (n2 == 1) {
                    random.nextInt();
                } else if (n2 == 2) {
                    random.nextLong();
                }
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("MockRandomCodec: variable-gap terms index (divisor=" + state.termsIndexDivisor + ")");
                }
                indexReader = new VariableGapTermsIndexReader(state.dir, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, state.segmentSuffix, state.context);
            }
            success = true;
        }
        finally {
            if (!success) {
                postingsReader.close();
            }
        }
        int termsCacheSize = _TestUtil.nextInt(random, 1, 1024);
        success = false;
        try {
            fields = new BlockTermsReader((TermsIndexReaderBase)indexReader, state.dir, state.fieldInfos, state.segmentInfo.name, (PostingsReaderBase)postingsReader, state.context, termsCacheSize, state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    postingsReader.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
        return fields;
    }

    private static class MockIntStreamFactory
    extends IntStreamFactory {
        private final int salt;
        private final List<IntStreamFactory> delegates = new ArrayList<IntStreamFactory>();

        public MockIntStreamFactory(Random random) {
            this.salt = random.nextInt();
            this.delegates.add(new MockSingleIntFactory());
            int blockSize = _TestUtil.nextInt(random, 1, 2000);
            this.delegates.add(new MockFixedIntBlockPostingsFormat.MockIntFactory(blockSize));
            int baseBlockSize = _TestUtil.nextInt(random, 1, 127);
            this.delegates.add(new MockVariableIntBlockPostingsFormat.MockIntFactory(baseBlockSize));
        }

        private static String getExtension(String fileName) {
            int idx = fileName.indexOf(46);
            assert (idx != -1);
            return fileName.substring(idx);
        }

        public IntIndexInput openInput(Directory dir, String fileName, IOContext context) throws IOException {
            IntStreamFactory f = this.delegates.get(Math.abs(this.salt ^ MockIntStreamFactory.getExtension(fileName).hashCode()) % this.delegates.size());
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: read using int factory " + f + " from fileName=" + fileName);
            }
            return f.openInput(dir, fileName, context);
        }

        public IntIndexOutput createOutput(Directory dir, String fileName, IOContext context) throws IOException {
            IntStreamFactory f = this.delegates.get(Math.abs(this.salt ^ MockIntStreamFactory.getExtension(fileName).hashCode()) % this.delegates.size());
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockRandomCodec: write using int factory " + f + " to fileName=" + fileName);
            }
            return f.createOutput(dir, fileName, context);
        }
    }
}

