/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public class MockTokenizer
extends Tokenizer {
    public static final CharacterRunAutomaton WHITESPACE = new CharacterRunAutomaton(new RegExp("[^ \t\r\n]+").toAutomaton());
    public static final CharacterRunAutomaton KEYWORD = new CharacterRunAutomaton(new RegExp(".*").toAutomaton());
    public static final CharacterRunAutomaton SIMPLE = new CharacterRunAutomaton(new RegExp("[A-Za-z\u00aa\u00b5\u00ba\u00c0-\u00d6\u00d8-\u00f6\u00f8-\uff3a]+").toAutomaton());
    private final CharacterRunAutomaton runAutomaton;
    private final boolean lowerCase;
    private final int maxTokenLength;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = Integer.MAX_VALUE;
    private int state;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    int off = 0;
    private State streamState = State.CLOSE;
    private int lastOffset = 0;
    private boolean enableChecks = true;

    public MockTokenizer(AttributeSource.AttributeFactory factory, Reader input, CharacterRunAutomaton runAutomaton, boolean lowerCase, int maxTokenLength) {
        super(factory, input);
        this.runAutomaton = runAutomaton;
        this.lowerCase = lowerCase;
        this.state = runAutomaton.getInitialState();
        this.streamState = State.SETREADER;
        this.maxTokenLength = maxTokenLength;
    }

    public MockTokenizer(Reader input, CharacterRunAutomaton runAutomaton, boolean lowerCase, int maxTokenLength) {
        this(AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, input, runAutomaton, lowerCase, maxTokenLength);
    }

    public MockTokenizer(Reader input, CharacterRunAutomaton runAutomaton, boolean lowerCase) {
        this(input, runAutomaton, lowerCase, Integer.MAX_VALUE);
    }

    public MockTokenizer(Reader input) {
        this(input, WHITESPACE, true);
    }

    public final boolean incrementToken() throws IOException {
        block8: {
            int endOffset;
            int startOffset;
            int cp;
            assert (!this.enableChecks || this.streamState == State.RESET || this.streamState == State.INCREMENT) : "incrementToken() called while in wrong state: " + (Object)((Object)this.streamState);
            this.clearAttributes();
            do {
                startOffset = this.off;
                cp = this.readCodePoint();
                if (cp < 0) break block8;
            } while (!this.isTokenChar(cp));
            do {
                char[] chars = Character.toChars(this.normalize(cp));
                for (int i = 0; i < chars.length; ++i) {
                    this.termAtt.append(chars[i]);
                }
                endOffset = this.off;
            } while (this.termAtt.length() < this.maxTokenLength && (cp = this.readCodePoint()) >= 0 && this.isTokenChar(cp));
            int correctedStartOffset = this.correctOffset(startOffset);
            int correctedEndOffset = this.correctOffset(endOffset);
            assert (correctedStartOffset >= 0);
            assert (correctedEndOffset >= 0);
            assert (correctedStartOffset >= this.lastOffset);
            this.lastOffset = correctedStartOffset;
            assert (correctedEndOffset >= correctedStartOffset);
            this.offsetAtt.setOffset(correctedStartOffset, correctedEndOffset);
            this.streamState = State.INCREMENT;
            return true;
        }
        this.streamState = State.INCREMENT_FALSE;
        return false;
    }

    protected int readCodePoint() throws IOException {
        int ch = this.input.read();
        if (ch < 0) {
            return ch;
        }
        assert (!Character.isLowSurrogate((char)ch)) : "unpaired low surrogate: " + Integer.toHexString(ch);
        ++this.off;
        if (Character.isHighSurrogate((char)ch)) {
            int ch2 = this.input.read();
            if (ch2 >= 0) {
                ++this.off;
                assert (Character.isLowSurrogate((char)ch2)) : "unpaired high surrogate: " + Integer.toHexString(ch) + ", followed by: " + Integer.toHexString(ch2);
                return Character.toCodePoint((char)ch, (char)ch2);
            }
            assert (false) : "stream ends with unpaired high surrogate: " + Integer.toHexString(ch);
        }
        return ch;
    }

    protected boolean isTokenChar(int c) {
        this.state = this.runAutomaton.step(this.state, c);
        if (this.state < 0) {
            this.state = this.runAutomaton.getInitialState();
            return false;
        }
        return true;
    }

    protected int normalize(int c) {
        return this.lowerCase ? Character.toLowerCase(c) : c;
    }

    public void reset() throws IOException {
        super.reset();
        this.state = this.runAutomaton.getInitialState();
        this.off = 0;
        this.lastOffset = 0;
        assert (!this.enableChecks || this.streamState != State.RESET) : "double reset()";
        this.streamState = State.RESET;
    }

    public void close() throws IOException {
        super.close();
        assert (!this.enableChecks || this.streamState == State.END || this.streamState == State.CLOSE) : "close() called in wrong state: " + (Object)((Object)this.streamState);
        this.streamState = State.CLOSE;
    }

    public void setReader(Reader input) throws IOException {
        super.setReader(input);
        assert (!this.enableChecks || this.streamState == State.CLOSE) : "setReader() called in wrong state: " + (Object)((Object)this.streamState);
        this.streamState = State.SETREADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws IOException {
        int finalOffset = this.correctOffset(this.off);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        try {
            assert (!this.enableChecks || this.streamState == State.INCREMENT_FALSE) : "end() called before incrementToken() returned false!";
        }
        finally {
            this.streamState = State.END;
        }
    }

    public void setEnableChecks(boolean enableChecks) {
        this.enableChecks = enableChecks;
    }

    private static enum State {
        SETREADER,
        RESET,
        INCREMENT,
        INCREMENT_FALSE,
        END,
        CLOSE;

    }
}

