/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MockIndexInputWrapper;
import org.apache.lucene.store.MockIndexOutputWrapper;
import org.apache.lucene.store.MockLockFactoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.ThrottledIndexOutput;
import org.apache.lucene.util._TestUtil;

public class MockDirectoryWrapper
extends Directory {
    final Directory delegate;
    long maxSize;
    long maxUsedSize;
    double randomIOExceptionRate;
    Random randomState;
    boolean noDeleteOpenFile = true;
    boolean preventDoubleWrite = true;
    boolean checkIndexOnClose = true;
    boolean crossCheckTermVectorsOnClose = true;
    boolean trackDiskUsage = false;
    private Set<String> unSyncedFiles;
    private Set<String> createdFiles;
    private Set<String> openFilesForWrite = new HashSet<String>();
    Set<String> openLocks = Collections.synchronizedSet(new HashSet());
    volatile boolean crashed;
    private ThrottledIndexOutput throttledOutput;
    private Throttling throttling = Throttling.SOMETIMES;
    final AtomicInteger inputCloneCount = new AtomicInteger();
    private Map<Closeable, Exception> openFileHandles = Collections.synchronizedMap(new IdentityHashMap());
    private Map<String, Integer> openFiles;
    private Set<String> openFilesDeleted;
    final RateLimiter rateLimiter;
    private boolean failOnCreateOutput = true;
    private boolean failOnOpenInput = true;
    private boolean assertNoUnreferencedFilesOnClose = true;
    boolean open = true;
    ArrayList<Failure> failures;

    private synchronized void init() {
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.createdFiles == null) {
            this.createdFiles = new HashSet<String>();
        }
        if (this.unSyncedFiles == null) {
            this.unSyncedFiles = new HashSet<String>();
        }
    }

    public MockDirectoryWrapper(Random random, Directory delegate) {
        this.delegate = delegate;
        this.randomState = new Random(random.nextInt());
        this.throttledOutput = new ThrottledIndexOutput(ThrottledIndexOutput.mBitsToBytes(40 + this.randomState.nextInt(10)), 5 + this.randomState.nextInt(5), null);
        try {
            this.setLockFactory(new MockLockFactoryWrapper(this, delegate.getLockFactory()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.randomState.nextInt(50) == 17) {
            double maxMBPerSec = 10.0 + 5.0 * (this.randomState.nextDouble() - 0.5);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: will rate limit output IO to " + maxMBPerSec + " MB/sec");
            }
            this.rateLimiter = new RateLimiter(maxMBPerSec);
        } else {
            this.rateLimiter = null;
        }
        this.init();
    }

    public int getInputCloneCount() {
        return this.inputCloneCount.get();
    }

    public void setTrackDiskUsage(boolean v) {
        this.trackDiskUsage = v;
    }

    public void setPreventDoubleWrite(boolean value) {
        this.preventDoubleWrite = value;
    }

    public void setThrottling(Throttling throttling) {
        this.throttling = throttling;
    }

    public synchronized void sync(Collection<String> names) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed) {
            throw new IOException("cannot sync after crash");
        }
        this.unSyncedFiles.removeAll(names);
        if (LuceneTestCase.rarely(this.randomState) || this.delegate instanceof NRTCachingDirectory) {
            this.delegate.sync(names);
        }
    }

    public String toString() {
        return "MockDirWrapper(" + this.delegate + ")";
    }

    public final synchronized long sizeInBytes() throws IOException {
        if (this.delegate instanceof RAMDirectory) {
            return ((RAMDirectory)this.delegate).sizeInBytes();
        }
        long size = 0L;
        for (String file : this.delegate.listAll()) {
            size += this.delegate.fileLength(file);
        }
        return size;
    }

    public synchronized void crash() throws IOException {
        this.crashed = true;
        this.openFiles = new HashMap<String, Integer>();
        this.openFilesForWrite = new HashSet<String>();
        this.openFilesDeleted = new HashSet<String>();
        Iterator<String> it = this.unSyncedFiles.iterator();
        this.unSyncedFiles = new HashSet<String>();
        IdentityHashMap<Closeable, Exception> m = new IdentityHashMap<Closeable, Exception>(this.openFileHandles);
        for (Closeable f : m.keySet()) {
            try {
                f.close();
            }
            catch (Exception ignored) {}
        }
        while (it.hasNext()) {
            String name = it.next();
            int damage = this.randomState.nextInt(5);
            String action = null;
            if (damage == 0) {
                action = "deleted";
                this.deleteFile(name, true);
            } else if (damage == 1) {
                int limit;
                action = "zeroed";
                long length = this.fileLength(name);
                byte[] zeroes = new byte[256];
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                for (long upto = 0L; upto < length; upto += (long)limit) {
                    limit = (int)Math.min(length - upto, (long)zeroes.length);
                    out.writeBytes(zeroes, 0, limit);
                }
                out.close();
            } else if (damage == 2) {
                String tempFileName;
                action = "partially truncated";
                while (this.delegate.fileExists(tempFileName = "" + this.randomState.nextInt())) {
                }
                IndexOutput tempOut = this.delegate.createOutput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                IndexInput in = this.delegate.openInput(name, LuceneTestCase.newIOContext(this.randomState));
                tempOut.copyBytes((DataInput)in, in.length() / 2L);
                tempOut.close();
                in.close();
                this.deleteFile(name, true);
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                in = this.delegate.openInput(tempFileName, LuceneTestCase.newIOContext(this.randomState));
                out.copyBytes((DataInput)in, in.length());
                out.close();
                in.close();
                this.deleteFile(tempFileName, true);
            } else if (damage == 3) {
                action = "didn't change";
            } else {
                action = "fully truncated";
                this.deleteFile(name, true);
                IndexOutput out = this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState));
                out.setLength(0L);
                out.close();
            }
            if (!LuceneTestCase.VERBOSE) continue;
            System.out.println("MockDirectoryWrapper: " + action + " unsynced file: " + name);
        }
    }

    public synchronized void clearCrash() throws IOException {
        this.crashed = false;
        this.openLocks.clear();
    }

    public void setMaxSizeInBytes(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxSizeInBytes() {
        return this.maxSize;
    }

    public long getMaxUsedSizeInBytes() {
        return this.maxUsedSize;
    }

    public void resetMaxUsedSizeInBytes() throws IOException {
        this.maxUsedSize = this.getRecomputedActualSizeInBytes();
    }

    public void setNoDeleteOpenFile(boolean value) {
        this.noDeleteOpenFile = value;
    }

    public boolean getNoDeleteOpenFile() {
        return this.noDeleteOpenFile;
    }

    public void setCheckIndexOnClose(boolean value) {
        this.checkIndexOnClose = value;
    }

    public boolean getCheckIndexOnClose() {
        return this.checkIndexOnClose;
    }

    public void setCrossCheckTermVectorsOnClose(boolean value) {
        this.crossCheckTermVectorsOnClose = value;
    }

    public boolean getCrossCheckTermVectorsOnClose() {
        return this.crossCheckTermVectorsOnClose;
    }

    public void setRandomIOExceptionRate(double rate) {
        this.randomIOExceptionRate = rate;
    }

    public double getRandomIOExceptionRate() {
        return this.randomIOExceptionRate;
    }

    void maybeThrowIOException() throws IOException {
        this.maybeThrowIOException(null);
    }

    void maybeThrowIOException(String message) throws IOException {
        int number;
        if (this.randomIOExceptionRate > 0.0 && (double)(number = Math.abs(this.randomState.nextInt() % 1000)) < this.randomIOExceptionRate * 1000.0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MockDirectoryWrapper: now throw random exception" + (message == null ? "" : " (" + message + ")"));
                new Throwable().printStackTrace(System.out);
            }
            throw new IOException("a random IOException" + (message == null ? "" : "(" + message + ")"));
        }
    }

    public synchronized void deleteFile(String name) throws IOException {
        this.maybeYield();
        this.deleteFile(name, false);
    }

    private synchronized IOException fillOpenTrace(IOException ioe, String name, boolean input) {
        for (Map.Entry<Closeable, Exception> ent : this.openFileHandles.entrySet()) {
            if (input && ent.getKey() instanceof MockIndexInputWrapper && ((MockIndexInputWrapper)((Object)ent.getKey())).name.equals(name)) {
                ioe.initCause(ent.getValue());
                break;
            }
            if (input || !(ent.getKey() instanceof MockIndexOutputWrapper) || !((MockIndexOutputWrapper)((Object)ent.getKey())).name.equals(name)) continue;
            ioe.initCause(ent.getValue());
            break;
        }
        return ioe;
    }

    private void maybeYield() {
        if (this.randomState.nextBoolean()) {
            Thread.yield();
        }
    }

    private synchronized void deleteFile(String name, boolean forced) throws IOException {
        this.maybeYield();
        this.maybeThrowDeterministicException();
        if (this.crashed && !forced) {
            throw new IOException("cannot delete after crash");
        }
        if (this.unSyncedFiles.contains(name)) {
            this.unSyncedFiles.remove(name);
        }
        if (!forced && this.noDeleteOpenFile) {
            if (this.openFiles.containsKey(name)) {
                this.openFilesDeleted.add(name);
                throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot delete"), name, true);
            }
            this.openFilesDeleted.remove(name);
        }
        this.delegate.deleteFile(name);
    }

    public synchronized Set<String> getOpenDeletedFiles() {
        return new HashSet<String>(this.openFilesDeleted);
    }

    public void setFailOnCreateOutput(boolean v) {
        this.failOnCreateOutput = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.maybeYield();
        if (this.failOnCreateOutput) {
            this.maybeThrowDeterministicException();
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.init();
        MockDirectoryWrapper mockDirectoryWrapper = this;
        synchronized (mockDirectoryWrapper) {
            if (this.preventDoubleWrite && this.createdFiles.contains(name) && !name.equals("segments.gen")) {
                throw new IOException("file \"" + name + "\" was already written to");
            }
        }
        if (this.noDeleteOpenFile && this.openFiles.containsKey(name)) {
            throw new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open: cannot overwrite");
        }
        if (this.crashed) {
            throw new IOException("cannot createOutput after crash");
        }
        this.unSyncedFiles.add(name);
        this.createdFiles.add(name);
        if (this.delegate instanceof RAMDirectory) {
            RAMDirectory ramdir = (RAMDirectory)this.delegate;
            RAMFile file = new RAMFile(ramdir);
            RAMFile existing = (RAMFile)ramdir.fileMap.get(name);
            if (existing != null && !name.equals("segments.gen") && this.preventDoubleWrite) {
                throw new IOException("file " + name + " already exists");
            }
            if (existing != null) {
                ramdir.sizeInBytes.getAndAdd(-existing.sizeInBytes);
                existing.directory = null;
            }
            ramdir.fileMap.put(name, file);
        }
        MockIndexOutputWrapper io = new MockIndexOutputWrapper(this, this.delegate.createOutput(name, LuceneTestCase.newIOContext(this.randomState)), name);
        this.addFileHandle((Closeable)((Object)io), name, Handle.Output);
        this.openFilesForWrite.add(name);
        if (this.throttling == Throttling.ALWAYS || this.throttling == Throttling.SOMETIMES && this.randomState.nextInt(50) == 0) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("MockDirectoryWrapper: throttling indexOutput");
            }
            return this.throttledOutput.newFromDelegate(io);
        }
        return io;
    }

    synchronized void addFileHandle(Closeable c, String name, Handle handle) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            v = v + 1;
            this.openFiles.put(name, v);
        } else {
            this.openFiles.put(name, 1);
        }
        this.openFileHandles.put(c, new RuntimeException("unclosed Index" + handle.name() + ": " + name));
    }

    public void setFailOnOpenInput(boolean v) {
        this.failOnOpenInput = v;
    }

    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        this.maybeYield();
        if (this.failOnOpenInput) {
            this.maybeThrowDeterministicException();
        }
        if (!this.delegate.fileExists(name)) {
            throw new FileNotFoundException(name + " in dir=" + this.delegate);
        }
        if (this.openFilesForWrite.contains(name) && !name.startsWith("segments")) {
            throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        MockIndexInputWrapper ii = new MockIndexInputWrapper(this, name, this.delegate.openInput(name, LuceneTestCase.newIOContext(this.randomState)));
        this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
        return ii;
    }

    public final synchronized long getRecomputedSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.getSizeInBytes();
        }
        return size;
    }

    public final synchronized long getRecomputedActualSizeInBytes() throws IOException {
        if (!(this.delegate instanceof RAMDirectory)) {
            return this.sizeInBytes();
        }
        long size = 0L;
        for (RAMFile file : ((RAMDirectory)this.delegate).fileMap.values()) {
            size += file.length;
        }
        return size;
    }

    public void setAssertNoUnrefencedFilesOnClose(boolean v) {
        this.assertNoUnreferencedFilesOnClose = v;
    }

    public synchronized void close() throws IOException {
        this.maybeYield();
        if (this.openFiles == null) {
            this.openFiles = new HashMap<String, Integer>();
            this.openFilesDeleted = new HashSet<String>();
        }
        if (this.noDeleteOpenFile && this.openFiles.size() > 0) {
            Exception cause = null;
            Iterator<Exception> stacktraces = this.openFileHandles.values().iterator();
            if (stacktraces.hasNext()) {
                cause = stacktraces.next();
            }
            throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open files: " + this.openFiles, cause);
        }
        if (this.noDeleteOpenFile && this.openLocks.size() > 0) {
            throw new RuntimeException("MockDirectoryWrapper: cannot close: there are still open locks: " + this.openLocks);
        }
        this.open = false;
        if (this.checkIndexOnClose && this.indexPossiblyExists(this)) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("\nNOTE: MockDirectoryWrapper: now crash");
            }
            this.crash();
            if (LuceneTestCase.VERBOSE) {
                System.out.println("\nNOTE: MockDirectoryWrapper: now run CheckIndex");
            }
            _TestUtil.checkIndex(this, this.crossCheckTermVectorsOnClose);
            if (this.assertNoUnreferencedFilesOnClose) {
                Object[] startFiles = this.listAll();
                new IndexWriter((Directory)this, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, null)).rollback();
                Object[] endFiles = this.listAll();
                Arrays.sort(startFiles);
                Arrays.sort(endFiles);
                if (!Arrays.equals(startFiles, endFiles)) assert (false) : "unreferenced files: before delete:\n    " + Arrays.toString(startFiles) + "\n  after delete:\n    " + Arrays.toString(endFiles);
                DirectoryReader ir1 = DirectoryReader.open((Directory)this);
                int numDocs1 = ir1.numDocs();
                ir1.close();
                new IndexWriter((Directory)this, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, null)).close();
                DirectoryReader ir2 = DirectoryReader.open((Directory)this);
                int numDocs2 = ir2.numDocs();
                ir2.close();
                assert (numDocs1 == numDocs2) : "numDocs changed after opening/closing IW: before=" + numDocs1 + " after=" + numDocs2;
            }
        }
        this.delegate.close();
    }

    private boolean indexPossiblyExists(Directory d) throws IOException {
        String[] files;
        try {
            files = d.listAll();
        }
        catch (IOException ex) {
            return false;
        }
        for (String f : files) {
            if (!f.startsWith("segments_")) continue;
            return true;
        }
        return false;
    }

    synchronized void removeOpenFile(Closeable c, String name) {
        Integer v = this.openFiles.get(name);
        if (v != null) {
            if (v == 1) {
                this.openFiles.remove(name);
                this.openFilesDeleted.remove(name);
            } else {
                v = v - 1;
                this.openFiles.put(name, v);
            }
        }
        this.openFileHandles.remove(c);
    }

    public synchronized void removeIndexOutput(IndexOutput out, String name) {
        this.openFilesForWrite.remove(name);
        this.removeOpenFile((Closeable)out, name);
    }

    public synchronized void removeIndexInput(IndexInput in, String name) {
        this.removeOpenFile((Closeable)in, name);
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public synchronized void failOn(Failure fail) {
        if (this.failures == null) {
            this.failures = new ArrayList();
        }
        this.failures.add(fail);
    }

    synchronized void maybeThrowDeterministicException() throws IOException {
        if (this.failures != null) {
            for (int i = 0; i < this.failures.size(); ++i) {
                this.failures.get(i).eval(this);
            }
        }
    }

    public synchronized String[] listAll() throws IOException {
        this.maybeYield();
        return this.delegate.listAll();
    }

    public synchronized boolean fileExists(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileExists(name);
    }

    public synchronized long fileLength(String name) throws IOException {
        this.maybeYield();
        return this.delegate.fileLength(name);
    }

    public synchronized Lock makeLock(String name) {
        this.maybeYield();
        return this.delegate.makeLock(name);
    }

    public synchronized void clearLock(String name) throws IOException {
        this.maybeYield();
        this.delegate.clearLock(name);
    }

    public synchronized void setLockFactory(LockFactory lockFactory) throws IOException {
        this.maybeYield();
        this.delegate.setLockFactory(lockFactory);
    }

    public synchronized LockFactory getLockFactory() {
        this.maybeYield();
        return this.delegate.getLockFactory();
    }

    public synchronized String getLockID() {
        this.maybeYield();
        return this.delegate.getLockID();
    }

    public synchronized void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.maybeYield();
        this.delegate.copy(to, src, dest, context);
    }

    public Directory.IndexInputSlicer createSlicer(final String name, IOContext context) throws IOException {
        this.maybeYield();
        if (!this.delegate.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        if (this.openFilesForWrite.contains(name) && !name.startsWith("segments")) {
            throw this.fillOpenTrace(new IOException("MockDirectoryWrapper: file \"" + name + "\" is still open for writing"), name, false);
        }
        final Directory.IndexInputSlicer delegateHandle = this.delegate.createSlicer(name, context);
        Directory.IndexInputSlicer handle = new Directory.IndexInputSlicer(){
            private boolean isClosed;

            public void close() throws IOException {
                if (!this.isClosed) {
                    delegateHandle.close();
                    MockDirectoryWrapper.this.removeOpenFile((Closeable)((Object)this), name);
                    this.isClosed = true;
                }
            }

            public IndexInput openSlice(String sliceDescription, long offset, long length) throws IOException {
                MockDirectoryWrapper.this.maybeYield();
                MockIndexInputWrapper ii = new MockIndexInputWrapper(MockDirectoryWrapper.this, name, delegateHandle.openSlice(sliceDescription, offset, length));
                MockDirectoryWrapper.this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
                return ii;
            }

            public IndexInput openFullSlice() throws IOException {
                MockDirectoryWrapper.this.maybeYield();
                MockIndexInputWrapper ii = new MockIndexInputWrapper(MockDirectoryWrapper.this, name, delegateHandle.openFullSlice());
                MockDirectoryWrapper.this.addFileHandle((Closeable)((Object)ii), name, Handle.Input);
                return ii;
            }
        };
        this.addFileHandle((Closeable)handle, name, Handle.Slice);
        return handle;
    }

    public static class Failure {
        protected boolean doFail;

        public void eval(MockDirectoryWrapper dir) throws IOException {
        }

        public Failure reset() {
            return this;
        }

        public void setDoFail() {
            this.doFail = true;
        }

        public void clearDoFail() {
            this.doFail = false;
        }
    }

    private static enum Handle {
        Input,
        Output,
        Slice;

    }

    public static enum Throttling {
        ALWAYS,
        SOMETIMES,
        NEVER;

    }
}

