/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class AssertingIndexSearcher
extends IndexSearcher {
    final Random random;

    public AssertingIndexSearcher(Random random, IndexReader r) {
        super(r);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context) {
        super(context);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReader r, ExecutorService ex) {
        super(r, ex);
        this.random = new Random(random.nextLong());
    }

    public AssertingIndexSearcher(Random random, IndexReaderContext context, ExecutorService ex) {
        super(context, ex);
        this.random = new Random(random.nextLong());
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        final Weight w = super.createNormalizedWeight(query);
        return new Weight(){

            public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
                return w.explain(context, doc);
            }

            public Query getQuery() {
                return w.getQuery();
            }

            public void normalize(float norm, float topLevelBoost) {
                throw new IllegalStateException("Weight already normalized.");
            }

            public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
                Scorer scorer;
                block4: {
                    scorer = w.scorer(context, scoreDocsInOrder, topScorer, acceptDocs);
                    if (scorer != null) {
                        try {
                            int docid = scorer.docID();
                            assert (docid == -1 || docid == Integer.MAX_VALUE);
                        }
                        catch (UnsupportedOperationException ignored) {
                            if ($assertionsDisabled || topScorer) break block4;
                            throw new AssertionError();
                        }
                    }
                }
                return scorer;
            }

            public float getValueForNormalization() throws IOException {
                throw new IllegalStateException("Weight already normalized.");
            }

            public boolean scoresDocsOutOfOrder() {
                return w.scoresDocsOutOfOrder();
            }
        };
    }

    protected Query wrapFilter(Query query, Filter filter) {
        if (this.random.nextBoolean()) {
            return super.wrapFilter(query, filter);
        }
        return filter == null ? query : new FilteredQuery(query, filter){

            protected boolean useRandomAccess(Bits bits, int firstFilterDoc) {
                return AssertingIndexSearcher.this.random.nextBoolean();
            }
        };
    }
}

