/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.ByteDocValuesField;
import org.apache.lucene.document.DerefBytesDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.IntDocValuesField;
import org.apache.lucene.document.LongDocValuesField;
import org.apache.lucene.document.PackedLongDocValuesField;
import org.apache.lucene.document.ShortDocValuesField;
import org.apache.lucene.document.SortedBytesDocValuesField;
import org.apache.lucene.document.StraightBytesDocValuesField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;
import org.apache.lucene.util._TestUtil;

public class RandomIndexWriter
implements Closeable {
    public IndexWriter w;
    private final Random r;
    int docCount;
    int flushAt;
    private double flushAtFactor = 1.0;
    private boolean getReaderCalled;
    private final int fixedBytesLength;
    private final long docValuesFieldPrefix;
    private volatile boolean doDocValues;
    private final Codec codec;
    private boolean doRandomForceMerge = true;
    private boolean doRandomForceMergeAssert = true;

    public RandomIndexWriter(Random r, Directory dir) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, new MockAnalyzer(r)));
    }

    public RandomIndexWriter(Random r, Directory dir, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, a));
    }

    public RandomIndexWriter(Random r, Directory dir, Version v, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, v, a));
    }

    public RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c) throws IOException {
        this.r = new Random(r.nextLong());
        this.w = new MockIndexWriter(r, dir, c);
        this.flushAt = _TestUtil.nextInt(r, 10, 1000);
        this.codec = this.w.getConfig().getCodec();
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW config=" + this.w.getConfig());
            System.out.println("codec default=" + this.codec.getName());
        }
        this.fixedBytesLength = 17;
        this.docValuesFieldPrefix = r.nextInt(5);
        this.switchDoDocValues();
        this.doRandomForceMerge = r.nextBoolean();
    }

    private void switchDoDocValues() {
        this.doDocValues = LuceneTestCase.rarely(this.r);
        if (LuceneTestCase.VERBOSE && this.doDocValues) {
            System.out.println("NOTE: RIW: turning on random DocValues fields");
        }
    }

    public <T extends IndexableField> void addDocument(Iterable<T> doc) throws IOException {
        this.addDocument(doc, this.w.getAnalyzer());
    }

    public <T extends IndexableField> void addDocument(final Iterable<T> doc, Analyzer a) throws IOException {
        if (this.doDocValues && doc instanceof Document) {
            this.randomPerDocFieldValues((Document)doc);
        }
        if (this.r.nextInt(5) == 3) {
            this.w.addDocuments(new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            }, a);
        } else {
            this.w.addDocument(doc, a);
        }
        this.maybeCommit();
    }

    private BytesRef getFixedRandomBytes() {
        String randomUnicodeString = _TestUtil.randomFixedByteLengthUnicodeString(this.r, this.fixedBytesLength);
        BytesRef fixedRef = new BytesRef((CharSequence)randomUnicodeString);
        if (fixedRef.length > this.fixedBytesLength) {
            fixedRef = new BytesRef(fixedRef.bytes, 0, this.fixedBytesLength);
        } else {
            fixedRef.grow(this.fixedBytesLength);
            fixedRef.length = this.fixedBytesLength;
        }
        return fixedRef;
    }

    private void randomPerDocFieldValues(Document doc) {
        DerefBytesDocValuesField f;
        DocValues.Type[] values = DocValues.Type.values();
        DocValues.Type type = values[this.r.nextInt(values.length)];
        String name = "random_" + type.name() + "" + this.docValuesFieldPrefix;
        if ("Lucene3x".equals(this.codec.getName()) || doc.getField(name) != null) {
            return;
        }
        switch (type) {
            case BYTES_FIXED_DEREF: {
                f = new DerefBytesDocValuesField(name, this.getFixedRandomBytes(), true);
                break;
            }
            case BYTES_VAR_DEREF: {
                f = new DerefBytesDocValuesField(name, new BytesRef((CharSequence)_TestUtil.randomUnicodeString(this.r, 20)), false);
                break;
            }
            case BYTES_FIXED_STRAIGHT: {
                f = new StraightBytesDocValuesField(name, this.getFixedRandomBytes(), true);
                break;
            }
            case BYTES_VAR_STRAIGHT: {
                f = new StraightBytesDocValuesField(name, new BytesRef((CharSequence)_TestUtil.randomUnicodeString(this.r, 20)), false);
                break;
            }
            case BYTES_FIXED_SORTED: {
                f = new SortedBytesDocValuesField(name, this.getFixedRandomBytes(), true);
                break;
            }
            case BYTES_VAR_SORTED: {
                f = new SortedBytesDocValuesField(name, new BytesRef((CharSequence)_TestUtil.randomUnicodeString(this.r, 20)), false);
                break;
            }
            case FLOAT_32: {
                f = new FloatDocValuesField(name, this.r.nextFloat());
                break;
            }
            case FLOAT_64: {
                f = new DoubleDocValuesField(name, this.r.nextDouble());
                break;
            }
            case VAR_INTS: {
                f = new PackedLongDocValuesField(name, this.r.nextLong());
                break;
            }
            case FIXED_INTS_16: {
                f = new ShortDocValuesField(name, (short)this.r.nextInt(Short.MAX_VALUE));
                break;
            }
            case FIXED_INTS_32: {
                f = new IntDocValuesField(name, this.r.nextInt());
                break;
            }
            case FIXED_INTS_64: {
                f = new LongDocValuesField(name, this.r.nextLong());
                break;
            }
            case FIXED_INTS_8: {
                f = new ByteDocValuesField(name, (byte)this.r.nextInt(128));
                break;
            }
            default: {
                throw new IllegalArgumentException("no such type: " + type);
            }
        }
        doc.add((IndexableField)f);
    }

    private void maybeCommit() throws IOException {
        if (this.docCount++ == this.flushAt) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.add/updateDocument: now doing a commit at docCount=" + this.docCount);
            }
            this.w.commit();
            this.flushAt += _TestUtil.nextInt(this.r, (int)(this.flushAtFactor * 10.0), (int)(this.flushAtFactor * 1000.0));
            if (this.flushAtFactor < 2000000.0) {
                this.flushAtFactor *= 1.05;
            }
            this.switchDoDocValues();
        }
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.w.addDocuments(docs);
        this.maybeCommit();
    }

    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.w.updateDocuments(delTerm, docs);
        this.maybeCommit();
    }

    public <T extends IndexableField> void updateDocument(Term t, final Iterable<T> doc) throws IOException {
        if (this.doDocValues) {
            this.randomPerDocFieldValues((Document)doc);
        }
        if (this.r.nextInt(5) == 3) {
            this.w.updateDocuments(t, new Iterable<Iterable<T>>(){

                @Override
                public Iterator<Iterable<T>> iterator() {
                    return new Iterator<Iterable<T>>(){
                        boolean done;

                        @Override
                        public boolean hasNext() {
                            return !this.done;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Iterable<T> next() {
                            if (this.done) {
                                throw new IllegalStateException();
                            }
                            this.done = true;
                            return doc;
                        }
                    };
                }
            });
        } else {
            this.w.updateDocument(t, doc);
        }
        this.maybeCommit();
    }

    public void addIndexes(Directory ... dirs) throws CorruptIndexException, IOException {
        this.w.addIndexes(dirs);
    }

    public void addIndexes(IndexReader ... readers) throws CorruptIndexException, IOException {
        this.w.addIndexes(readers);
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.w.deleteDocuments(term);
    }

    public void deleteDocuments(Query q) throws CorruptIndexException, IOException {
        this.w.deleteDocuments(q);
    }

    public void commit() throws CorruptIndexException, IOException {
        this.w.commit();
        this.switchDoDocValues();
    }

    public int numDocs() throws IOException {
        return this.w.numDocs();
    }

    public int maxDoc() {
        return this.w.maxDoc();
    }

    public void deleteAll() throws IOException {
        this.w.deleteAll();
    }

    public DirectoryReader getReader() throws IOException {
        return this.getReader(true);
    }

    public void forceMergeDeletes(boolean doWait) throws IOException {
        this.w.forceMergeDeletes(doWait);
    }

    public void forceMergeDeletes() throws IOException {
        this.w.forceMergeDeletes();
    }

    public void setDoRandomForceMerge(boolean v) {
        this.doRandomForceMerge = v;
    }

    public void setDoRandomForceMergeAssert(boolean v) {
        this.doRandomForceMergeAssert = v;
    }

    private void doRandomForceMerge() throws IOException {
        if (this.doRandomForceMerge) {
            int segCount = this.w.getSegmentCount();
            if (this.r.nextBoolean() || segCount == 0) {
                this.w.forceMerge(1);
            } else {
                int limit = _TestUtil.nextInt(this.r, 1, segCount);
                this.w.forceMerge(limit);
                assert (!this.doRandomForceMergeAssert || this.w.getSegmentCount() <= limit) : "limit=" + limit + " actual=" + this.w.getSegmentCount();
            }
        }
        this.switchDoDocValues();
    }

    public DirectoryReader getReader(boolean applyDeletions) throws IOException {
        this.getReaderCalled = true;
        if (this.r.nextInt(20) == 2) {
            this.doRandomForceMerge();
        }
        if (!applyDeletions || !this.codec.getName().equals("Lucene3x") && this.r.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.getReader: use NRT reader");
            }
            if (this.r.nextInt(5) == 1) {
                this.w.commit();
            }
            return this.w.getReader(applyDeletions);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW.getReader: open new reader");
        }
        this.w.commit();
        this.switchDoDocValues();
        if (this.r.nextBoolean()) {
            return DirectoryReader.open((Directory)this.w.getDirectory(), (int)_TestUtil.nextInt(this.r, 1, 10));
        }
        return this.w.getReader(applyDeletions);
    }

    @Override
    public void close() throws IOException {
        if (!this.getReaderCalled && this.r.nextInt(8) == 2) {
            this.doRandomForceMerge();
        }
        this.w.close();
    }

    public void forceMerge(int maxSegmentCount) throws IOException {
        this.w.forceMerge(maxSegmentCount);
    }

    private static final class MockIndexWriter
    extends IndexWriter {
        private final Random r;

        public MockIndexWriter(Random r, Directory dir, IndexWriterConfig conf) throws IOException {
            super(dir, conf);
            this.r = new Random(r.nextLong());
        }

        boolean testPoint(String name) {
            if (this.r.nextInt(4) == 2) {
                Thread.yield();
            }
            return true;
        }
    }
}

