/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;

public class CachingWrapperFilterHelper
extends CachingWrapperFilter {
    private boolean shouldHaveCache = false;

    public CachingWrapperFilterHelper(Filter filter) {
        super(filter);
    }

    public void setShouldHaveCache(boolean shouldHaveCache) {
        this.shouldHaveCache = shouldHaveCache;
    }

    public synchronized DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int saveMissCount = this.missCount;
        DocIdSet docIdSet = super.getDocIdSet(reader);
        if (this.shouldHaveCache) {
            Assert.assertEquals((String)"Cache should have data ", (int)saveMissCount, (int)this.missCount);
        } else {
            Assert.assertTrue((String)("Cache should be null " + docIdSet), (this.missCount > saveMissCount ? 1 : 0) != 0);
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilterHelper(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilterHelper)) {
            return false;
        }
        return this.filter.equals(o);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x5525AACB;
    }
}

