/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatingTokenFilter
extends TokenFilter {
    private int pos;
    private int lastStartOffset;
    private final Map<Integer, Integer> posToStartOffset = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> posToEndOffset = new HashMap<Integer, Integer>();
    private final PositionIncrementAttribute posIncAtt = this.getAttrIfExists(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = this.getAttrIfExists(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = this.getAttrIfExists(OffsetAttribute.class);
    private final CharTermAttribute termAtt = this.getAttrIfExists(CharTermAttribute.class);
    private final boolean offsetsAreCorrect;
    private final String name;

    private <A extends Attribute> A getAttrIfExists(Class<A> att) {
        if (this.hasAttribute(att)) {
            return (A)this.getAttribute(att);
        }
        return null;
    }

    public ValidatingTokenFilter(TokenStream in, String name, boolean offsetsAreCorrect) {
        super(in);
        this.name = name;
        this.offsetsAreCorrect = offsetsAreCorrect;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        int startOffset = 0;
        int endOffset = 0;
        int posLen = 0;
        if (this.posIncAtt != null) {
            this.pos += this.posIncAtt.getPositionIncrement();
            if (this.pos == -1) {
                throw new IllegalStateException("first posInc must be > 0");
            }
        }
        if (this.offsetAtt != null) {
            startOffset = this.offsetAtt.startOffset();
            endOffset = this.offsetAtt.endOffset();
            if (startOffset < 0) {
                throw new IllegalStateException(this.name + ": startOffset=" + startOffset + " is < 0");
            }
            if (endOffset < 0) {
                throw new IllegalStateException(this.name + ": endOffset=" + endOffset + " is < 0");
            }
            if (endOffset < startOffset) {
                throw new IllegalStateException(this.name + ": startOffset=" + startOffset + " is > endOffset=" + endOffset + " pos=" + this.pos + "; token=" + this.termAtt);
            }
            if (this.offsetsAreCorrect && this.offsetAtt.startOffset() < this.lastStartOffset) {
                throw new IllegalStateException(this.name + ": offsets must not go backwards startOffset=" + startOffset + " is < lastStartOffset=" + this.lastStartOffset);
            }
            this.lastStartOffset = this.offsetAtt.startOffset();
        }
        int n = posLen = this.posLenAtt == null ? 1 : this.posLenAtt.getPositionLength();
        if (this.offsetAtt != null && this.posIncAtt != null && this.offsetsAreCorrect) {
            if (!this.posToStartOffset.containsKey(this.pos)) {
                this.posToStartOffset.put(this.pos, startOffset);
            } else {
                int oldStartOffset = this.posToStartOffset.get(this.pos);
                if (oldStartOffset != startOffset) {
                    throw new IllegalStateException(this.name + ": inconsistent startOffset at pos=" + this.pos + ": " + oldStartOffset + " vs " + startOffset + "; token=" + this.termAtt);
                }
            }
            int endPos = this.pos + posLen;
            if (!this.posToEndOffset.containsKey(endPos)) {
                this.posToEndOffset.put(endPos, endOffset);
            } else {
                int oldEndOffset = this.posToEndOffset.get(endPos);
                if (oldEndOffset != endOffset) {
                    throw new IllegalStateException(this.name + ": inconsistent endOffset at pos=" + endPos + ": " + oldEndOffset + " vs " + endOffset + "; token=" + this.termAtt);
                }
            }
        }
        return true;
    }

    public void end() throws IOException {
        super.end();
    }

    public void reset() throws IOException {
        super.reset();
        this.pos = -1;
        this.posToStartOffset.clear();
        this.posToEndOffset.clear();
        this.lastStartOffset = 0;
    }
}

