/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;

public class TokenStreamToDot {
    private final TokenStream in;
    private final CharTermAttribute termAtt;
    private final PositionIncrementAttribute posIncAtt;
    private final PositionLengthAttribute posLengthAtt;
    private final OffsetAttribute offsetAtt;
    private final String inputText;
    protected final PrintWriter out;
    private static final String FONT_NAME = "Helvetica";

    public TokenStreamToDot(String inputText, TokenStream in, PrintWriter out) {
        this.in = in;
        this.out = out;
        this.inputText = inputText;
        this.termAtt = (CharTermAttribute)in.addAttribute(CharTermAttribute.class);
        this.posIncAtt = (PositionIncrementAttribute)in.addAttribute(PositionIncrementAttribute.class);
        this.posLengthAtt = (PositionLengthAttribute)in.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = in.hasAttribute(OffsetAttribute.class) ? (OffsetAttribute)in.addAttribute(OffsetAttribute.class) : null;
    }

    public void toDot() throws IOException {
        this.in.reset();
        this.writeHeader();
        int pos = -1;
        int lastEndPos = -1;
        while (this.in.incrementToken()) {
            boolean isFirst = pos == -1;
            int posInc = this.posIncAtt.getPositionIncrement();
            if (isFirst && posInc == 0) {
                System.err.println("WARNING: first posInc was 0; correcting to 1");
                posInc = 1;
            }
            if (posInc > 0) {
                this.writeNode(pos += posInc, Integer.toString(pos));
            }
            if (posInc > 1) {
                this.writeArc(lastEndPos, pos, null, "dotted");
            }
            if (isFirst) {
                this.writeNode(-1, null);
                this.writeArc(-1, pos, null, null);
            }
            String arcLabel = this.termAtt.toString();
            if (this.offsetAtt != null) {
                int startOffset = this.offsetAtt.startOffset();
                int endOffset = this.offsetAtt.endOffset();
                arcLabel = this.inputText != null ? arcLabel + "  / " + this.inputText.substring(startOffset, endOffset) : arcLabel + " / " + startOffset + "-" + endOffset;
            }
            this.writeArc(pos, pos + this.posLengthAtt.getPositionLength(), arcLabel, null);
            lastEndPos = pos + this.posLengthAtt.getPositionLength();
        }
        this.in.end();
        if (lastEndPos != -1) {
            this.writeNode(-2, null);
            this.writeArc(lastEndPos, -2, null, null);
        }
        this.writeTrailer();
    }

    protected void writeArc(int fromNode, int toNode, String label, String style) {
        this.out.print("  " + fromNode + " -> " + toNode + " [");
        if (label != null) {
            this.out.print(" label=\"" + label + "\"");
        }
        if (style != null) {
            this.out.print(" style=\"" + style + "\"");
        }
        this.out.println("]");
    }

    protected void writeNode(int name, String label) {
        this.out.print("  " + name);
        if (label != null) {
            this.out.print(" [label=\"" + label + "\"]");
        } else {
            this.out.print(" [shape=point color=white]");
        }
        this.out.println();
    }

    protected void writeHeader() {
        this.out.println("digraph tokens {");
        this.out.println("  graph [ fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\" ];");
        this.out.println("  // A2 paper size");
        this.out.println("  size = \"34.4,16.5\";");
        this.out.println("  edge [ fontname=\"Helvetica\" fontcolor=\"red\" color=\"#606060\" ]");
        this.out.println("  node [ style=\"filled\" fillcolor=\"#e8e8f0\" shape=\"Mrecord\" fontname=\"Helvetica\" ]");
        this.out.println();
    }

    protected void writeTrailer() {
        this.out.println("}");
    }
}

