/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;

public class MockCharFilter
extends CharStream {
    final CharStream in;
    final int remainder;
    int currentOffset = -1;
    int delta = 0;
    int bufferedCh = -1;
    TreeMap<Integer, Integer> corrections = new TreeMap();

    public MockCharFilter(Reader in, int remainder) {
        this.in = CharReader.get((Reader)in);
        this.remainder = remainder;
        if (remainder < 0 || remainder >= 10) {
            throw new IllegalArgumentException("invalid remainder parameter (must be 0..10): " + remainder);
        }
    }

    public MockCharFilter(Reader in) {
        this(in, 0);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        if (this.bufferedCh >= 0) {
            int ch = this.bufferedCh;
            this.bufferedCh = -1;
            ++this.currentOffset;
            this.addOffCorrectMap(this.currentOffset, this.delta - 1);
            --this.delta;
            return ch;
        }
        int ch = this.in.read();
        if (ch < 0) {
            return ch;
        }
        ++this.currentOffset;
        if (ch % 10 != this.remainder || Character.isHighSurrogate((char)ch) || Character.isLowSurrogate((char)ch)) {
            return ch;
        }
        this.bufferedCh = ch;
        return ch;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int numRead = 0;
        for (int i = off; i < off + len && (c = this.read()) != -1; ++i) {
            cbuf[i] = (char)c;
            ++numRead;
        }
        return numRead == 0 ? -1 : numRead;
    }

    public int correctOffset(int currentOff) {
        int ret;
        SortedMap<Integer, Integer> subMap = this.corrections.subMap(0, currentOff + 1);
        int n = ret = subMap.isEmpty() ? currentOff : currentOff + (Integer)subMap.get(subMap.lastKey());
        assert (ret >= 0) : "currentOff=" + currentOff + ",diff=" + (ret - currentOff);
        return this.in.correctOffset(ret);
    }

    protected void addOffCorrectMap(int off, int cumulativeDiff) {
        this.corrections.put(off, cumulativeDiff);
    }
}

